/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code.fmt;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.ResourceFile;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;

public final class StaticJavaFile
extends ResourceFile {
    private final GeneratedPackage pkg;
    private final String className;
    private final URL source;
    private final JStaticClass clazz;
    private final LineFilter filter;

    public StaticJavaFile(GeneratedPackage _pkg, String className, String _resourceName) {
        this(_pkg, className, StaticJavaFile.class.getClassLoader().getResource(_resourceName), null);
    }

    public StaticJavaFile(GeneratedPackage _pkg, String _className, URL _source, LineFilter _filter) {
        super(_className + ".java");
        if (_source == null) {
            throw new NullPointerException();
        }
        this.pkg = _pkg;
        this.clazz = new JStaticClass();
        this.className = _className;
        this.source = _source;
        this.filter = _filter;
    }

    public final TypeReference getJClass() {
        return this.clazz;
    }

    @Override
    protected boolean isResource() {
        return false;
    }

    @Override
    protected void build(OutputStream os) throws IOException {
        InputStream is = this.source.openStream();
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        LineFilter filter = this.createLineFilter();
        int lineNumber = 1;
        try {
            String line;
            while ((line = r.readLine()) != null) {
                if ((line = filter.process(line)) != null) {
                    w.println(line);
                }
                ++lineNumber;
            }
        }
        catch (ParseException e) {
            throw new IOException("unable to process " + this.source + " line:" + lineNumber + "\n" + e.getMessage());
        }
        w.close();
        r.close();
    }

    private LineFilter createLineFilter() {
        LineFilter f = new LineFilter(){

            @Override
            public String process(String line) {
                if (!line.startsWith("package ")) {
                    return line;
                }
                if (StaticJavaFile.this.pkg.isUnnamed()) {
                    return null;
                }
                return "package " + StaticJavaFile.this.pkg.name() + ";";
            }
        };
        if (this.filter != null) {
            return new ChainFilter(this.filter, f);
        }
        return f;
    }

    private class JStaticClass
    extends TypeReference {
        private final TypeVariable[] typeParams;

        JStaticClass() {
            super(StaticJavaFile.this.pkg.owner());
            this.typeParams = new TypeVariable[0];
        }

        @Override
        public String name() {
            return StaticJavaFile.this.className;
        }

        @Override
        public String fullName() {
            if (StaticJavaFile.this.pkg.isUnnamed()) {
                return StaticJavaFile.this.className;
            }
            return StaticJavaFile.this.pkg.name() + '.' + StaticJavaFile.this.className;
        }

        @Override
        public GeneratedPackage _package() {
            return StaticJavaFile.this.pkg;
        }

        @Override
        public TypeReference _extends() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<TypeReference> _implements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInterface() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAbstract() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TypeVariable[] typeParams() {
            return this.typeParams;
        }

        @Override
        protected TypeReference substituteParams(TypeVariable[] variables, List<TypeReference> bindings) {
            return this;
        }
    }

    public static final class ChainFilter
    implements LineFilter {
        private final LineFilter first;
        private final LineFilter second;

        public ChainFilter(LineFilter first, LineFilter second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public String process(String line) throws ParseException {
            if ((line = this.first.process(line)) == null) {
                return null;
            }
            return this.second.process(line);
        }
    }

    public static interface LineFilter {
        public String process(String var1) throws ParseException;
    }
}

