/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model.module;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mule.api.annotations.Batch;
import org.mule.api.annotations.InvalidateConnectionOn;
import org.mule.api.annotations.MetaDataScope;
import org.mule.api.annotations.NoMetaData;
import org.mule.api.annotations.Paged;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Query;
import org.mule.api.annotations.QueryPart;
import org.mule.api.annotations.QueryTranslator;
import org.mule.api.annotations.ReconnectOn;
import org.mule.api.annotations.lifecycle.OnException;
import org.mule.api.annotations.oauth.OAuthInvalidateAccessTokenOn;
import org.mule.api.annotations.oauth.OAuthProtected;
import org.mule.api.annotations.param.MetaDataKeyParam;
import org.mule.api.annotations.param.MetaDataKeyParamAffectsType;
import org.mule.api.annotations.param.MetaDataStaticKey;
import org.mule.devkit.apt.components.managers.AbstractComponentManager;
import org.mule.devkit.apt.components.managers.ProcessorComponentManagerImpl;
import org.mule.devkit.apt.model.AnnotationProcessorMethod;
import org.mule.devkit.model.GenericType;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.Component;
import org.mule.devkit.model.module.components.ProcessorComponent;
import org.mule.devkit.model.module.components.managers.ProcessorComponentManager;
import org.mule.devkit.model.module.components.metadatacategory.MetaDataCategoryComponent;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;

public class AnnotationProcessorProcessorMethod
extends AnnotationProcessorMethod<Type>
implements ProcessorMethod {
    private final Module module;

    public AnnotationProcessorProcessorMethod(ExecutableElement element, Type parent, Types types, Elements elements, List<Component> components, Module module) {
        super(element, parent, types, elements, components);
        this.module = module;
    }

    public boolean isIntercepting() {
        return this.getAnnotation(Processor.class).intercepting();
    }

    public boolean isPaged() {
        return this.hasAnnotation(Paged.class);
    }

    public boolean isBatch() {
        return this.hasAnnotation(Batch.class);
    }

    public Paged getPagingAnnotation() {
        return this.getAnnotation(Paged.class);
    }

    public ProcessorComponentManager manager() {
        return new ProcessorComponentManagerImpl(this, AbstractComponentManager.componentsFor(ProcessorComponent.class, this.components));
    }

    public Module module() {
        return this.module;
    }

    public DeclaredType invalidateConnectionOn() {
        return (DeclaredType)this.getAnnotationFieldValue(InvalidateConnectionOn.class, "exception");
    }

    public DeclaredType metaDataScope() {
        return (DeclaredType)this.getAnnotationFieldValue(MetaDataScope.class, "value");
    }

    public DeclaredType invalidateAccessTokenOn() {
        return (DeclaredType)this.getAnnotationFieldValue(OAuthInvalidateAccessTokenOn.class, "exception");
    }

    public List<AnnotationValue> reconnectOn() {
        List<AnnotationValue> exceptions = (List<AnnotationValue>)this.getAnnotationFieldValue(ReconnectOn.class, "exceptions");
        if (exceptions == null) {
            exceptions = Collections.emptyList();
        }
        return exceptions;
    }

    public boolean isOAuthProtected() {
        return this.hasAnnotation(OAuthProtected.class);
    }

    public ManagedConnectionModule getManagedConnectionModule() {
        Object parent = this.parent();
        if (parent instanceof ManagedConnectionModule) {
            return (ManagedConnectionModule)parent;
        }
        List packageTypes = this.parent().getPackage().getTypes();
        for (Type packageType : packageTypes) {
            if (!(packageType instanceof ManagedConnectionModule) || !packageType.inheritsFrom(parent)) continue;
            return (ManagedConnectionModule)packageType;
        }
        return null;
    }

    public boolean canBeUsedInConnectionManagement() {
        return this.getManagedConnectionModule() != null;
    }

    public boolean canBeUsedInOAuthManagement() {
        return this.getOAuthModule() != null;
    }

    public OAuthModule getOAuthModule() {
        Object parent = this.parent();
        if (parent instanceof OAuthModule) {
            return (OAuthModule)parent;
        }
        List packageTypes = this.parent().getPackage().getTypes();
        for (Type packageType : packageTypes) {
            if (!(packageType instanceof OAuthModule) || !packageType.inheritsFrom(parent)) continue;
            return (OAuthModule)packageType;
        }
        return null;
    }

    public boolean hasQuery() {
        for (Parameter p : this.getParameters()) {
            if (!p.hasAnnotation(Query.class)) continue;
            return true;
        }
        return false;
    }

    public Parameter getQueryParameter() {
        for (Parameter p : this.getParameters()) {
            if (!p.hasAnnotation(Query.class)) continue;
            return p;
        }
        return null;
    }

    public boolean hasQueryParts() {
        for (Parameter p : this.getParameters()) {
            if (!p.hasAnnotation(QueryPart.class)) continue;
            return true;
        }
        return false;
    }

    public boolean hasQueryTranslator() {
        return this.hasAnnotation(QueryTranslator.class);
    }

    public boolean hasDynamicMetaData() {
        return this.module.getMinMuleVersion().atLeastBase("3.4") && this.getAnnotation(NoMetaData.class) == null;
    }

    public boolean hasInputOrOutputDynamicMetaData() {
        return this.hasDynamicMetaData() && (this.hasDynamicInputMetadata() || this.hasDynamicOutputMetaData());
    }

    public boolean hasDynamicInputMetadata() {
        Parameter key = this.getInputMetaDataKeyParameter();
        Parameter input = this.getPayloadParameter();
        if (key != null) {
            switch (((MetaDataKeyParam)key.getAnnotation(MetaDataKeyParam.class)).affects()) {
                case AUTO: {
                    return input != null && input.getGenericType() != null && input.getGenericType().hasMetaData();
                }
                case INPUT: 
                case BOTH: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasDynamicOutputMetaData() {
        Parameter key = this.getOutputMetaDataKeyParameter();
        GenericType outputGeneric = this.getReturnGenericType();
        if (key != null) {
            switch (((MetaDataKeyParam)key.getAnnotation(MetaDataKeyParam.class)).affects()) {
                case AUTO: {
                    return outputGeneric != null && outputGeneric.hasMetaData();
                }
                case BOTH: 
                case OUTPUT: {
                    return true;
                }
            }
        }
        return false;
    }

    public Parameter getInputMetaDataKeyParameter() {
        return this.getMetaDataKeyParameter(Arrays.asList(MetaDataKeyParamAffectsType.INPUT, MetaDataKeyParamAffectsType.BOTH, MetaDataKeyParamAffectsType.AUTO));
    }

    public Parameter getOutputMetaDataKeyParameter() {
        return this.getMetaDataKeyParameter(Arrays.asList(MetaDataKeyParamAffectsType.OUTPUT, MetaDataKeyParamAffectsType.BOTH, MetaDataKeyParamAffectsType.AUTO));
    }

    public Parameter getMetaDataKeyParameter(List<MetaDataKeyParamAffectsType> metaDataKeyParamAffectsTypes) {
        for (Parameter key : this.getParameters()) {
            if (!key.hasAnnotation(MetaDataKeyParam.class) || !metaDataKeyParamAffectsTypes.contains(((MetaDataKeyParam)key.getAnnotation(MetaDataKeyParam.class)).affects())) continue;
            return key;
        }
        return null;
    }

    public boolean hasStaticKeyMetaData() {
        return this.hasStaticKeyInputMetaData() || this.hasStaticKeyOutputMetaData();
    }

    public boolean hasStaticKeyInputMetaData() {
        return this.getStaticKeyInputMetaData() != null;
    }

    public Parameter getStaticKeyInputMetaData() {
        for (Parameter param : this.getParameters()) {
            if (!param.hasAnnotation(MetaDataStaticKey.class)) continue;
            return param;
        }
        return null;
    }

    public boolean hasStaticKeyOutputMetaData() {
        return this.getStaticKeyOutputMetaData() != null;
    }

    public MetaDataStaticKey getStaticKeyOutputMetaData() {
        return this.getAnnotation(MetaDataStaticKey.class);
    }

    public boolean hasMetaDataScope() {
        return this.getAnnotation(MetaDataScope.class) != null;
    }

    public Optional<MetaDataCategoryComponent> getMetaDataCategoryComponent() {
        Optional processorMetaDataCategory = this.manager().metaDataCategoryComponent();
        return processorMetaDataCategory.isPresent() ? processorMetaDataCategory : this.module.manager().metaDataCategoryComponent();
    }

    public Optional<DeclaredType> getExceptionHandler() {
        return Optional.fromNullable(this.getAnnotationFieldValue(OnException.class, "handler"));
    }

    @Override
    public String friendlyName() {
        return this.friendlyName(this.getAnnotation(Processor.class).friendlyName());
    }

    @Override
    public String xsdName() {
        return this.xsdName(this.getAnnotation(Processor.class).name());
    }

    public boolean isContainer() {
        for (Parameter p : this.getParameters()) {
            if (!p.asType().isNestedProcessor()) continue;
            return true;
        }
        return false;
    }

    public boolean isContainerList() {
        for (Parameter p : this.getParameters()) {
            if (!p.asType().isArrayOrList() || p.getTypeArguments().size() <= 0 || !((Type)p.getTypeArguments().get(0)).isNestedProcessor()) continue;
            return true;
        }
        return false;
    }
}

