/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model.module;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.apache.commons.lang.WordUtils;
import org.mule.api.MuleContext;
import org.mule.api.annotations.Config;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.ConnectionStrategy;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.ExpressionLanguage;
import org.mule.api.annotations.Filter;
import org.mule.api.annotations.MetaDataScope;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.QueryTranslator;
import org.mule.api.annotations.ReconnectOn;
import org.mule.api.annotations.Source;
import org.mule.api.annotations.TestConnectivity;
import org.mule.api.annotations.Transformer;
import org.mule.api.annotations.TransformerResolver;
import org.mule.api.annotations.licensing.RequiresEnterpriseLicense;
import org.mule.api.annotations.licensing.RequiresEntitlement;
import org.mule.api.annotations.lifecycle.OnException;
import org.mule.api.annotations.lifecycle.Start;
import org.mule.api.annotations.lifecycle.Stop;
import org.mule.api.annotations.rest.RestHttpClient;
import org.mule.api.callback.HttpCallback;
import org.mule.common.MuleVersion;
import org.mule.devkit.apt.components.managers.AbstractComponentManager;
import org.mule.devkit.apt.components.managers.ModuleComponentManagerImpl;
import org.mule.devkit.apt.model.AnnotationProcessorClass;
import org.mule.devkit.apt.model.AnnotationProcessorField;
import org.mule.devkit.apt.model.AnnotationProcessorTypeFactory;
import org.mule.devkit.apt.model.factory.method.AnnotationProcessorFilterFactory;
import org.mule.devkit.apt.model.factory.method.AnnotationProcessorProcessorFactory;
import org.mule.devkit.apt.model.factory.method.AnnotationProcessorRestCallFactory;
import org.mule.devkit.apt.model.factory.method.AnnotationProcessorSourceFactory;
import org.mule.devkit.apt.model.factory.method.AnnotationProcessorTransformerFactory;
import org.mule.devkit.apt.model.factory.method.AnnotationProcessorTransformerResolverFactory;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.FilterMethod;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.SourceMethod;
import org.mule.devkit.model.module.TransformerMethod;
import org.mule.devkit.model.module.TransformerResolverMethod;
import org.mule.devkit.model.module.UnknownLifecyclePhaseException;
import org.mule.devkit.model.module.UnknownModuleKindException;
import org.mule.devkit.model.module.components.Component;
import org.mule.devkit.model.module.components.ModuleComponent;
import org.mule.devkit.model.module.components.managers.ModuleComponentManager;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.rest.RestCall;
import org.mule.devkit.model.visitor.ModelVisitor;
import org.mule.util.StringUtils;

public class AnnotationProcessorModule
extends AnnotationProcessorClass
implements org.mule.devkit.model.module.Module {
    private static final String XSD_EXTENSION = ".xsd";

    public AnnotationProcessorModule(TypeElement innerElement, Types types, Elements elements, List<Component> components) {
        super(innerElement, types, elements, components);
    }

    public org.mule.devkit.model.module.Module parentModule() {
        TypeElement te = (TypeElement)this.types.asElement(((TypeElement)this.innerElement).getSuperclass());
        return new AnnotationProcessorModule(te, this.types, this.elements, (List<Component>)this.components);
    }

    public boolean needsConfig() {
        boolean needsConfig = false;
        for (Field variable : this.getConfigurableFields()) {
            if (variable.hasAnnotation(org.mule.api.annotations.param.Optional.class)) continue;
            needsConfig = true;
        }
        return needsConfig;
    }

    public boolean hasMethodWithName(String methodName) {
        for (ExecutableElement executableElement : ElementFilter.methodsIn(((TypeElement)this.innerElement).getEnclosedElements())) {
            if (!executableElement.getSimpleName().toString().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasQueryTranslator() {
        return this.getQueryTranslatorMethod() != null || this.hasSuperClass() && this.getSuperClass().getMethodsAnnotatedWith(QueryTranslator.class).size() > 0;
    }

    public ModuleComponentManager manager() {
        return new ModuleComponentManagerImpl(this, AbstractComponentManager.componentsFor(ModuleComponent.class, this.components));
    }

    public Optional<Field<Type>> getConfigStrategy() {
        for (Field<Type> field : this.getFields()) {
            if (!field.hasAnnotation(ConnectionStrategy.class) && !field.hasAnnotation(Config.class)) continue;
            return Optional.of(field);
        }
        return Optional.absent();
    }

    public boolean hasProcessorMethodWithParameter(Class<?> parameterType) {
        for (ProcessorMethod method : this.getProcessorMethods()) {
            for (Parameter parameter : method.getParameters()) {
                if (!parameter.asTypeMirror().toString().startsWith(parameterType.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasConfigurableWithType(Class<?> parameterType) {
        for (Field field : this.getConfigurableFields()) {
            if (!field.asTypeMirror().toString().startsWith(parameterType.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean usesPooling() {
        return this.hasAnnotation(Module.class) && this.getAnnotation(Module.class).poolable();
    }

    public Optional<RequiresEntitlement> getRequiresEntitlement() {
        return Optional.fromNullable((Object)this.getAnnotation(RequiresEntitlement.class));
    }

    public Optional<RequiresEnterpriseLicense> getRequiresEnterpriseLicense() {
        return Optional.fromNullable((Object)this.getAnnotation(RequiresEnterpriseLicense.class));
    }

    public MuleVersion getMinMuleVersion() {
        if (this.hasAnnotation(Module.class)) {
            return new MuleVersion(this.getAnnotation(Module.class).minMuleVersion());
        }
        if (this.hasAnnotation(Connector.class)) {
            return new MuleVersion(this.getAnnotation(Connector.class).minMuleVersion());
        }
        if (this.hasAnnotation(ExpressionLanguage.class)) {
            return new MuleVersion(this.getAnnotation(ExpressionLanguage.class).minMuleVersion());
        }
        return null;
    }

    public String getXmlNamespace() {
        String targetNamespace = "";
        if (this.hasAnnotation(Module.class)) {
            targetNamespace = this.getAnnotation(Module.class).namespace();
        }
        if (this.hasAnnotation(Connector.class)) {
            targetNamespace = this.getAnnotation(Connector.class).namespace();
        }
        if (targetNamespace == null || targetNamespace.length() == 0) {
            targetNamespace = "http://www.mulesoft.org/schema/mule/" + this.getModuleName();
        }
        return targetNamespace;
    }

    public String getModuleName() {
        if (this.hasAnnotation(Module.class)) {
            return this.getAnnotation(Module.class).name();
        }
        if (this.hasAnnotation(Connector.class)) {
            return this.getAnnotation(Connector.class).name();
        }
        if (this.hasAnnotation(ExpressionLanguage.class)) {
            return this.getAnnotation(ExpressionLanguage.class).name();
        }
        return null;
    }

    public Optional<String> getKeywords() {
        String value = null;
        if (this.hasAnnotation(Module.class)) {
            value = this.getAnnotation(Module.class).keywords();
        }
        if (this.hasAnnotation(Connector.class)) {
            value = this.getAnnotation(Connector.class).keywords();
        }
        if (StringUtils.isBlank((String)value)) {
            return Optional.absent();
        }
        return Optional.of((Object)value);
    }

    public String getAnnotatedSchemaLocation() {
        if (this.hasAnnotation(Module.class)) {
            return this.getAnnotation(Module.class).schemaLocation();
        }
        if (this.hasAnnotation(Connector.class)) {
            return this.getAnnotation(Connector.class).schemaLocation();
        }
        return null;
    }

    public String getVersionedSchemaLocation() {
        String versionedLocation = this.getAnnotatedSchemaLocation();
        if (versionedLocation == null || versionedLocation.length() == 0) {
            versionedLocation = this.getXmlNamespace() + "/" + this.getModuleSchemaVersion() + "/mule-" + this.getModuleName() + XSD_EXTENSION;
        }
        return versionedLocation;
    }

    public String getCurrentSchemaLocation() {
        String versionedLocation = this.getAnnotatedSchemaLocation();
        if (versionedLocation == null || versionedLocation.length() == 0) {
            versionedLocation = this.getXmlNamespace() + "/current/mule-" + this.getModuleName() + XSD_EXTENSION;
        }
        return versionedLocation;
    }

    public String getModuleSchemaVersion() {
        if (this.hasAnnotation(Module.class)) {
            return this.getAnnotation(Module.class).schemaVersion();
        }
        if (this.hasAnnotation(Connector.class)) {
            return this.getAnnotation(Connector.class).schemaVersion();
        }
        return null;
    }

    public String getFriendlyName() {
        String friendlyName = null;
        if (this.hasAnnotation(Module.class)) {
            friendlyName = this.getAnnotation(Module.class).friendlyName();
        }
        if (this.hasAnnotation(Connector.class)) {
            friendlyName = this.getAnnotation(Connector.class).friendlyName();
        }
        if (StringUtils.isBlank((String)friendlyName)) {
            friendlyName = WordUtils.capitalizeFully((String)this.getModuleName().replaceAll("-", " "));
        }
        return friendlyName;
    }

    public String getDescription() {
        if (this.hasAnnotation(Module.class)) {
            return this.getAnnotation(Module.class).description();
        }
        if (this.hasAnnotation(Connector.class)) {
            return this.getAnnotation(Connector.class).description();
        }
        return null;
    }

    public List<SourceMethod> getSourceMethods() {
        return this.getRecursivelyMethodsAnnotatedWith(Source.class, new AnnotationProcessorSourceFactory());
    }

    public List<ProcessorMethod> getProcessorMethods() {
        return this.getRecursivelyMethodsAnnotatedWith(Processor.class, new AnnotationProcessorProcessorFactory(this));
    }

    public boolean isConnector() {
        return this.hasAnnotation(Connector.class);
    }

    public boolean isModule() {
        return this.hasAnnotation(Module.class);
    }

    public boolean hasDynamicMetadata() {
        if (!this.getMinMuleVersion().atLeastBase("3.4")) {
            return false;
        }
        if (this.getMetaDataRetrieverMethod() != null && this.getMetaDataKeyRetrieverMethod() != null) {
            return true;
        }
        if (this.manager().metaDataCategoryComponent().isPresent() || this.hasProcessorsAnnotatedWithMetaDataScope(this)) {
            return true;
        }
        return !this.manager().wsdlProviderComponent().isEmpty();
    }

    private boolean hasProcessorsAnnotatedWithMetaDataScope(org.mule.devkit.model.module.Module module) {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            if (!processorMethod.manager().metaDataCategoryComponent().isPresent()) continue;
            return true;
        }
        return false;
    }

    public List<FilterMethod> getFilterMethods() {
        return this.getRecursivelyMethodsAnnotatedWith(Filter.class, new AnnotationProcessorFilterFactory());
    }

    public List<TransformerMethod> getTransformerMethods() {
        return this.getRecursivelyMethodsAnnotatedWith(Transformer.class, new AnnotationProcessorTransformerFactory());
    }

    public List<TransformerResolverMethod> getTransformerResolverMethods() {
        return this.getRecursivelyMethodsAnnotatedWith(TransformerResolver.class, new AnnotationProcessorTransformerResolverFactory());
    }

    public List<Field> getConfigurableFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        TypeElement current = (TypeElement)this.innerElement;
        while (current != null) {
            for (VariableElement variableElement : ElementFilter.fieldsIn(current.getEnclosedElements())) {
                if (variableElement.getAnnotation(Configurable.class) == null) continue;
                if (current == this.innerElement) {
                    fields.add(new AnnotationProcessorField<AnnotationProcessorModule>(variableElement, this, this.types, this.elements));
                    continue;
                }
                Object type = AnnotationProcessorTypeFactory.createType(current, this.types, this.elements, this.components);
                fields.add(new AnnotationProcessorField(variableElement, type, this.types, this.elements));
            }
            current = (TypeElement)this.types.asElement(current.getSuperclass());
        }
        return fields;
    }

    public ModuleKind getKind() {
        if (this.hasAnnotation(Connector.class)) {
            return ModuleKind.CONNECTOR;
        }
        if (this.hasAnnotation(Module.class)) {
            return ModuleKind.GENERIC;
        }
        if (this.hasAnnotation(ExpressionLanguage.class)) {
            return ModuleKind.EXPRESSION_LANGUAGE;
        }
        throw new UnknownModuleKindException();
    }

    public boolean hasSources() {
        return this.getSourceMethods().size() > 0;
    }

    public boolean hasProcessors() {
        return this.getProcessorMethods().size() > 0;
    }

    public boolean hasFilters() {
        return this.getFilterMethods().size() > 0;
    }

    public boolean hasTransformers() {
        return this.getTransformerMethods().size() > 0;
    }

    public Method getLifecycleMethod(String phaseName) {
        Class<Start> anAnnotation = null;
        if (phaseName.equals("start")) {
            anAnnotation = Start.class;
        } else if (phaseName.equals("stop")) {
            anAnnotation = Stop.class;
        } else if (phaseName.equals("initialise")) {
            anAnnotation = PostConstruct.class;
        } else if (phaseName.equals("dispose")) {
            anAnnotation = PreDestroy.class;
        }
        if (anAnnotation == null) {
            throw new UnknownLifecyclePhaseException();
        }
        return this.getRecursivelyFirstMethodAnnotatedWith(anAnnotation);
    }

    public String getConfigElementName() {
        if (this.hasAnnotation(Module.class)) {
            return ((TypeElement)this.innerElement).getAnnotation(Module.class).configElementName();
        }
        if (this.hasAnnotation(Connector.class)) {
            return ((TypeElement)this.innerElement).getAnnotation(Connector.class).configElementName();
        }
        return null;
    }

    public Field getRestHttpClientField() {
        TypeElement current = (TypeElement)this.innerElement;
        while (current != null) {
            for (VariableElement variableElement : ElementFilter.fieldsIn(current.getEnclosedElements())) {
                if (variableElement.getAnnotation(RestHttpClient.class) == null) continue;
                if (current == this.innerElement) {
                    return new AnnotationProcessorField<AnnotationProcessorModule>(variableElement, this, this.types, this.elements);
                }
                Object type = AnnotationProcessorTypeFactory.createType(current, this.types, this.elements, this.components);
                return new AnnotationProcessorField(variableElement, type, this.types, this.elements);
            }
            current = (TypeElement)this.types.asElement(current.getSuperclass());
        }
        return null;
    }

    public List<RestCall> getRestCalls() {
        return this.getRecursivelyMethodsAnnotatedWith(org.mule.api.annotations.rest.RestCall.class, new AnnotationProcessorRestCallFactory(this));
    }

    public boolean hasRestCalls() {
        return this.getRestCalls().size() > 0;
    }

    public boolean hasTransformerResolver() {
        return this.getTransformerResolverMethods().size() > 0;
    }

    @Override
    public void accept(ModelVisitor visitor) {
        if (!visitor.hasVisited((Identifiable)this)) {
            visitor.visit((org.mule.devkit.model.module.Module)this);
            for (Field field : this.getConfigurableFields()) {
                field.accept(visitor);
            }
            for (ProcessorMethod processorMethod : this.getProcessorMethods()) {
                processorMethod.accept(visitor);
            }
            for (FilterMethod filterMethod : this.getFilterMethods()) {
                filterMethod.accept(visitor);
            }
            for (SourceMethod sourceMethod : this.getSourceMethods()) {
                sourceMethod.accept(visitor);
            }
            for (TransformerMethod transformerMethod : this.getTransformerMethods()) {
                transformerMethod.accept(visitor);
            }
        }
    }

    public Method getQueryTranslatorMethod() {
        return this.getRecursivelyFirstMethodAnnotatedWith(QueryTranslator.class);
    }

    public DeclaredType metaDataScope() {
        return (DeclaredType)this.getAnnotationFieldValue(MetaDataScope.class, "value");
    }

    public boolean hasMetaDataScope() {
        return this.hasAnnotation(MetaDataScope.class);
    }

    public List<AnnotationValue> reconnectOn() {
        List<AnnotationValue> exceptions = (List<AnnotationValue>)this.getAnnotationFieldValue(ReconnectOn.class, "exceptions");
        if (exceptions == null) {
            exceptions = Collections.emptyList();
        }
        return exceptions;
    }

    public Optional<Method> testConnectivityMethod() {
        Method result = null;
        Method testConnectivityMethod = this.getRecursivelyFirstMethodAnnotatedWith(TestConnectivity.class);
        if (testConnectivityMethod != null && ((TestConnectivity)testConnectivityMethod.getAnnotation(TestConnectivity.class)).active()) {
            result = testConnectivityMethod;
        }
        return Optional.fromNullable(result);
    }

    public Optional<Field> setMuleContext() {
        for (Field field : this.getInjectFields()) {
            if (!field.asTypeMirror().toString().startsWith(MuleContext.class.getName())) continue;
            return Optional.of((Object)field);
        }
        return Optional.absent();
    }

    public Optional<Method> startable() {
        return Optional.fromNullable((Object)this.getLifecycleMethod("start"));
    }

    public Optional<Method> stoppable() {
        return Optional.fromNullable((Object)this.getLifecycleMethod("stop"));
    }

    public boolean requiresEnterpriseLicense() {
        return this.hasAnnotation(RequiresEnterpriseLicense.class) || this.hasAnnotation(RequiresEntitlement.class) || !this.manager().wsdlProviderComponent().isEmpty();
    }

    public Optional<DeclaredType> getExceptionHandler() {
        return Optional.fromNullable(this.getAnnotationFieldValue(OnException.class, "handler"));
    }

    public boolean isConfigless() {
        return this.manager().connectionComponents().isEmpty() && this.getConfigurableFields().isEmpty() && !(this instanceof ManagedConnectionModule) && !(this instanceof OAuthModule) && !this.hasProcessorMethodWithParameter(HttpCallback.class);
    }
}

