/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model;

import com.google.common.base.Optional;
import java.lang.annotation.Annotation;
import java.util.Collections;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mule.api.annotations.components.Configuration;
import org.mule.api.annotations.components.Handler;
import org.mule.api.annotations.components.MetaDataCategory;
import org.mule.api.annotations.components.WsdlProvider;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.devkit.apt.components.OnExceptionHandler;
import org.mule.devkit.apt.components.connection.ConnectionManagement;
import org.mule.devkit.apt.components.connection.HttpBasicAuth;
import org.mule.devkit.apt.model.AnnotationProcessorClass;
import org.mule.devkit.model.module.components.Component;

public class ComponentTypeFactory {
    public static Optional<Component> createComponent(TypeElement type, Types typeUtils, Elements elementUtils) {
        AnnotationProcessorClass res = null;
        if (ComponentTypeFactory.isMetaDataComponent(type)) {
            res = new org.mule.devkit.apt.components.metadatacategory.MetaDataCategory(type, typeUtils, elementUtils, Collections.emptyList());
        }
        if (ComponentTypeFactory.isConnectionManagementComponent(type)) {
            res = new ConnectionManagement(type, typeUtils, elementUtils, Collections.emptyList());
        }
        if (ComponentTypeFactory.isOAuth2Component(type)) {
            res = new org.mule.devkit.apt.components.connection.OAuth2(type, typeUtils, elementUtils, Collections.emptyList());
        }
        if (ComponentTypeFactory.isHttpBasicAuthComponent(type)) {
            res = new HttpBasicAuth(type, typeUtils, elementUtils, Collections.emptyList());
        }
        if (ComponentTypeFactory.isBasicComponent(type)) {
            res = new org.mule.devkit.apt.components.connection.Configuration(type, typeUtils, elementUtils, Collections.emptyList());
        }
        if (ComponentTypeFactory.isWsdlComponent(type)) {
            res = new org.mule.devkit.apt.components.connection.WsdlProvider(type, typeUtils, elementUtils, Collections.emptyList());
        }
        if (ComponentTypeFactory.isExceptionHandler(type)) {
            res = new OnExceptionHandler(type, typeUtils, elementUtils, Collections.emptyList());
        }
        return Optional.fromNullable((Object)res);
    }

    private static boolean isMetaDataComponent(TypeElement innerElement) {
        return ComponentTypeFactory.hasAnnotation(innerElement, MetaDataCategory.class) || ComponentTypeFactory.hasAnnotation(innerElement, org.mule.api.annotations.MetaDataCategory.class);
    }

    private static boolean isConnectionManagementComponent(TypeElement innerElement) {
        return ComponentTypeFactory.hasAnnotation(innerElement, org.mule.api.annotations.components.ConnectionManagement.class);
    }

    private static boolean isOAuth2Component(TypeElement innerElement) {
        return ComponentTypeFactory.hasAnnotation(innerElement, OAuth2.class);
    }

    private static boolean isHttpBasicAuthComponent(TypeElement innerElement) {
        return ComponentTypeFactory.hasAnnotation(innerElement, org.mule.api.annotations.components.HttpBasicAuth.class);
    }

    private static boolean isBasicComponent(TypeElement innerElement) {
        return ComponentTypeFactory.hasAnnotation(innerElement, Configuration.class);
    }

    private static boolean isWsdlComponent(TypeElement innerElement) {
        return ComponentTypeFactory.hasAnnotation(innerElement, WsdlProvider.class);
    }

    private static boolean isExceptionHandler(TypeElement innerElement) {
        return ComponentTypeFactory.hasAnnotation(innerElement, Handler.class);
    }

    private static boolean hasAnnotation(TypeElement innerElement, Class<? extends Annotation> annotation) {
        return innerElement.getAnnotation(annotation) != null;
    }
}

