/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.display.FriendlyName;
import org.mule.devkit.apt.model.AnnotationProcessorIdentifiable;
import org.mule.devkit.apt.model.AnnotationProcessorParameter;
import org.mule.devkit.apt.model.factory.FactoryHolder;
import org.mule.devkit.model.GenericType;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.components.Component;
import org.mule.devkit.model.visitor.ModelVisitor;
import org.mule.devkit.utils.NameUtils;

public class AnnotationProcessorMethod<P extends Type>
extends AnnotationProcessorIdentifiable<ExecutableElement>
implements Method<P> {
    protected P parent;

    public AnnotationProcessorMethod(ExecutableElement element, P parent, Types types, Elements elements, List<Component> components) {
        super(element, types, elements, components);
        this.parent = parent;
    }

    public AnnotationProcessorMethod(ExecutableElement element, P parent, Types types, Elements elements) {
        super(element, types, elements, new ArrayList<Component>());
        this.parent = parent;
    }

    public List<Parameter<Method<P>>> getParameters() {
        ArrayList<Parameter<Method<P>>> parameters = new ArrayList<Parameter<Method<P>>>();
        for (VariableElement variableElement : ((ExecutableElement)this.innerElement).getParameters()) {
            parameters.add(new AnnotationProcessorParameter<AnnotationProcessorMethod>(variableElement, this, this.types, this.elements));
        }
        return parameters;
    }

    public List<? extends TypeMirror> getThrownTypes() {
        return ((ExecutableElement)this.innerElement).getThrownTypes();
    }

    public TypeMirror getReturnType() {
        return ((ExecutableElement)this.innerElement).getReturnType();
    }

    public GenericType getReturnGenericType() {
        return (GenericType)FactoryHolder.getGenericTypeFactory().createGenericType(this.getReturnType(), this.types, this.elements, this.innerElement, this.getName()).get();
    }

    public boolean hasReturnGenericType(Class<?> clazz) {
        GenericType type = this.getReturnGenericType();
        return type.getElement().isPresent() && type.is(clazz.getSimpleName());
    }

    public Parameter getPayloadParameter() {
        for (Parameter<Method<P>> parameter : this.getParameters()) {
            if (!parameter.isPayload()) continue;
            return parameter;
        }
        return null;
    }

    public String friendlyName() {
        return this.friendlyName(null);
    }

    public String friendlyName(String friendlyName) {
        if (StringUtils.isNotBlank((String)friendlyName)) {
            return friendlyName;
        }
        if (this.hasAnnotation(FriendlyName.class)) {
            return this.getAnnotation(FriendlyName.class).value();
        }
        return NameUtils.friendlyNameFromCamelCase((String)this.getName());
    }

    public String xsdName() {
        return this.xsdName(null);
    }

    public String xsdName(String name) {
        return StringUtils.isBlank((String)name) ? NameUtils.uncamel((String)this.getName()) : NameUtils.uncamel((String)name);
    }

    public List<? extends TypeParameterElement> getTypeParameters() {
        return ((ExecutableElement)this.innerElement).getTypeParameters();
    }

    public boolean hasOnlyOneChildElement() {
        int requiredChildElements = 0;
        for (Parameter<Method<P>> variable : this.getParameters()) {
            if (variable.shouldBeIgnored()) continue;
            if (variable.asType().isNestedProcessor() || variable.asType().isArrayOrList() && variable.getTypeArguments().size() > 0 && ((Type)variable.getTypeArguments().get(0)).isNestedProcessor()) {
                ++requiredChildElements;
                continue;
            }
            if (!variable.asType().isCollection()) continue;
            ++requiredChildElements;
        }
        return requiredChildElements == 1;
    }

    public String getCapitalizedName() {
        return StringUtils.capitalize((String)this.getName());
    }

    public P parent() {
        return this.parent;
    }

    public void accept(ModelVisitor visitor) {
        if (!visitor.hasVisited((Identifiable)this)) {
            visitor.visit((Method)this);
            for (Parameter<Method<P>> parameter : this.getParameters()) {
                parameter.accept(visitor);
            }
        }
    }
}

