/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.components.managers;

import com.google.common.base.Optional;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.devkit.apt.components.managers.AbstractComponentManager;
import org.mule.devkit.apt.components.managers.ComponentCallbackValidator;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.ModuleComponent;
import org.mule.devkit.model.module.components.connection.ConfigurationComponent;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.components.connection.HttpBasicAuthComponent;
import org.mule.devkit.model.module.components.connection.OAuth2Component;
import org.mule.devkit.model.module.components.connection.WsdlProviderComponent;
import org.mule.devkit.model.module.components.exceptionhandler.OnExceptionHandlerComponent;
import org.mule.devkit.model.module.components.managers.ModuleComponentManager;
import org.mule.devkit.model.module.components.metadatacategory.MetaDataCategoryComponent;

public class ModuleComponentManagerImpl
extends AbstractComponentManager
implements ModuleComponentManager {
    private Module module;

    public ModuleComponentManagerImpl(Module module, List<ModuleComponent> components) {
        super(components);
        this.module = module;
    }

    public Optional<MetaDataCategoryComponent> metaDataCategoryComponent() {
        return this.componentFor(MetaDataCategoryComponent.class);
    }

    public Set<MetaDataCategoryComponent> metaDataCategoryComponents() {
        HashSet<MetaDataCategoryComponent> metaDataCategoryComponents = new HashSet<MetaDataCategoryComponent>();
        if (this.metaDataCategoryComponent().isPresent()) {
            metaDataCategoryComponents.add((MetaDataCategoryComponent)this.metaDataCategoryComponent().get());
        }
        for (ProcessorMethod processorMethod : this.module.getProcessorMethods()) {
            if (!processorMethod.manager().metaDataCategoryComponent().isPresent()) continue;
            metaDataCategoryComponents.add((MetaDataCategoryComponent)processorMethod.manager().metaDataCategoryComponent().get());
        }
        return metaDataCategoryComponents;
    }

    public List<ConnectionManagementComponent> connectionManagementComponents() {
        return this.componentsFor(ConnectionManagementComponent.class);
    }

    public List<OAuth2Component> oauth2Components() {
        return this.componentsFor(OAuth2Component.class);
    }

    public Optional<OAuth2Component> oauth2Component() {
        return this.componentFor(OAuth2Component.class);
    }

    public Optional<HttpBasicAuthComponent> httpBasicAuthComponent() {
        return this.componentFor(HttpBasicAuthComponent.class);
    }

    public List<WsdlProviderComponent> wsdlProviderComponent() {
        return this.componentsFor(WsdlProviderComponent.class);
    }

    public List<ConfigurationComponent> configurationComponents() {
        return this.componentsFor(ConfigurationComponent.class);
    }

    public List<ConnectionComponent> connectionComponents() {
        return this.componentsFor(ConnectionComponent.class);
    }

    public Optional<ConnectionManagementComponent> connectionManagementOverride() {
        for (ConnectionManagementComponent connectionManagementComponent : this.connectionManagementComponents()) {
            if (!connectionManagementComponent.overridesAtMessageProcessor()) continue;
            return Optional.of((Object)connectionManagementComponent);
        }
        return Optional.absent();
    }

    public Optional<OnExceptionHandlerComponent> handlerComponent() {
        return this.componentFor(OnExceptionHandlerComponent.class);
    }

    public boolean hasConnectionManagedWsdlProvider() {
        for (WsdlProviderComponent component : this.wsdlProviderComponent()) {
            if (!component.hasConnectionManagement()) continue;
            return true;
        }
        return false;
    }

    public boolean hasConnectionManagement() {
        return !this.connectionManagementComponents().isEmpty();
    }

    @Override
    protected ComponentCallbackValidator<ModuleComponent> getValidator() {
        return new ComponentCallbackValidator<ModuleComponent>(){

            @Override
            public boolean accepts(ModuleComponent component) {
                return component.handle(ModuleComponentManagerImpl.this.getModule());
            }
        };
    }

    public Module getModule() {
        return this.module;
    }
}

