/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.components.managers;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import org.mule.devkit.apt.components.managers.ComponentCallbackValidator;
import org.mule.devkit.model.module.components.Component;

public abstract class AbstractComponentManager {
    private List<? extends Component> components;

    public AbstractComponentManager(List<? extends Component> components) {
        this.components = components;
    }

    protected <T extends Component> Optional<T> componentFor(Class<? extends Component> clazz) {
        Component result = null;
        for (Component component : this.getComponents()) {
            if (!clazz.isAssignableFrom(component.getClass()) || !this.getValidator().accepts(component)) continue;
            result = component;
            break;
        }
        return Optional.fromNullable(result);
    }

    protected <T extends Component> List<T> componentsFor(Class<T> clazz) {
        ArrayList<Component> res = new ArrayList<Component>();
        for (Component component : this.components) {
            if (!clazz.isAssignableFrom(component.getClass()) || !this.getValidator().accepts(component)) continue;
            res.add(component);
        }
        return res;
    }

    public static <T extends Component> List<T> componentsFor(Class<T> clazz, List<? extends Component> components) {
        ArrayList<Component> res = new ArrayList<Component>();
        for (Component component : components) {
            if (!clazz.isAssignableFrom(component.getClass())) continue;
            res.add(component);
        }
        return res;
    }

    protected abstract ComponentCallbackValidator getValidator();

    protected List<? extends Component> getComponents() {
        return this.components;
    }

    protected void setComponents(List<? extends Component> components) {
        this.components = components;
    }
}

