/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.components.connection;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.components.ConnectionManagement;
import org.mule.api.annotations.ws.WsdlBodyEnricher;
import org.mule.api.annotations.ws.WsdlHeaders;
import org.mule.api.annotations.ws.WsdlSecurity;
import org.mule.api.annotations.ws.WsdlServiceEndpoint;
import org.mule.api.annotations.ws.WsdlServiceRetriever;
import org.mule.api.annotations.ws.WsdlTransportRetriever;
import org.mule.devkit.apt.components.connection.utils.ModuleComponentUtils;
import org.mule.devkit.apt.model.module.AnnotationProcessorModule;
import org.mule.devkit.apt.model.module.connectivity.AnnotationProcessorConnectMethod;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.Component;
import org.mule.devkit.model.module.components.ModuleComponent;
import org.mule.devkit.model.module.components.connection.WsdlProviderComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;

public class WsdlProvider
extends AnnotationProcessorModule
implements WsdlProviderComponent,
ModuleComponent,
ManagedConnectionModule {
    public WsdlProvider(TypeElement innerElement, Types types, Elements elements, List<Component> components) {
        super(innerElement, types, elements, components);
    }

    public boolean handle(Module module) {
        return ModuleComponentUtils.handle(module, this.types, this);
    }

    public String configElementName() {
        return this.getWsdlProviderConcreteAnnotation().configElementName();
    }

    public String friendlyName() {
        return this.getWsdlProviderConcreteAnnotation().friendlyName();
    }

    public Method wsdlServiceRetrieverMethod() {
        return this.getFirstMethodAnnotatedWith(WsdlServiceRetriever.class);
    }

    public Method wsdlServiceEndpointMethod() {
        return this.getFirstMethodAnnotatedWith(WsdlServiceEndpoint.class);
    }

    public String keySeparator() {
        return this.getWsdlServiceDefinitionAnnotation().keySeparator();
    }

    public List<String> keyLabels() {
        String[] array = this.getWsdlServiceDefinitionAnnotation().keyLabels();
        if (array.length == 0) {
            String[] stringArray;
            if (this.hasMultipleServiceDefinition()) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "Service";
                stringArray = stringArray2;
                stringArray2[1] = "Operation";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "Operation";
            }
            array = stringArray;
        }
        return Arrays.asList(array);
    }

    public String plainedKeyLabels() {
        return StringUtils.join(this.keyLabels(), (String)",");
    }

    public Optional<Method> wsdlSecurityResolver() {
        Method wsdlTokenXmlSeparatorMethod = this.getFirstMethodAnnotatedWith(WsdlSecurity.class);
        return Optional.fromNullable(wsdlTokenXmlSeparatorMethod);
    }

    public Optional<Method> wsdlTransportResolver() {
        Method wsdlTokenXmlSeparatorMethod = this.getFirstMethodAnnotatedWith(WsdlTransportRetriever.class);
        return Optional.fromNullable(wsdlTokenXmlSeparatorMethod);
    }

    public Optional<Method> wsdlHeadersResolver() {
        Method headers = this.getFirstMethodAnnotatedWith(WsdlHeaders.class);
        return Optional.fromNullable(headers);
    }

    public Optional<Method> wsdlBodyEnricher() {
        Method bodyEnricher = this.getFirstMethodAnnotatedWith(WsdlBodyEnricher.class);
        return Optional.fromNullable(bodyEnricher);
    }

    public boolean hasMultipleServiceDefinition() {
        return this.wsdlServiceRetrieverMethod().getReturnType().toString().contains("List");
    }

    private WsdlServiceRetriever getWsdlServiceDefinitionAnnotation() {
        return (WsdlServiceRetriever)this.wsdlServiceRetrieverMethod().getAnnotation(WsdlServiceRetriever.class);
    }

    private org.mule.api.annotations.components.WsdlProvider getWsdlProviderConcreteAnnotation() {
        return this.getAnnotation(org.mule.api.annotations.components.WsdlProvider.class);
    }

    public boolean hasConnectionManagement() {
        return this.hasAnnotation(ConnectionManagement.class);
    }

    public ConnectMethod getConnectMethod() {
        TypeElement current = (TypeElement)this.innerElement;
        while (current != null) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(current.getEnclosedElements())) {
                if (executableElement.getAnnotation(Connect.class) == null) continue;
                return new AnnotationProcessorConnectMethod(executableElement, this, this.types, this.elements);
            }
            current = (TypeElement)this.types.asElement(current.getSuperclass());
        }
        return null;
    }

    public Method<ManagedConnectionModule> getDisconnectMethod() {
        return this.getFirstMethodAnnotatedWith(Disconnect.class);
    }

    public Method<ManagedConnectionModule> getValidateConnectionMethod() {
        return this.getFirstMethodAnnotatedWith(ValidateConnection.class);
    }

    public Optional<Method<ManagedConnectionModule>> getConnectionIdentifierMethod() {
        Method identifier = this.getFirstMethodAnnotatedWith(ConnectionIdentifier.class);
        return Optional.fromNullable(identifier);
    }
}

