/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.devkit.apt.dependency.SimpleDependency;
import org.mule.devkit.generation.api.ConnectorCategory;
import org.mule.devkit.generation.api.Dependency;
import org.mule.devkit.generation.api.License;
import org.mule.devkit.generation.api.MavenInformation;
import org.mule.devkit.generation.utils.SerializationUtils;

public class AnnotationProcessorMavenInformation
implements MavenInformation {
    private String srcDirectory;
    private String artifactId;
    private String groupId;
    private String version;
    private License license;
    private String outputDirectory;
    private String buildDirectory;
    private String name;
    private Boolean generateApidocs;
    private String connectorJavadocs;
    private String url;
    private String category;
    private Set<Dependency> dependencies;

    public static AnnotationProcessorMavenInformation createFromMavenInformationMap(Map<String, ? extends Serializable> mavenInformationMap) {
        String groupId = (String)((Object)mavenInformationMap.get("mavenGroupId"));
        String artifactId = (String)((Object)mavenInformationMap.get("mavenArtifactId"));
        String version = (String)((Object)mavenInformationMap.get("mavenVersion"));
        String outputDirectory = (String)((Object)mavenInformationMap.get("mavenOutputDirectory"));
        String srcDirectory = (String)((Object)mavenInformationMap.get("mavenSrcDirectory"));
        String buildDirectory = (String)((Object)mavenInformationMap.get("mavenBuildDirectory"));
        String licenseFile = (String)((Object)mavenInformationMap.get("mavenLicense"));
        String name = (String)((Object)mavenInformationMap.get("mavenName"));
        Boolean generateApidocs = (Boolean)mavenInformationMap.get("generateApidocs");
        String connectorJavadocs = (String)((Object)mavenInformationMap.get("connectorJavadocs"));
        String url = (String)((Object)mavenInformationMap.get("url"));
        String category = mavenInformationMap.get("mavenCategory") != null ? (String)((Object)mavenInformationMap.get("mavenCategory")) : ConnectorCategory.COMMUNITY.getCategory();
        List stringDependencies = (List)((Object)mavenInformationMap.get("mavenDependencies"));
        return new AnnotationProcessorMavenInformation(artifactId, groupId, version, name, outputDirectory, buildDirectory, srcDirectory, licenseFile, category, generateApidocs, connectorJavadocs, url, SimpleDependency.createDependencies(stringDependencies));
    }

    private AnnotationProcessorMavenInformation(String artifactId, String groupId, String version, String name, String outputDirectory, String buildDirectory, String srcDirectory, String licenseFilePath, String category, Boolean generateApidocs, String connectorJavadocs, String url, Set<Dependency> dependencies) {
        this.artifactId = artifactId;
        this.groupId = groupId;
        this.version = version;
        this.name = name;
        this.outputDirectory = outputDirectory;
        this.buildDirectory = buildDirectory;
        this.srcDirectory = srcDirectory;
        this.generateApidocs = generateApidocs;
        this.url = url;
        this.connectorJavadocs = connectorJavadocs;
        this.category = "null".equals(category) ? null : category;
        File licenseFile = new File(licenseFilePath);
        this.license = (License)SerializationUtils.load((File)licenseFile);
        this.dependencies = dependencies;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public License getLicense() {
        return this.license;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getBuildDirectory() {
        return this.buildDirectory;
    }

    public String getSrcDirectory() {
        return this.srcDirectory;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getUrl() {
        return this.url;
    }

    public Boolean getShouldGenerateApidocs() {
        return this.generateApidocs;
    }

    public String getConnectorJavadocURL() {
        return this.connectorJavadocs;
    }

    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }
}

