/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.mule.functional.api.component.AssertionMessageProcessor;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.InvalidExpressionException;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.tck.processor.FlowAssert;
import org.mule.tck.processor.FlowAssertion;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;

public class ResponseAssertionMessageProcessor
extends AssertionMessageProcessor
implements InterceptingMessageProcessor,
Startable {
    private static final ThreadLocal<String> taskTokenInThread = new ThreadLocal();
    protected String responseExpression = "#[true]";
    private int responseCount = 1;
    private boolean responseSameTask = true;
    private Processor next;
    private String requestTaskToken;
    private String responseTaskToken;
    private String responseStackTrace;
    private CountDownLatch responseLatch;
    private int responseInvocationCount = 0;
    private boolean responseResult = true;

    @Override
    public void start() throws InitialisationException {
        super.start();
        ValidationResult result = this.expressionManager.validate(this.responseExpression);
        if (!result.isSuccess()) {
            throw new InvalidExpressionException(this.expression, result.errorMessage().orElse("Invalid expression"));
        }
        this.responseLatch = new CountDownLatch(this.responseCount);
        FlowAssert.addAssertion((String)this.getLocation().getRootContainerName(), (FlowAssertion)this);
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        if (event == null) {
            return null;
        }
        return this.processResponse(this.processNext(this.processRequest(event)));
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return MessageProcessors.map((Publisher)MessageProcessors.transform((Publisher)MessageProcessors.map(publisher, event -> {
            try {
                return this.processRequest((CoreEvent)event);
            }
            catch (MuleException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }), (ReactiveProcessor)this.next), event -> {
            try {
                return this.processResponse((CoreEvent)event);
            }
            catch (MuleException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        });
    }

    private CoreEvent processRequest(CoreEvent event) throws MuleException {
        if (taskTokenInThread.get() != null) {
            this.requestTaskToken = taskTokenInThread.get();
        } else {
            this.requestTaskToken = this.generateTaskToken();
            taskTokenInThread.set(this.requestTaskToken);
        }
        return super.process(event);
    }

    private CoreEvent processResponse(CoreEvent event) throws MuleException {
        if (event == null) {
            return event;
        }
        this.responseTaskToken = taskTokenInThread.get() != null ? taskTokenInThread.get() : this.generateTaskToken();
        this.responseStackTrace = ExceptionUtils.getStackTrace((Throwable)new Exception());
        this.responseResult = this.responseResult && this.expressionManager.evaluateBoolean(this.responseExpression, event, this.getLocation(), false, true);
        this.increaseResponseCount();
        this.responseLatch.countDown();
        return event;
    }

    protected String generateTaskToken() {
        return Thread.currentThread().getName() + " - " + UUID.getUUID();
    }

    private CoreEvent processNext(CoreEvent event) throws MuleException {
        if (event != null) {
            return this.next.process(event);
        }
        return event;
    }

    @Override
    public void verify() throws InterruptedException {
        super.verify();
        if (this.responseCountFailOrNullEvent().booleanValue()) {
            Assert.fail((String)(this.failureMessagePrefix() + "No response message received or if responseCount attribute was set then it was no matched."));
        } else if (this.responseExpressionFailed().booleanValue()) {
            Assert.fail((String)(this.failureMessagePrefix() + "Response expression " + this.expression + " evaluated false."));
        } else if (this.responseCount > 0 && this.responseSameTask) {
            Assert.assertThat((String)(this.failureMessagePrefix() + "Response task was not same as request task"), (Object)this.responseTaskToken, (Matcher)CoreMatchers.is((Object)this.requestTaskToken));
        } else if (this.responseCount > 0) {
            Assert.assertThat((String)(this.failureMessagePrefix() + "Response task was same as request task. Response stack trace is " + System.lineSeparator() + this.responseStackTrace), (Object)this.responseTaskToken, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)this.requestTaskToken)));
        }
    }

    public Boolean responseCountFailOrNullEvent() throws InterruptedException {
        return !this.isResponseProcessesCountCorrect();
    }

    public Boolean responseExpressionFailed() {
        return !this.responseResult;
    }

    public void setListener(Processor listener) {
        this.next = listener;
    }

    private void increaseResponseCount() {
        ++this.responseInvocationCount;
    }

    public void setResponseExpression(String responseExpression) {
        this.responseExpression = responseExpression;
    }

    public void setResponseCount(int responseCount) {
        this.responseCount = responseCount;
    }

    public void setResponseSameTask(boolean responseSameTask) {
        this.responseSameTask = responseSameTask;
    }

    private synchronized boolean isResponseProcessesCountCorrect() throws InterruptedException {
        boolean countReached = this.responseLatch.await(5000L, TimeUnit.MILLISECONDS);
        if (this.needToMatchCount) {
            return this.responseCount == this.responseInvocationCount;
        }
        return countReached;
    }
}

