/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.tck;

import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.functional.api.component.AssertionMessageProcessor;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class AssertionMessageProcessorTestCase
extends AbstractMuleTestCase {
    protected FlowConstruct flowConstruct;
    protected ExtendedExpressionManager expressionManager;
    protected final String TRUE_EXPRESSION = "trueExpression";
    protected final String FALSE_EXPRESSION = "falseExpression";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected MuleContext muleContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected CoreEvent mockEvent;
    @Mock
    protected InternalMessage muleMessage;

    @Before
    public void initialise() {
        Mockito.when((Object)this.mockEvent.getMessage()).thenReturn((Object)this.muleMessage);
        this.expressionManager = (ExtendedExpressionManager)Mockito.mock(ExtendedExpressionManager.class);
        Mockito.when((Object)this.expressionManager.isValid(org.mockito.Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.expressionManager.validate(org.mockito.Matchers.anyString())).thenReturn((Object)ValidationResult.success());
        Mockito.when((Object)this.expressionManager.evaluateBoolean((String)org.mockito.Matchers.eq((Object)"trueExpression"), (CoreEvent)org.mockito.Matchers.any(CoreEvent.class), (ComponentLocation)org.mockito.Matchers.any(ComponentLocation.class), org.mockito.Matchers.anyBoolean(), org.mockito.Matchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.expressionManager.evaluateBoolean((String)org.mockito.Matchers.eq((Object)"falseExpression"), (CoreEvent)org.mockito.Matchers.any(CoreEvent.class), (ComponentLocation)org.mockito.Matchers.any(ComponentLocation.class), org.mockito.Matchers.anyBoolean(), org.mockito.Matchers.anyBoolean())).thenReturn((Object)false);
        Mockito.when((Object)this.muleContext.getExpressionManager()).thenReturn((Object)this.expressionManager);
        this.flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)this.flowConstruct.getMuleContext()).thenReturn((Object)this.muleContext);
        Mockito.when((Object)this.flowConstruct.getName()).thenReturn((Object)"MockedFlowConstruct");
    }

    @Test
    public void startAssertionMessageProcessor() throws Exception {
        AssertionMessageProcessor asp = this.baseAssertionMP();
        asp.start();
    }

    @Test
    public void processDummyEvent() throws Exception {
        AssertionMessageProcessor asp = this.baseAssertionMP();
        asp.start();
        asp.process(this.mockEvent);
    }

    @Test
    public void processValidEvent() throws Exception {
        AssertionMessageProcessor asp = this.baseAssertionMP();
        asp.setExpression("trueExpression");
        asp.start();
        asp.process(this.mockEvent);
        Assert.assertThat((Object)asp.expressionFailed(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)asp.countFailOrNullEvent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void processInvalidEvent() throws Exception {
        AssertionMessageProcessor asp = this.baseAssertionMP();
        asp.setExpression("falseExpression");
        asp.start();
        asp.process(this.mockEvent);
        Assert.assertThat((Object)asp.expressionFailed(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)asp.countFailOrNullEvent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void processZeroEvents() throws Exception {
        AssertionMessageProcessor asp = this.baseAssertionMP();
        asp.setExpression("trueExpression");
        asp.start();
        Assert.assertThat((Object)asp.expressionFailed(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)asp.countFailOrNullEvent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void processSomeValidEvents() throws Exception {
        AssertionMessageProcessor asp = this.baseAssertionMP();
        asp.setExpression("trueExpression");
        asp.start();
        asp.process(this.mockEvent);
        asp.process(this.mockEvent);
        asp.process(this.mockEvent);
        Assert.assertThat((Object)asp.expressionFailed(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)asp.countFailOrNullEvent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void processSomeInvalidEvent() throws Exception {
        AssertionMessageProcessor asp = this.baseAssertionMP();
        asp.setExpression("trueExpression");
        asp.start();
        asp.process(this.mockEvent);
        asp.process(this.mockEvent);
        asp.setExpression("falseExpression");
        asp.process(this.mockEvent);
        asp.setExpression("trueExpression");
        asp.process(this.mockEvent);
        Assert.assertThat((Object)asp.expressionFailed(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)asp.countFailOrNullEvent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void processMoreThanCountEvents() throws Exception {
        AssertionMessageProcessor asp = this.baseAssertionMP();
        asp.setExpression("trueExpression");
        asp.setCount(5);
        asp.start();
        for (int i = 0; i < 6; ++i) {
            asp.process(this.mockEvent);
        }
        Assert.assertThat((Object)asp.expressionFailed(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)asp.countFailOrNullEvent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void processLessThanCountEvents() throws Exception {
        AssertionMessageProcessor asp = this.baseAssertionMP();
        asp.setExpression("trueExpression");
        asp.setCount(5);
        asp.start();
        for (int i = 0; i < 4; ++i) {
            asp.process(this.mockEvent);
        }
        Assert.assertThat((Object)asp.expressionFailed(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)asp.countFailOrNullEvent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void processExactCountEvents() throws Exception {
        AssertionMessageProcessor asp = this.baseAssertionMP();
        asp.setExpression("trueExpression");
        asp.setCount(5);
        asp.start();
        for (int i = 0; i < 5; ++i) {
            asp.process(this.mockEvent);
        }
        Assert.assertThat((Object)asp.expressionFailed(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)asp.countFailOrNullEvent(), (Matcher)Matchers.is((Object)false));
    }

    public AssertionMessageProcessor baseAssertionMP() {
        AssertionMessageProcessor asp = this.createAssertionMessageProcessor();
        asp.setExpressionManager((ExpressionManager)this.expressionManager);
        asp.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, DefaultComponentLocation.fromSingleComponent((String)"flow")));
        return asp;
    }

    protected AssertionMessageProcessor createAssertionMessageProcessor() {
        return new AssertionMessageProcessor();
    }
}

