/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.vegan.extension;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tck.testmodels.fruit.Apple;

public class HarvestAppleKeyResolver
implements TypeKeysResolver,
OutputTypeResolver {
    public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
        InputStream keysOverride = Thread.currentThread().getContextClassLoader().getResourceAsStream("HarvestAppleKeyResolver.keys");
        if (keysOverride != null) {
            try {
                String keysCsv = IOUtils.toString((InputStream)keysOverride);
                if (!keysCsv.isEmpty()) {
                    return Stream.of(keysCsv.split(",")).map(name -> MetadataKeyBuilder.newKey((String)name).build()).collect(Collectors.toSet());
                }
            }
            catch (Exception e) {
                throw new MetadataResolvingException(e.getMessage(), FailureCode.INVALID_METADATA_KEY, (Throwable)e);
            }
        }
        return ImmutableSet.of((Object)MetadataKeyBuilder.newKey((String)"HARVESTED").build());
    }

    public String getResolverName() {
        return "HarvestAppleKeyResolver";
    }

    public String getCategoryName() {
        return "HarvestedKeys";
    }

    public MetadataType getOutputType(MetadataContext context, Object key) throws MetadataResolvingException, ConnectionException {
        return context.getTypeLoader().load(Apple.class);
    }
}

