/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.processor;

import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.util.context.Context;

public class ContextPropagationChecker
implements Processor {
    private static final String CTX_PROPAGATED_KEY = "ctxPropagated";

    public CoreEvent process(CoreEvent event) throws MuleException {
        Assert.fail((String)"Need `apply` to be called instead of `process`.");
        return event;
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.deferContextual(ctx -> Flux.from((Publisher)publisher).doOnNext(e -> Assert.assertThat((Object)ctx.getOrEmpty((Object)CTX_PROPAGATED_KEY).orElse(false), (Matcher)Matchers.is((Object)true))));
    }

    public Function<Context, Context> contextPropagationFlag() {
        return ctx -> ctx.put((Object)CTX_PROPAGATED_KEY, (Object)true);
    }

    public static final void assertContextPropagation(CoreEvent event, Processor routerOrScope, ContextPropagationChecker checker) {
        CoreEvent result = (CoreEvent)Flux.just((Object)event).transform((Function)routerOrScope).subscriberContext(checker.contextPropagationFlag()).blockFirst();
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
    }
}

