/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class CollectableReference<T>
extends PhantomReference<T> {
    private T strongReference;

    public CollectableReference(T referent) {
        super(referent, new ReferenceQueue());
        this.strongReference = referent;
    }

    @Override
    public T get() {
        return this.strongReference;
    }

    private void dereference() {
        this.strongReference = null;
    }

    public static Matcher<CollectableReference> collectedByGc() {
        return new CollectedByGC();
    }

    private static class CollectedByGC
    extends TypeSafeMatcher<CollectableReference> {
        private CollectedByGC() {
        }

        protected boolean matchesSafely(CollectableReference reference) {
            reference.dereference();
            System.gc();
            return reference.isEnqueued();
        }

        public void describeTo(Description description) {
            description.appendText("A strong reference is being maintained");
        }
    }
}

