/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.junit4.matchers;

import java.io.InputStream;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.util.IOUtils;

public class IsMessageWithPayload<T>
extends TypeSafeMatcher<Message> {
    private final Matcher<T> matcher;
    private Object incomingValue;

    public IsMessageWithPayload(Matcher<T> matcher) {
        this.matcher = matcher;
    }

    protected boolean matchesSafely(Message message) {
        Object payload = message.getPayload().getValue();
        this.incomingValue = payload instanceof String || payload instanceof CursorStreamProvider || payload instanceof InputStream ? this.getString(payload) : payload;
        return this.matcher.matches(this.incomingValue);
    }

    public void describeTo(Description description) {
        description.appendText("message with payload ");
        description.appendDescriptionOf(this.matcher);
    }

    protected void describeMismatchSafely(Message message, Description mismatchDescription) {
        mismatchDescription.appendText("got a message with a payload that ");
        this.matcher.describeMismatch(this.incomingValue, mismatchDescription);
    }

    private String getString(Object payload) {
        if (payload instanceof String) {
            return (String)payload;
        }
        if (payload instanceof CursorStreamProvider) {
            return IOUtils.toString((CursorStreamProvider)((CursorStreamProvider)payload));
        }
        if (payload instanceof InputStream) {
            return IOUtils.toString((InputStream)((InputStream)payload));
        }
        Assert.fail((String)String.format("Expected String or InputStream payload but got [%s]", payload != null ? payload.getClass().getName() : "null"));
        return null;
    }
}

