/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.core.util.queue;

import java.io.Serializable;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.util.queue.QueueStore;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.util.MuleContextUtils;

public abstract class QueueStoreTestCase
extends AbstractMuleContextTestCase {
    public static final String VALUE = "value";
    public static final String ANOTHER_VALUE = "value2";
    public static final long OFFER_TIMEOUT = 10L;
    public static final int NUMBER_OF_ITEMS = 10;
    public static final int LONG_POLL_TIMEOUT = 100;
    public static final int SHORT_POLL_TIMEOUT = 100;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void offerAndPollSingleValue() throws InterruptedException, ObjectStoreException {
        QueueStore queue = this.createQueue();
        queue.offer((Serializable)((Object)VALUE), 0, 10L);
        Serializable result = queue.poll(10L);
        Assert.assertThat((Object)((String)((Object)result)), (Matcher)Is.is((Object)VALUE));
    }

    @Test
    public void offerAndPollTwice() throws Exception {
        QueueStore queue = this.createQueue();
        queue.putNow((Serializable)((Object)VALUE));
        Serializable value = queue.poll(100L);
        Assert.assertThat((Object)((String)((Object)value)), (Matcher)Is.is((Object)VALUE));
        Assert.assertThat((Object)queue.poll(100L), (Matcher)IsNull.nullValue());
    }

    @Test
    public void failIfThereIsNoCapacity() throws Exception {
        QueueStore queue = this.createQueueWithCapacity(1);
        Assert.assertThat((Object)queue.offer((Serializable)((Object)VALUE), 0, 10L), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)queue.offer((Serializable)((Object)VALUE), 0, 10L), (Matcher)Is.is((Object)false));
    }

    @Test
    public void allowOfferWhenThereIsCapacity() throws Exception {
        QueueStore queue = this.createQueueWithCapacity(1);
        Assert.assertThat((Object)queue.offer((Serializable)((Object)VALUE), 0, 10L), (Matcher)Is.is((Object)true));
        queue.poll(10L);
        Assert.assertThat((Object)queue.offer((Serializable)((Object)VALUE), 0, 10L), (Matcher)Is.is((Object)true));
    }

    @Test
    public void untakeAddsElementFirst() throws Exception {
        QueueStore queue = this.createQueue();
        queue.offer((Serializable)((Object)VALUE), 0, 10L);
        queue.untake((Serializable)((Object)ANOTHER_VALUE));
        Assert.assertThat((Object)((String)((Object)queue.poll(10L))), (Matcher)Is.is((Object)ANOTHER_VALUE));
    }

    @Test
    public void clearEmptiesTheQueue() throws Exception {
        QueueStore queue = this.createQueue();
        queue.putNow((Serializable)((Object)VALUE));
        queue.putNow((Serializable)((Object)ANOTHER_VALUE));
        queue.clear();
        Assert.assertThat((Object)queue.poll(100L), (Matcher)IsNull.nullValue());
    }

    @Test
    public void pollDoesNotReturnsUntilPollTimeout() throws Exception {
        QueueStore queue = this.createQueue();
        long initialTime = System.currentTimeMillis();
        queue.poll(100L);
        Assert.assertThat((Object)(System.currentTimeMillis() - initialTime >= 100L ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    @Test
    public void peekDoesNotRemoveElement() throws Exception {
        QueueStore queue = this.createQueue();
        queue.putNow((Serializable)((Object)VALUE));
        Assert.assertThat((Object)((String)((Object)queue.peek())), (Matcher)Is.is((Object)VALUE));
        Assert.assertThat((Object)((String)((Object)queue.poll(100L))), (Matcher)Is.is((Object)VALUE));
    }

    @Test
    public void offerSeveralRetrieveAll() throws Exception {
        int i;
        QueueStore queue = this.createQueue();
        for (i = 0; i < 10; ++i) {
            queue.offer((Serializable)((Object)String.valueOf(i)), 0, 10L);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertThat((Object)((String)((Object)queue.poll(10L))), (Matcher)Is.is((Object)String.valueOf(i)));
        }
    }

    @Test
    public void offerSeveralRetrieveAllMuleEvents() throws Exception {
        int i;
        QueueStore queue = this.createQueue();
        ArrayList<CoreEvent> events = new ArrayList<CoreEvent>(10);
        for (i = 0; i < 10; ++i) {
            CoreEvent testEvent = MuleContextUtils.eventBuilder(muleContext).message(Message.of((Object)"some data")).build();
            events.add(testEvent);
            queue.offer((Serializable)testEvent, 0, 10L);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertThat((Object)((CoreEvent)queue.poll(10L)).getContext().getId().equals(((CoreEvent)events.get(i)).getContext().getId()), (Matcher)Is.is((Object)true));
        }
    }

    protected QueueStore createQueue() {
        return this.createQueueWithCapacity(0);
    }

    protected QueueStore createQueueWithCapacity(int capacity) {
        MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockMuleContext.getConfiguration().getWorkingDirectory()).thenReturn((Object)this.temporaryFolder.getRoot().getAbsolutePath());
        Mockito.when((Object)mockMuleContext.getExecutionClassLoader()).thenReturn((Object)muleContext.getExecutionClassLoader());
        Mockito.when((Object)mockMuleContext.getObjectSerializer()).thenReturn((Object)muleContext.getObjectSerializer());
        QueueStore queue = this.createQueueInfoDelegate(capacity, mockMuleContext);
        return queue;
    }

    protected abstract QueueStore createQueueInfoDelegate(int var1, MuleContext var2);
}

