/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.mule.tck.processor.FlowAssertion;

public class FlowAssert {
    private static Map<String, List<FlowAssertion>> assertions = new TreeMap<String, List<FlowAssertion>>();

    public static void verify() throws Exception {
        for (List<FlowAssertion> flowAssertions : assertions.values()) {
            for (FlowAssertion assertion : flowAssertions) {
                assertion.verify();
            }
        }
    }

    public static void verify(String flowName) throws Exception {
        List<FlowAssertion> flowAssertions = assertions.get(flowName);
        if (flowAssertions != null) {
            for (FlowAssertion assertion : flowAssertions) {
                assertion.verify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAssertion(String flowName, FlowAssertion assertion) {
        Map<String, List<FlowAssertion>> map = assertions;
        synchronized (map) {
            if (assertions.get(flowName) == null) {
                assertions.put(flowName, new ArrayList());
            }
            assertions.get(flowName).add(assertion);
        }
    }

    public static void reset() {
        assertions = new TreeMap<String, List<FlowAssertion>>();
    }
}

