/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfigFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.scheduler.SchedulerView;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.concurrent.NamedThreadFactory;
import org.mule.tck.SimpleUnitTestSupportCustomScheduler;
import org.mule.tck.SimpleUnitTestSupportLifecycleSchedulerDecorator;
import org.mule.tck.SimpleUnitTestSupportScheduler;

public class SimpleUnitTestSupportSchedulerService
implements SchedulerService,
Stoppable {
    public static final ThreadGroup UNIT_TEST_THREAD_GROUP = new ThreadGroup(SimpleUnitTestSupportScheduler.class.getSimpleName());
    private final SimpleUnitTestSupportScheduler scheduler = new SimpleUnitTestSupportScheduler(8, (ThreadFactory)new NamedThreadFactory(SimpleUnitTestSupportScheduler.class.getSimpleName(), SimpleUnitTestSupportSchedulerService.class.getClassLoader(), UNIT_TEST_THREAD_GROUP), new ThreadPoolExecutor.AbortPolicy());
    private final List<Scheduler> customSchedulers = Collections.synchronizedList(new ArrayList());
    private final List<Scheduler> decorators = Collections.synchronizedList(new ArrayList());

    public String getName() {
        return SchedulerService.class.getSimpleName();
    }

    public Scheduler cpuLightScheduler() {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler ioScheduler() {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler cpuIntensiveScheduler() {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler cpuLightScheduler(SchedulerConfig config) {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler ioScheduler(SchedulerConfig config) {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler cpuIntensiveScheduler(SchedulerConfig config) {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler cpuLightScheduler(SchedulerConfig config, SchedulerPoolsConfigFactory poolsConfigFactory) {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler ioScheduler(SchedulerConfig config, SchedulerPoolsConfigFactory poolsConfigFactory) {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler cpuIntensiveScheduler(SchedulerConfig config, SchedulerPoolsConfigFactory poolsConfigFactory) {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler customScheduler(SchedulerConfig config) {
        SimpleUnitTestSupportCustomScheduler customScheduler = new SimpleUnitTestSupportCustomScheduler(config.getMaxConcurrentTasks(), (ThreadFactory)this.buildThreadFactory(config), new ThreadPoolExecutor.AbortPolicy());
        this.customSchedulers.add(customScheduler);
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(customScheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler customScheduler(SchedulerConfig config, int queueSize) {
        SimpleUnitTestSupportCustomScheduler customScheduler = new SimpleUnitTestSupportCustomScheduler(config.getMaxConcurrentTasks(), (ThreadFactory)this.buildThreadFactory(config), new ThreadPoolExecutor.AbortPolicy());
        this.customSchedulers.add(customScheduler);
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(customScheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    private NamedThreadFactory buildThreadFactory(SchedulerConfig config) {
        return new NamedThreadFactory(config.getSchedulerName() != null ? config.getSchedulerName() : "SimpleUnitTestSupportSchedulerService_custom"){

            public Thread newThread(Runnable runnable) {
                Thread t = new Thread(new ThreadGroup(this.getName()), runnable);
                this.configureThread(t);
                return t;
            }
        };
    }

    private SimpleUnitTestSupportLifecycleSchedulerDecorator decorateScheduler(SimpleUnitTestSupportScheduler scheduler) {
        return (SimpleUnitTestSupportLifecycleSchedulerDecorator)ClassUtils.withContextClassLoader((ClassLoader)SimpleUnitTestSupportSchedulerService.class.getClassLoader(), () -> new SimpleUnitTestSupportLifecycleSchedulerDecorator(this.resolveSchedulerCreationLocation(), scheduler, this));
    }

    private String resolveSchedulerCreationLocation() {
        int i = 0;
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StackTraceElement ste = stackTrace[i++];
        while (this.skip(ste) && i < stackTrace.length) {
            ste = stackTrace[i++];
        }
        ste = this.skip(ste) ? stackTrace[3] : stackTrace[i - 1];
        return ste.getClassName() + "." + ste.getMethodName() + ":" + ste.getLineNumber();
    }

    private boolean skip(StackTraceElement ste) {
        return ste.getClassName().startsWith(SimpleUnitTestSupportSchedulerService.class.getName()) || ste.getClassName().startsWith("org.mule.runtime.core.api.util.ClassUtils") || ste.getClassName().startsWith("org.mule.runtime.core.api.util.ExceptionUtils") || ste.getClassName().startsWith("org.mule.runtime.container.internal.MetadataInvocationHandler") || ste.getClassName().startsWith("org.mule.runtime.config.internal.InjectParamsFromContextServiceProxy") || ste.getClassName().startsWith("org.mockito") || ste.getClassName().startsWith("java.lang.reflect.") || ste.getClassName().startsWith("sun.reflect.") || ste.getClassName().startsWith("jdk.internal.reflect.") || ste.getClassName().contains("$Proxy") || ste.getClassName().contains("$$Enhancer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws MuleException {
        if (!this.scheduler.isShutdown()) {
            this.scheduler.shutdownNow();
        }
        List<Scheduler> list = this.customSchedulers;
        synchronized (list) {
            for (Scheduler customScheduler : this.customSchedulers) {
                customScheduler.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SchedulerView> getSchedulers() {
        ArrayList<TestSchedulerView> schedulers = new ArrayList<TestSchedulerView>();
        List<Scheduler> list = this.decorators;
        synchronized (list) {
            for (Scheduler scheduler : this.decorators) {
                schedulers.add(new TestSchedulerView(scheduler));
            }
        }
        return Collections.unmodifiableList(schedulers);
    }

    public void clearCreatedSchedulers() {
        this.decorators.clear();
    }

    void stoppedScheduler(Scheduler scheduler) {
        this.decorators.remove(scheduler);
        if (scheduler instanceof SimpleUnitTestSupportLifecycleSchedulerDecorator && ((SimpleUnitTestSupportLifecycleSchedulerDecorator)scheduler).getDecorated() instanceof SimpleUnitTestSupportCustomScheduler) {
            this.customSchedulers.remove(((SimpleUnitTestSupportLifecycleSchedulerDecorator)scheduler).getDecorated());
        }
    }

    public int getScheduledTasks() {
        return this.scheduler.getScheduledTasks();
    }

    public boolean isCurrentThreadInWaitGroup() {
        return Thread.currentThread().getThreadGroup() == UNIT_TEST_THREAD_GROUP;
    }

    private class TestSchedulerView
    implements SchedulerView {
        private final Scheduler scheduler;

        public TestSchedulerView(Scheduler scheduler) {
            this.scheduler = scheduler;
        }

        public String getName() {
            return this.scheduler.getName();
        }

        public boolean isShutdown() {
            return this.scheduler.isShutdown();
        }

        public boolean isTerminated() {
            return this.scheduler.isTerminated();
        }

        public String toString() {
            return this.scheduler.toString();
        }
    }
}

