/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.el.DefaultValidationResult;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.ExpressionLanguageConfiguration;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerView;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.weave.v2.el.WeaveDefaultExpressionLanguageFactoryService;

public class TestServicesConfigurationBuilder
extends AbstractConfigurationBuilder
implements ServiceConfigurator,
TestRule {
    private static final DefaultValidationResult SUCCESS_VALIDATION_RESULT = new DefaultValidationResult(true, null);
    private static final String MOCK_HTTP_SERVICE = "mockHttpService";
    private static final String MOCK_EXPR_EXECUTOR = "mockExpressionExecutor";
    private static final String MOCK_EXPRESSION_LANGUAGE_METADATA_SERVICE = "mockExpressionLanguageMetadataService";
    private static final ExpressionLanguageMetadataService expressionLanguageMetadataService = (ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class);
    private static DefaultExpressionLanguageFactoryService cachedExprLanguageFactory;
    private static int cachedExprLanguageFactoryCounter;
    private final SimpleUnitTestSupportSchedulerService schedulerService = new SimpleUnitTestSupportSchedulerService();
    private final boolean mockHttpService;
    private final boolean mockExpressionExecutor;
    private final boolean mockExpressionLanguageMetadataService;
    private final Map<String, Object> additionalMockedServices = new HashMap<String, Object>();
    private final Map<String, Object> overriddenDefaultServices = new HashMap<String, Object>();

    public TestServicesConfigurationBuilder() {
        this(true, true, true);
    }

    public TestServicesConfigurationBuilder(boolean mockHttpService, boolean mockExpressionExecutor, boolean mockExpressionLanguageMetadataService) {
        this.mockHttpService = mockHttpService;
        this.mockExpressionExecutor = mockExpressionExecutor;
        this.mockExpressionLanguageMetadataService = mockExpressionLanguageMetadataService;
    }

    public void doConfigure(MuleContext muleContext) throws Exception {
        ClassUtils.withContextClassLoader((ClassLoader)TestServicesConfigurationBuilder.class.getClassLoader(), () -> {
            try {
                MuleRegistry registry = ((MuleContextWithRegistry)muleContext).getRegistry();
                this.registerServices(muleContext, registry);
                registry.registerObjects(this.additionalMockedServices);
            }
            catch (RegistrationException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
    }

    public void configure(CustomizationService customizationService) {
        customizationService.registerCustomServiceImpl(this.schedulerService.getName(), Mockito.spy((Object)this.schedulerService));
        if (this.mockExpressionExecutor) {
            customizationService.registerCustomServiceImpl(MOCK_EXPR_EXECUTOR, (Object)this.createMockExpressionExecutor());
        } else {
            this.initCachedExprLanguageFactory();
            customizationService.registerCustomServiceImpl(MOCK_EXPR_EXECUTOR, (Object)cachedExprLanguageFactory);
        }
        if (this.mockHttpService) {
            customizationService.registerCustomServiceImpl(MOCK_HTTP_SERVICE, (Object)this.mockHttpService());
        }
        if (this.mockExpressionLanguageMetadataService) {
            customizationService.registerCustomServiceImpl(MOCK_EXPRESSION_LANGUAGE_METADATA_SERVICE, (Object)expressionLanguageMetadataService);
        }
    }

    protected void registerServices(MuleContext muleContext, MuleRegistry registry) throws RegistrationException {
        registry.registerObject(this.schedulerService.getName(), Mockito.spy((Object)this.schedulerService));
        registry.registerObject("_muleSchedulerBaseConfig", (Object)SchedulerConfig.config());
        if (this.mockExpressionExecutor) {
            registry.registerObject(MOCK_EXPR_EXECUTOR, (Object)this.createMockExpressionExecutor());
        } else {
            this.initCachedExprLanguageFactory();
            registry.registerObject(cachedExprLanguageFactory.getName(), (Object)cachedExprLanguageFactory);
        }
        if (this.mockHttpService) {
            registry.registerObject(MOCK_HTTP_SERVICE, (Object)this.mockHttpService());
        }
        if (this.mockExpressionLanguageMetadataService) {
            registry.registerObject(MOCK_EXPRESSION_LANGUAGE_METADATA_SERVICE, Mockito.mock(ExpressionLanguageMetadataService.class));
        }
        this.overriddenDefaultServices.forEach((serviceId, serviceImpl) -> ((MuleContextWithRegistry)muleContext).getCustomizationService().overrideDefaultServiceImpl(serviceId, serviceImpl));
    }

    protected void initCachedExprLanguageFactory() {
        if (cachedExprLanguageFactory == null || cachedExprLanguageFactoryCounter > 20) {
            cachedExprLanguageFactoryCounter = 0;
            WeaveDefaultExpressionLanguageFactoryService exprExecutor = new WeaveDefaultExpressionLanguageFactoryService(null);
            final ExpressionLanguage exprLanguage = exprExecutor.create();
            exprLanguage.evaluate("{dataWeave: 'is'} ++ {mule: 'default EL'}", BindingContextUtils.NULL_BINDING_CONTEXT);
            cachedExprLanguageFactory = new DefaultExpressionLanguageFactoryService((DefaultExpressionLanguageFactoryService)exprExecutor){
                final /* synthetic */ DefaultExpressionLanguageFactoryService val$exprExecutor;
                {
                    this.val$exprExecutor = defaultExpressionLanguageFactoryService;
                }

                public ExpressionLanguage create() {
                    return exprLanguage;
                }

                public ExpressionLanguage create(ExpressionLanguageConfiguration configuration) {
                    return exprLanguage;
                }

                public String getName() {
                    return this.val$exprExecutor.getName();
                }
            };
        } else {
            ++cachedExprLanguageFactoryCounter;
        }
    }

    protected DefaultExpressionLanguageFactoryService createMockExpressionExecutor() {
        ExpressionLanguage lang = (ExpressionLanguage)Mockito.mock(ExpressionLanguage.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)lang.validate(ArgumentMatchers.anyString())).thenReturn((Object)SUCCESS_VALIDATION_RESULT);
        DefaultExpressionLanguageFactoryService languageFactoryService = (DefaultExpressionLanguageFactoryService)Mockito.mock(DefaultExpressionLanguageFactoryService.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)languageFactoryService.create()).thenReturn((Object)lang);
        Mockito.when((Object)languageFactoryService.create((ExpressionLanguageConfiguration)ArgumentMatchers.any())).thenReturn((Object)lang);
        return languageFactoryService;
    }

    protected HttpService mockHttpService() {
        try {
            HttpServerFactory httpServerFactory = (HttpServerFactory)Mockito.mock(HttpServerFactory.class);
            HttpServer httpServer = (HttpServer)Mockito.mock(HttpServer.class);
            Mockito.when((Object)httpServerFactory.create((HttpServerConfiguration)ArgumentMatchers.any())).thenReturn((Object)httpServer);
            HttpService service = (HttpService)Mockito.mock(HttpService.class);
            Mockito.when((Object)service.getServerFactory()).thenReturn((Object)httpServerFactory);
            return service;
        }
        catch (ServerCreationException e) {
            return null;
        }
    }

    public void stopServices() throws MuleException {
        List<SchedulerView> schedulers = this.schedulerService.getSchedulers();
        try {
            Assert.assertThat(schedulers, (Matcher)IsEmptyCollection.empty());
        }
        finally {
            this.schedulerService.stop();
        }
    }

    public void registerAdditionalService(String name, Object service) {
        this.additionalMockedServices.put(name, service);
    }

    public void registerOverriddenService(String name, Object service) {
        this.overriddenDefaultServices.put(name, service);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                finally {
                    TestServicesConfigurationBuilder.this.stopServices();
                }
            }
        };
    }

    static {
        cachedExprLanguageFactoryCounter = 0;
    }
}

