/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.message.ErrorType;
import org.mule.tck.junit4.rule.SystemProperty;

public class TestConnectivityUtils {
    private static final Matcher NULL_VALUE = CoreMatchers.nullValue();
    private final Registry registry;

    public TestConnectivityUtils(Registry registry) {
        this.registry = registry;
    }

    public void assertSuccessConnection(String configName) {
        this.assertConnection(configName, true, (Matcher<Exception>)NULL_VALUE, (Matcher<ErrorType>)NULL_VALUE);
    }

    public void assertFailedConnection(String configName, Matcher<Exception> exceptionMatcher, Matcher<ErrorType> errorTypeMatcher) {
        this.assertConnection(configName, false, exceptionMatcher, errorTypeMatcher);
    }

    public static SystemProperty disableAutomaticTestConnectivity() {
        return new SystemProperty("doTestConnectivity", "false");
    }

    private void assertConnection(String configName, boolean isSuccess, Matcher<Exception> exceptionMatcher, Matcher<ErrorType> codeMatcher) {
        ConnectivityTestingService testingService = (ConnectivityTestingService)this.registry.lookupByName("_muleConnectivityTestingService").get();
        ConnectionValidationResult validationResult = testingService.testConnection(Location.builder().globalName(configName).build());
        MatcherAssert.assertThat((Object)validationResult.isValid(), (Matcher)CoreMatchers.is((Object)isSuccess));
        if (!isSuccess) {
            MatcherAssert.assertThat((Object)validationResult.getException(), exceptionMatcher);
            MatcherAssert.assertThat(validationResult.getErrorType().orElse(null), codeMatcher);
        }
    }
}

