/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.rule;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Function;
import org.junit.rules.ExternalResource;

public class EnvironmentVariable
extends ExternalResource {
    protected boolean initialized;
    protected String value;
    private final String name;
    private String oldValue;

    public EnvironmentVariable(String name) {
        this(name, null);
    }

    public EnvironmentVariable(String name, String value) {
        this.name = name;
        this.value = value;
    }

    protected void before() throws Throwable {
        if (this.initialized) {
            throw new IllegalArgumentException("Environment variable was already initialized");
        }
        this.oldValue = this.getValue() == null ? this.clearEnvironmentVariable(this.name) : this.updateEnvironmentVariable(this.name, this.getValue());
        this.initialized = true;
    }

    protected void after() {
        if (!this.initialized) {
            throw new IllegalArgumentException("Environment variable was not initialized");
        }
        this.doCleanUp();
        this.restoreOldValue();
        this.initialized = false;
    }

    protected void restoreOldValue() {
        if (this.oldValue == null) {
            this.clearEnvironmentVariable(this.name);
        } else {
            this.updateEnvironmentVariable(this.name, this.oldValue);
        }
    }

    public String getName() {
        return this.name;
    }

    protected void doCleanUp() {
    }

    public String getValue() {
        return this.value;
    }

    public String clearEnvironmentVariable(String name) {
        return this.updateEnvironmentVariablesMap(m -> (String)m.remove(name));
    }

    public String updateEnvironmentVariable(String name, String val) {
        return this.updateEnvironmentVariablesMap(m -> m.put(name, val));
    }

    private String updateEnvironmentVariablesMap(Function<Map<String, String>, String> f) {
        Map<String, String> env = System.getenv();
        Field field = null;
        try {
            field = env.getClass().getDeclaredField("m");
            field.setAccessible(true);
            String string = f.apply((Map)field.get(env));
            return string;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Unable to add environment variable", e);
        }
        finally {
            if (field != null) {
                field.setAccessible(true);
            }
        }
    }
}

