/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.junit4.matchers;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ThrowableRootCauseMatcher<T extends Throwable>
extends TypeSafeMatcher<T> {
    private final Matcher<T> matcher;

    public ThrowableRootCauseMatcher(Matcher<T> matcher) {
        this.matcher = matcher;
    }

    public void describeTo(Description description) {
        description.appendText("exception with root cause ");
        description.appendDescriptionOf(this.matcher);
    }

    protected boolean matchesSafely(T item) {
        return this.matcher.matches((Object)ThrowableRootCauseMatcher.getRootCause(item));
    }

    protected void describeMismatchSafely(T item, Description description) {
        description.appendText("root cause ");
        this.matcher.describeMismatch((Object)ThrowableRootCauseMatcher.getRootCause(item), description);
    }

    private static Throwable getRootCause(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    @Factory
    public static <T extends Throwable> Matcher<T> hasRootCause(Matcher<T> matcher) {
        return new ThrowableRootCauseMatcher<T>(matcher);
    }
}

