/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.rule;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.rules.ExternalResource;

public class JvmVersion
extends ExternalResource {
    private final Matcher<Integer> versionMatcher;
    private final String description;

    public JvmVersion(Matcher<Integer> versionMatcher) {
        this(versionMatcher, null);
    }

    public JvmVersion(Matcher<Integer> versionMatcher, String description) {
        this.versionMatcher = versionMatcher;
        this.description = description;
    }

    protected void before() throws Throwable {
        super.before();
        int currentVersion = JvmVersion.getCurrentJvmVersion();
        Object message = this.description != null ? this.description : "JVM version " + currentVersion + " does not meet the required criteria. Ignoring test.";
        Assume.assumeThat((String)message, (Object)currentVersion, this.versionMatcher);
    }

    public static JvmVersion atLeast(int minVersion) {
        return new JvmVersion((Matcher<Integer>)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(minVersion)), "JVM version must be at least " + minVersion + ". Ignoring test.");
    }

    public static JvmVersion is(int version) {
        return new JvmVersion((Matcher<Integer>)Matchers.equalTo((Object)version), "JVM version must be " + version + ". Ignoring test.");
    }

    public static JvmVersion lessThan(int maxVersion) {
        return new JvmVersion((Matcher<Integer>)Matchers.lessThan((Comparable)Integer.valueOf(maxVersion)), "JVM version must be less than " + maxVersion + ". Ignoring test.");
    }

    public static JvmVersion atMost(int maxVersion) {
        return new JvmVersion((Matcher<Integer>)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(maxVersion)), "JVM version must be at most " + maxVersion + ". Ignoring test.");
    }

    public static JvmVersion between(int minVersion, int maxVersion) {
        return new JvmVersion((Matcher<Integer>)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(minVersion)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(maxVersion))), "JVM version must be between " + minVersion + " and " + maxVersion + ". Ignoring test.");
    }

    public static int getCurrentJvmVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dotIndex = version.indexOf(46);
            if (dotIndex != -1) {
                version = version.substring(0, dotIndex);
            }
        }
        return Integer.parseInt(version);
    }
}

