/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.core.streaming;

import java.io.IOException;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.tck.core.streaming.AbstractCursorStream;

public class ByteArrayCursorStream
extends AbstractCursorStream {
    private byte[] content;

    public ByteArrayCursorStream(CursorStreamProvider provider, byte[] content) {
        super(provider);
        this.content = content;
    }

    @Override
    protected int doRead() throws IOException {
        int position = Math.toIntExact(this.getPosition());
        if (position >= this.content.length) {
            return -1;
        }
        int value = this.unsigned(this.content[position]);
        ++this.position;
        return value;
    }

    @Override
    protected int doRead(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int position = Math.toIntExact(this.getPosition());
        if ((len = Math.min(len, this.content.length - position)) <= 0) {
            return -1;
        }
        System.arraycopy(this.content, position, b, off, len);
        this.position += (long)len;
        return len;
    }
}

