/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.maven.pom.parser.api.MavenPomParserProvider;
import org.mule.maven.pom.parser.api.model.MavenPomModel;
import org.mule.tck.ZipUtils;

public class MavenTestUtils {
    private static final String POM = "pom";

    public static Collection<Path> installArtifact(Path artifactFile, Path repositoryLocation) throws IOException {
        String artifactExtension = FilenameUtils.getExtension((String)artifactFile.getFileName().toString());
        MavenPomParser parser = MavenPomParserProvider.discoverProvider().createMavenPomParserClient(artifactFile);
        if (POM.equals(artifactExtension)) {
            return MavenTestUtils.installArtifact(artifactFile, repositoryLocation, parser);
        }
        Path packagedArtifact = MavenTestUtils.packageArtifact(artifactFile, parser.getModel());
        return MavenTestUtils.installArtifact(packagedArtifact, repositoryLocation, parser);
    }

    private static Path packageArtifact(Path explodedArtifactFile, MavenPomModel pomModel) throws IOException {
        String fileNameInRepo = pomModel.getArtifactId() + "-" + pomModel.getVersion() + (String)(pomModel.getPackaging() != null && !pomModel.getPackaging().equalsIgnoreCase("jar") ? "-" + pomModel.getPackaging() : "") + ".jar";
        Path compressedFile = explodedArtifactFile.resolve(fileNameInRepo);
        try (Stream<Path> recursiveResources = Files.walk(explodedArtifactFile, new FileVisitOption[0]);){
            ZipUtils.compress(compressedFile, (ZipUtils.ZipResource[])recursiveResources.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(f -> new ZipUtils.ZipResource(f.toAbsolutePath().toString(), MavenTestUtils.getZipEntryName(explodedArtifactFile, f))).toArray(ZipUtils.ZipResource[]::new));
        }
        return compressedFile;
    }

    private static String getZipEntryName(Path baseDir, Path entryFile) {
        return baseDir.toUri().relativize(entryFile.toUri()).getPath();
    }

    private static Collection<Path> installArtifact(Path artifactFile, Path repositoryLocation, MavenPomParser parser) throws IOException {
        MavenPomModel pomModel = parser.getModel();
        ArrayList<String> artifactLocationInRepo = new ArrayList<String>(Arrays.asList(pomModel.getGroupId().split("\\.")));
        artifactLocationInRepo.add(pomModel.getArtifactId());
        artifactLocationInRepo.add(pomModel.getVersion());
        Path pathToArtifactLocationInRepo = repositoryLocation;
        for (String artifactLocationInRepoPart : artifactLocationInRepo) {
            pathToArtifactLocationInRepo = pathToArtifactLocationInRepo.resolve(artifactLocationInRepoPart);
        }
        Files.createDirectories(pathToArtifactLocationInRepo, new FileAttribute[0]);
        Path repoArtifactFile = pathToArtifactLocationInRepo.resolve(artifactFile.getFileName());
        Files.copy(artifactFile, repoArtifactFile, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        String pomFileName = artifactFile.getFileName().toString().replaceFirst("(.*\\.[0-9]*\\.[0-9]*\\.?[0-9]?).*", "$1") + ".pom";
        Path repoPomFile = pathToArtifactLocationInRepo.resolve(pomFileName);
        Files.copy(((File)parser.getModel().getPomFile().get()).toPath(), repoPomFile, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        return Arrays.asList(repoArtifactFile, repoPomFile);
    }
}

