/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.testmodels.fruit;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleEventContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.Callable;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitCleaner;
import org.mule.tck.testmodels.fruit.Seed;
import org.mule.tck.testmodels.fruit.peel.ApplePeel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Apple
implements Fruit,
Callable,
MuleContextAware {
    private static final long serialVersionUID = -7631993371500076921L;
    private static final Logger logger = LoggerFactory.getLogger(Apple.class);
    private boolean bitten = false;
    private boolean washed = false;
    private FruitCleaner appleCleaner;
    private Seed seed;
    private MuleContext muleContext;
    private ApplePeel peel;

    public Apple() {
    }

    public Apple(boolean bitten) {
        this.bitten = bitten;
    }

    public void wash() {
        if (this.appleCleaner != null) {
            this.appleCleaner.wash(this);
        }
        this.washed = true;
    }

    public void polish() {
        this.appleCleaner.polish(this);
    }

    public boolean isWashed() {
        return this.washed;
    }

    @Override
    public void bite() {
        this.bitten = true;
    }

    @Override
    public boolean isBitten() {
        return this.bitten;
    }

    public Seed getSeed() {
        return this.seed;
    }

    public void setSeed(Seed seed) {
        this.seed = seed;
    }

    public Object onCall(MuleEventContext context) throws MuleException {
        logger.debug("Apple received an event in Callable.onEvent! MuleEvent says: " + context.getMessageAsString(this.muleContext));
        this.wash();
        return null;
    }

    public FruitCleaner getAppleCleaner() {
        return this.appleCleaner;
    }

    public void setAppleCleaner(FruitCleaner cleaner) {
        this.appleCleaner = cleaner;
    }

    public Object methodReturningNull() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Apple apple = (Apple)o;
        if (this.bitten != apple.bitten) {
            return false;
        }
        return this.washed == apple.washed;
    }

    public int hashCode() {
        int result = this.bitten ? 1 : 0;
        result = 29 * result + (this.washed ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Just an apple.";
    }

    public void setBitten(boolean bitten) {
        this.bitten = bitten;
    }

    public void setWashed(boolean washed) {
        this.washed = washed;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public ApplePeel getPeel() {
        return this.peel;
    }
}

