/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.matcher;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsCollectionContaining;
import org.mule.runtime.api.values.Value;

public final class ValueMatcher
extends TypeSafeMatcher<Value> {
    private final String id;
    private String displayName;
    private String partName;
    private StringBuilder descriptionBuilder = new StringBuilder();
    private ValueMatcher[] valueMatchers;

    private ValueMatcher(String id) {
        this.id = id;
        this.descriptionBuilder.append(String.format("a Value with id: '%s'", id));
    }

    public static ValueMatcher valueWithId(String id) {
        return new ValueMatcher(id);
    }

    protected boolean matchesSafely(Value value) {
        try {
            this.validateEquals(this.id, value.getId());
            this.validateEquals(this.displayName, value.getDisplayName());
            this.validateEquals(this.partName, value.getPartName());
            if (this.valueMatchers != null) {
                return IsCollectionContaining.hasItems((Matcher[])this.valueMatchers).matches((Object)value.getChilds());
            }
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText(this.descriptionBuilder.toString());
    }

    public ValueMatcher withDisplayName(String displayName) {
        this.displayName = displayName;
        this.descriptionBuilder.append(String.format(", displayName: '%s'", displayName));
        return this;
    }

    public ValueMatcher withPartName(String partName) {
        this.partName = partName;
        this.descriptionBuilder.append(String.format(", partName: '%s'", partName));
        return this;
    }

    public ValueMatcher withChilds(ValueMatcher ... valueMatcher) {
        this.valueMatchers = valueMatcher;
        this.descriptionBuilder.append(String.format(", with child values: [%s]", Arrays.stream(this.valueMatchers).map(Object::toString).collect(Collectors.joining(", "))));
        return this;
    }

    private void validateEquals(String actual, String expected) {
        if (actual != null && !expected.equals(actual)) {
            throw new RuntimeException(String.format("Assertion Error - Actual: '%s' Expected: '%s'", actual, expected));
        }
    }
}

