/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4;

import java.util.Arrays;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

@RunWith(value=Parameterized.class)
public abstract class AbstractReactiveProcessorTestCase
extends AbstractMuleContextTestCase {
    protected Scheduler scheduler;
    protected Mode mode;

    public AbstractReactiveProcessorTestCase(Mode mode) {
        this.mode = mode;
    }

    @Parameterized.Parameters
    public static Collection<Mode> modeParameters() {
        return Arrays.asList(Mode.BLOCKING, Mode.NON_BLOCKING);
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.scheduler = muleContext.getSchedulerService().cpuIntensiveScheduler();
    }

    @Override
    protected void doTearDown() throws Exception {
        this.scheduler.stop();
        super.doTearDown();
    }

    @Override
    protected Event process(Processor processor, Event event) throws Exception {
        return this.process(processor, event, true);
    }

    protected Event process(Processor processor, Event event, boolean unwrapMessagingException) throws Exception {
        LifecycleUtils.setMuleContextIfNeeded((Object)processor, (MuleContext)muleContext);
        try {
            switch (this.mode) {
                case BLOCKING: {
                    return processor.process(event);
                }
                case NON_BLOCKING: {
                    return MessageProcessors.processToApply((Event)event, (ReactiveProcessor)processor);
                }
            }
            return null;
        }
        catch (Exception exception) {
            if (unwrapMessagingException && !(processor instanceof Flow) && exception instanceof MessagingException) {
                throw this.messagingExceptionToException((MessagingException)exception);
            }
            throw exception;
        }
    }

    private Exception messagingExceptionToException(MessagingException msgException) {
        return msgException.getCause() instanceof Exception ? (Exception)msgException.getCause() : new RuntimeException(msgException.getCause());
    }

    public static enum Mode {
        BLOCKING,
        NON_BLOCKING;

    }
}

