/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.scheduler.SchedulerView;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.InternalEventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.builders.DefaultsConfigurationBuilder;
import org.mule.runtime.core.api.config.builders.SimpleConfigurationBuilder;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.DefaultMuleContextBuilder;
import org.mule.runtime.core.api.context.DefaultMuleContextFactory;
import org.mule.runtime.core.api.context.MuleContextBuilder;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.context.notification.NotificationListener;
import org.mule.runtime.core.api.context.notification.NotificationListenerRegistry;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.concurrent.Latch;
import org.mule.runtime.core.internal.serialization.JavaObjectSerializer;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.tck.TriggerableMessageSource;
import org.mule.tck.config.TestServicesConfigurationBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.TestsLogConfigurationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMuleContextTestCase
extends AbstractMuleTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMuleContextTestCase.class);
    public static final String WORKING_DIRECTORY_SYSTEM_PROPERTY_KEY = "workingDirectory";
    public TestServicesConfigurationBuilder testServicesConfigurationBuilder;
    public Supplier<TestServicesConfigurationBuilder> testServicesConfigurationBuilderSupplier = () -> new TestServicesConfigurationBuilder(this.mockHttpService(), this.mockExprExecutorService());
    public TemporaryFolder workingDirectory = new TemporaryFolder();
    public static final String[] IGNORED_DOT_MULE_DIRS = new String[]{"transaction-log"};
    protected static MuleContext muleContext;
    private boolean startContext = false;
    public static final String TEST_MESSAGE = "Test Message";
    public static final long LOCK_TIMEOUT = 30000L;
    public static final int RECEIVE_TIMEOUT = 5000;
    public static final int BLOCK_TIMEOUT = 500;
    private boolean disposeContextPerClass;
    private static boolean logConfigured;
    private ConfigurationComponentLocator componentLocator = (ConfigurationComponentLocator)Mockito.mock(ConfigurationComponentLocator.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private static List<SchedulerView> schedulersOnInit;

    protected boolean isDisposeContextPerClass() {
        return this.disposeContextPerClass;
    }

    protected void setDisposeContextPerClass(boolean val) {
        this.disposeContextPerClass = val;
    }

    @Before
    public final void setUpMuleContext() throws Exception {
        if (!logConfigured) {
            TestsLogConfigurationHelper.configureLoggingForTest(this.getClass());
            logConfigured = true;
        }
        this.workingDirectory.create();
        String workingDirectoryOldValue = System.setProperty(WORKING_DIRECTORY_SYSTEM_PROPERTY_KEY, this.workingDirectory.getRoot().getAbsolutePath());
        try {
            this.doSetUpBeforeMuleContextCreation();
            muleContext = this.createMuleContext();
            if (this.isStartContext() && muleContext != null && !muleContext.isStarted()) {
                this.startMuleContext();
            }
            this.doSetUp();
        }
        finally {
            if (workingDirectoryOldValue != null) {
                System.setProperty(WORKING_DIRECTORY_SYSTEM_PROPERTY_KEY, workingDirectoryOldValue);
            } else {
                System.clearProperty(WORKING_DIRECTORY_SYSTEM_PROPERTY_KEY);
            }
        }
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
    }

    private void startMuleContext() throws MuleException, InterruptedException {
        final AtomicReference<Latch> contextStartedLatch = new AtomicReference<Latch>();
        contextStartedLatch.set(new Latch());
        MuleContextNotificationListener<MuleContextNotification> listener = new MuleContextNotificationListener<MuleContextNotification>(){

            public boolean isBlocking() {
                return false;
            }

            public void onNotification(MuleContextNotification notification) {
                ((Latch)contextStartedLatch.get()).countDown();
            }
        };
        ((NotificationListenerRegistry)muleContext.getRegistry().lookupObject(NotificationListenerRegistry.class)).registerListener((NotificationListener)listener);
        muleContext.start();
        if (this.doTestClassInjection()) {
            muleContext.getInjector().inject((Object)this);
        }
        ((Latch)contextStartedLatch.get()).await(20L, TimeUnit.SECONDS);
    }

    protected boolean doTestClassInjection() {
        return false;
    }

    protected void doSetUp() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MuleContext createMuleContext() throws Exception {
        MuleContext context;
        if (this.isDisposeContextPerClass() && muleContext != null) {
            context = muleContext;
        } else {
            ClassLoader executionClassLoader = this.getExecutionClassLoader();
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(executionClassLoader);
                DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
                ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>();
                builders.add((ConfigurationBuilder)new SimpleConfigurationBuilder((Map)this.getStartUpProperties()));
                this.addBuilders(builders);
                builders.add(this.getBuilder());
                DefaultMuleContextBuilder contextBuilder = new DefaultMuleContextBuilder();
                DefaultMuleConfiguration muleConfiguration = new DefaultMuleConfiguration();
                String workingDirectory = this.workingDirectory.getRoot().getAbsolutePath();
                LOGGER.info("Using working directory for test: " + workingDirectory);
                muleConfiguration.setWorkingDirectory(workingDirectory);
                muleConfiguration.setId(this.getClass().getSimpleName() + "#" + this.name.getMethodName());
                contextBuilder.setMuleConfiguration((MuleConfiguration)muleConfiguration);
                contextBuilder.setExecutionClassLoader(executionClassLoader);
                contextBuilder.setObjectSerializer(this.getObjectSerializer());
                this.configureMuleContext((MuleContextBuilder)contextBuilder);
                context = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)contextBuilder);
                this.createTestFlow(context);
                AbstractMuleContextTestCase.recordSchedulersOnInit(context);
                if (!this.isGracefulShutdown()) {
                    ((DefaultMuleConfiguration)context.getConfiguration()).setShutdownTimeout(0L);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
        return context;
    }

    protected void createTestFlow(MuleContext context) {
        Mockito.when((Object)this.componentLocator.find(Location.builder().globalName("appleFlow").build())).thenReturn(Optional.of(this.getFakeFlowConstruct(context)));
    }

    protected ObjectSerializer getObjectSerializer() {
        return new JavaObjectSerializer();
    }

    protected ClassLoader getExecutionClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        this.testServicesConfigurationBuilder = this.testServicesConfigurationBuilderSupplier.get();
        builders.add((ConfigurationBuilder)this.testServicesConfigurationBuilder);
    }

    protected boolean mockHttpService() {
        return true;
    }

    protected boolean mockExprExecutorService() {
        return false;
    }

    protected void configureMuleContext(MuleContextBuilder contextBuilder) {
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new DefaultsConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) throws Exception {
                super.doConfigure(muleContext);
                muleContext.getRegistry().registerObject("_muleConfigurationComponentLocator", (Object)AbstractMuleContextTestCase.this.componentLocator);
            }
        };
    }

    protected FlowConstruct getFakeFlowConstruct(MuleContext context) {
        try {
            return MuleTestUtils.getTestFlow(context);
        }
        catch (MuleException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getConfigurationResources() {
        return "";
    }

    protected Properties getStartUpProperties() {
        return null;
    }

    @After
    public final void disposeContextPerTest() throws Exception {
        this.doTearDown();
        if (!this.isDisposeContextPerClass()) {
            if (this.isStartContext() && muleContext != null && muleContext.isStarted()) {
                muleContext.stop();
            }
            AbstractMuleContextTestCase.disposeContext();
            if (this.testServicesConfigurationBuilder != null) {
                this.testServicesConfigurationBuilder.stopServices();
            }
            this.doTearDownAfterMuleContextDispose();
        }
        this.workingDirectory.delete();
    }

    protected void doTearDownAfterMuleContextDispose() throws Exception {
    }

    @AfterClass
    public static void disposeContext() throws RegistrationException, MuleException {
        try {
            if (muleContext != null && !muleContext.isDisposed() && !muleContext.isDisposing()) {
                try {
                    muleContext.dispose();
                }
                catch (IllegalStateException e) {
                    LOGGER.warn(e + " : " + e.getMessage());
                }
                AbstractMuleContextTestCase.verifyAndStopSchedulers();
                MuleConfiguration configuration = muleContext.getConfiguration();
                if (configuration != null) {
                    String workingDir = configuration.getWorkingDirectory();
                    FileUtils.deleteTree((File)FileUtils.newFile((String)workingDir), (String[])IGNORED_DOT_MULE_DIRS);
                }
            }
            FileUtils.deleteTree((File)FileUtils.newFile((String)"./ActiveMQ"));
        }
        finally {
            muleContext = null;
            TestsLogConfigurationHelper.clearLoggingConfig();
        }
    }

    protected static void recordSchedulersOnInit(MuleContext context) {
        if (context != null) {
            SchedulerService serviceImpl = context.getSchedulerService();
            schedulersOnInit = serviceImpl.getSchedulers();
        } else {
            schedulersOnInit = Collections.emptyList();
        }
    }

    protected static void verifyAndStopSchedulers() throws MuleException {
        SchedulerService serviceImpl = muleContext.getSchedulerService();
        Set schedulersOnInitNames = schedulersOnInit.stream().map(s -> s.getName()).collect(Collectors.toSet());
        try {
            Assert.assertThat(muleContext.getSchedulerService().getSchedulers().stream().filter(s -> !schedulersOnInitNames.contains(s.getName())).collect(Collectors.toList()), (Matcher)IsEmptyCollection.empty());
        }
        finally {
            if (serviceImpl instanceof SimpleUnitTestSupportSchedulerService) {
                LifecycleUtils.stopIfNeeded((Object)serviceImpl);
            }
        }
    }

    protected void doTearDown() throws Exception {
    }

    public static Flow getNamedTestFlow(String name) throws MuleException {
        Flow flow = Flow.builder((String)name, (MuleContext)muleContext).build();
        flow.setAnnotations(Collections.singletonMap(AbstractAnnotatedObject.LOCATION_KEY, DefaultComponentLocation.fromSingleComponent((String)name)));
        muleContext.getRegistry().registerFlowConstruct((FlowConstruct)flow);
        return flow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static InternalEvent.Builder eventBuilder() throws MuleException {
        FlowConstruct flowConstruct = muleContext.getRegistry().lookupFlowConstruct("appleFlow");
        if (flowConstruct == null) {
            MuleContext muleContext = AbstractMuleContextTestCase.muleContext;
            synchronized (muleContext) {
                flowConstruct = AbstractMuleContextTestCase.muleContext.getRegistry().lookupFlowConstruct("appleFlow");
                if (flowConstruct == null) {
                    flowConstruct = MuleTestUtils.getTestFlow(AbstractMuleContextTestCase.muleContext);
                }
            }
        }
        return InternalEvent.builder((InternalEventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION)).flow(flowConstruct);
    }

    @Override
    protected InternalEvent.Builder getEventBuilder() throws MuleException {
        return AbstractMuleContextTestCase.eventBuilder();
    }

    protected boolean isStartContext() {
        return this.startContext;
    }

    protected void setStartContext(boolean startContext) {
        this.startContext = startContext;
    }

    protected boolean isGracefulShutdown() {
        return false;
    }

    protected <T> T createObject(Class<T> clazz) throws Exception {
        return this.createObject(clazz, ClassUtils.NO_ARGS);
    }

    protected <T> T createObject(Class<T> clazz, Object ... args) throws Exception {
        if (args == null) {
            args = ClassUtils.NO_ARGS;
        }
        Object o = ClassUtils.instantiateClass(clazz, (Object[])args);
        muleContext.getRegistry().registerObject(String.valueOf(o.hashCode()), o);
        return (T)o;
    }

    protected void initialiseObject(Object o) throws RegistrationException {
        muleContext.getRegistry().registerObject(String.valueOf(o.hashCode()), o);
    }

    public SensingNullMessageProcessor getSensingNullMessageProcessor() {
        return new SensingNullMessageProcessor();
    }

    public TriggerableMessageSource getTriggerableMessageSource() {
        return new TriggerableMessageSource();
    }

    protected File getWorkingDirectory() {
        return this.workingDirectory.getRoot();
    }

    protected File getFileInsideWorkingDirectory(String fileName) {
        return new File(this.getWorkingDirectory(), fileName);
    }

    protected String getPayloadAsString(Message message) throws Exception {
        return (String)this.getPayload(message, DataType.STRING);
    }

    protected byte[] getPayloadAsBytes(Message message) throws Exception {
        return (byte[])this.getPayload(message, DataType.BYTE_ARRAY);
    }

    protected Object getPayload(Message message, DataType dataType) throws Exception {
        return muleContext.getTransformationService().internalTransform(message, dataType).getPayload().getValue();
    }

    protected <T> T getPayload(Message message, Class<T> clazz) throws Exception {
        return (T)this.getPayload(message, DataType.fromType(clazz));
    }

    protected InternalEvent process(Processor processor, InternalEvent event) throws Exception {
        LifecycleUtils.setMuleContextIfNeeded((Object)processor, (MuleContext)muleContext);
        return processor.process(event);
    }

    public static Map<QName, Object> getAppleFlowComponentLocationAnnotations() {
        return AbstractMuleContextTestCase.getFlowComponentLocationAnnotations("appleFlow");
    }

    protected static Map<QName, Object> getFlowComponentLocationAnnotations(String rootComponentName) {
        return ImmutableMap.builder().put((Object)AbstractAnnotatedObject.LOCATION_KEY, (Object)DefaultComponentLocation.fromSingleComponent((String)rootComponentName)).build();
    }
}

