/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.processor;

import java.util.concurrent.ExecutorService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.scheduler.SchedulerConfig;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class TestNonBlockingProcessor
implements Processor,
Initialisable,
Disposable,
MuleContextAware {
    private static int MAX_THREADS = 8;
    private MuleContext muleContext;
    private Scheduler customScheduler;

    public ReactiveProcessor.ProcessingType getProcessingType() {
        return ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC;
    }

    public Event process(Event event) throws MuleException {
        return event;
    }

    public Publisher<Event> apply(Publisher<Event> publisher) {
        return Flux.from(publisher).publishOn(Schedulers.fromExecutorService((ExecutorService)this.customScheduler));
    }

    public void initialise() throws InitialisationException {
        this.customScheduler = this.muleContext.getSchedulerService().customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(MAX_THREADS));
    }

    public void dispose() {
        this.customScheduler.stop();
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

