/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classloader.container;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.discoverer.ContainerDiscovererHelper;
import org.mule.runtime.container.api.discoverer.ModuleDiscoverer;
import org.mule.runtime.container.internal.ClasspathModuleDiscoverer;
import org.mule.runtime.container.internal.ContainerClassLoaderCreatorUtils;
import org.mule.runtime.container.internal.ContainerModuleDiscoverer;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.container.internal.PreFilteredContainerClassLoaderCreator;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.jpms.api.MuleContainerModule;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.test.runner.classloader.container.TestModuleDiscoverer;

public class TestPreFilteredContainerClassLoaderCreator
implements PreFilteredContainerClassLoaderCreator {
    private static final String TEST_MODULE_PROPERTIES = "META-INF/mule-test-module.properties";
    private final Set<String> bootPackages;
    private final ClassLoader containerSystemClassloader;
    private final DefaultModuleRepository testContainerModuleRepository;

    public TestPreFilteredContainerClassLoaderCreator(ClassLoader containerSystemClassloader, Set<String> bootPackages, Set<String> extraPrivilegedArtifacts) {
        this.containerSystemClassloader = containerSystemClassloader;
        this.bootPackages = bootPackages;
        ReflectionAdapterModuleDiscoverer moduleDiscoverer = TestPreFilteredContainerClassLoaderCreator.createContainerModuleDiscoverer(containerSystemClassloader);
        this.testContainerModuleRepository = new DefaultModuleRepository((ModuleDiscoverer)new TestModuleDiscoverer(extraPrivilegedArtifacts, moduleDiscoverer));
    }

    public List<MuleContainerModule> getMuleModules() {
        return (List)ClassUtils.withContextClassLoader((ClassLoader)this.containerSystemClassloader, () -> ((DefaultModuleRepository)this.testContainerModuleRepository).getModules());
    }

    public ModuleRepository getModuleRepository() {
        return this.testContainerModuleRepository;
    }

    public Set<String> getBootPackages() {
        if (this.bootPackages.isEmpty()) {
            return BOOT_PACKAGES;
        }
        HashSet<String> finalBootPackages = new HashSet<String>();
        finalBootPackages.addAll(BOOT_PACKAGES);
        finalBootPackages.addAll(this.bootPackages);
        return finalBootPackages;
    }

    public ArtifactClassLoader getPreFilteredContainerClassLoader(ArtifactDescriptor artifactDescriptor, ClassLoader parentClassLoader) {
        return new MuleArtifactClassLoader("container", artifactDescriptor, new URL[0], parentClassLoader, ContainerClassLoaderCreatorUtils.getLookupPolicy((ClassLoader)parentClassLoader, this.getMuleModules(), this.getBootPackages()));
    }

    private static ReflectionAdapterModuleDiscoverer createContainerModuleDiscoverer(ClassLoader containerSystemClassloader) {
        try {
            if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11)) {
                Class<?> clsContainerDiscovererHelper = containerSystemClassloader.loadClass(ContainerDiscovererHelper.class.getName());
                clsContainerDiscovererHelper.getDeclaredMethod("exportInternalsToTestRunner", new Class[0]).invoke(null, new Object[0]);
            }
            Class<?> clsContainerModuleDiscoverer = containerSystemClassloader.loadClass(ContainerModuleDiscoverer.class.getName());
            Object moduleDiscoverer = clsContainerModuleDiscoverer.getConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> clsClasspathModuleDiscoverer = containerSystemClassloader.loadClass(ClasspathModuleDiscoverer.class.getName());
            Object classpathModuleDiscoverer = clsClasspathModuleDiscoverer.getConstructor(String.class).newInstance(TEST_MODULE_PROPERTIES);
            Class<?> clsModuleDiscoverer = containerSystemClassloader.loadClass(ModuleDiscoverer.class.getName());
            clsContainerModuleDiscoverer.getDeclaredMethod("addModuleDiscoverer", clsModuleDiscoverer).invoke(moduleDiscoverer, classpathModuleDiscoverer);
            return new ReflectionAdapterModuleDiscoverer(containerSystemClassloader, moduleDiscoverer);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public static final class ReflectionAdapterMuleContainerModule
    implements MuleContainerModule {
        private final Object adaptedModule;
        private final Method getName;
        private final Method getExportedPackages;
        private final Method getExportedPaths;
        private final Method getPrivilegedExportedPackages;
        private final Method getPrivilegedArtifacts;

        public ReflectionAdapterMuleContainerModule(ClassLoader containerSystemClassloader, Object adaptedModule) {
            this.adaptedModule = adaptedModule;
            try {
                Class<?> clsMuleContainerModule = containerSystemClassloader.loadClass(MuleContainerModule.class.getName());
                this.getName = clsMuleContainerModule.getMethod("getName", new Class[0]);
                this.getExportedPackages = clsMuleContainerModule.getMethod("getExportedPackages", new Class[0]);
                this.getExportedPaths = clsMuleContainerModule.getMethod("getExportedPaths", new Class[0]);
                this.getPrivilegedExportedPackages = clsMuleContainerModule.getMethod("getPrivilegedExportedPackages", new Class[0]);
                this.getPrivilegedArtifacts = clsMuleContainerModule.getMethod("getPrivilegedArtifacts", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }

        public String getName() {
            try {
                return (String)this.getName.invoke(this.adaptedModule, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }

        public Set<String> getExportedPackages() {
            try {
                return (Set)this.getExportedPackages.invoke(this.adaptedModule, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }

        public Set<String> getExportedPaths() {
            try {
                return (Set)this.getExportedPaths.invoke(this.adaptedModule, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }

        public Set<String> getPrivilegedExportedPackages() {
            try {
                return (Set)this.getPrivilegedExportedPackages.invoke(this.adaptedModule, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }

        public Set<String> getPrivilegedArtifacts() {
            try {
                return (Set)this.getPrivilegedArtifacts.invoke(this.adaptedModule, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }

        public String toString() {
            return "ReflectionAdapterMuleContainerModule_" + this.adaptedModule.toString();
        }
    }

    private static final class ReflectionAdapterModuleDiscoverer
    implements ModuleDiscoverer {
        private final ClassLoader containerSystemClassloader;
        private final Object moduleDiscoverer;
        private final Method methodDiscover;

        public ReflectionAdapterModuleDiscoverer(ClassLoader containerSystemClassloader, Object moduleDiscoverer) {
            this.containerSystemClassloader = containerSystemClassloader;
            this.moduleDiscoverer = moduleDiscoverer;
            try {
                this.methodDiscover = containerSystemClassloader.loadClass(ModuleDiscoverer.class.getName()).getDeclaredMethod("discover", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }

        public List<MuleContainerModule> discover() {
            try {
                return ((List)this.methodDiscover.invoke(this.moduleDiscoverer, new Object[0])).stream().map(module -> new ReflectionAdapterMuleContainerModule(this.containerSystemClassloader, module)).collect(Collectors.toList());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }
}

