/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.mule.test.runner.ArtifactClassLoaderRunnerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationUtils.class);

    private AnnotationUtils() {
    }

    public static <T> T getAnnotationAttributeFrom(Class<?> klass, Class<? extends Annotation> annotationClass, String methodName) {
        Object extensions;
        Annotation annotation = klass.getAnnotation(annotationClass);
        try {
            Method method = annotationClass.getMethod(methodName, new Class[0]);
            extensions = annotation != null ? method.invoke((Object)annotation, new Object[0]) : method.getDefaultValue();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot read default " + methodName + " from " + annotationClass);
        }
        return (T)extensions;
    }

    public static <T> List<T> getAnnotationAttributeFromHierarchy(Class<?> klass, Class<? extends Annotation> annotationClass, String methodName) {
        ArrayList list = new ArrayList();
        for (Class<?> currentClass = klass; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            T attributeFrom = AnnotationUtils.getAnnotationAttributeFrom(currentClass, annotationClass, methodName);
            if (attributeFrom == null) continue;
            list.add(attributeFrom);
        }
        ClassUtils.getAllInterfaces(klass).forEach(currentInterfaceClass -> {
            Object attributeFrom = AnnotationUtils.getAnnotationAttributeFrom(currentInterfaceClass, annotationClass, methodName);
            if (attributeFrom != null) {
                list.add(attributeFrom);
            }
        });
        return list;
    }

    public static Class findConfiguredClass(Class<?> testClass) {
        LinkedList classesToReview = new LinkedList();
        classesToReview.push(testClass);
        while (!classesToReview.isEmpty()) {
            Class currentClass = (Class)classesToReview.pop();
            if (currentClass.getDeclaredAnnotation(ArtifactClassLoaderRunnerConfig.class) != null) {
                LOGGER.info("Reading test runner configuration for test '{}' from '{}'", (Object)testClass.getName(), (Object)currentClass.getName());
                return currentClass;
            }
            Collections.addAll(classesToReview, currentClass.getInterfaces());
            if (currentClass.getSuperclass() == null || currentClass.getSuperclass() == Object.class) continue;
            classesToReview.add(currentClass.getSuperclass());
        }
        return null;
    }
}

