/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.maven;

import java.io.File;
import java.util.function.Function;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.maven.pom.parser.api.MavenPomParserProvider;
import org.mule.maven.pom.parser.api.model.MavenPomModel;
import org.mule.maven.pom.parser.api.model.PomParentCoordinates;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArtifactFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactFactory.class);

    private ArtifactFactory() {
    }

    public static Artifact createFromPomFile(File pomFile) {
        LOGGER.debug("Reading rootArtifact from pom file: {}", (Object)pomFile);
        MavenPomParserProvider provider = MavenPomParserProvider.discoverProvider();
        MavenPomParser pomParser = provider.createMavenPomParserClient(pomFile.toPath());
        MavenPomModel model = pomParser.getModel();
        return new DefaultArtifact(model.getGroupId() != null ? ArtifactFactory.searchingProperties(pomParser, MavenPomModel::getGroupId) : ArtifactFactory.searchingProperties(pomParser, m -> m.getParent().map(PomParentCoordinates::getGroupId).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"GroupId not present in the pom or in the parent pom")))), ArtifactFactory.searchingProperties(pomParser, MavenPomModel::getArtifactId), ArtifactFactory.searchingProperties(pomParser, MavenPomModel::getPackaging), model.getVersion() != null ? ArtifactFactory.searchingProperties(pomParser, MavenPomModel::getVersion) : ArtifactFactory.searchingProperties(pomParser, m -> m.getParent().map(PomParentCoordinates::getVersion).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Version not present in the pom or in the parent pom")))));
    }

    private static String searchingProperties(MavenPomParser parser, Function<MavenPomModel, String> extractor) {
        String value = extractor.apply(parser.getModel());
        if (value.startsWith("${")) {
            String propertyKey = value.substring(value.indexOf("{") + 1, value.indexOf("}"));
            return parser.getProperties().getProperty(propertyKey, value);
        }
        return value;
    }
}

