/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.mule.runtime.api.util.Preconditions;

public class PluginUrlClassification {
    private static final String INVALID_PRIVILEGED_API_DEFINITION_ERROR = "Invalid privileged API: both privileged packages and artifacts must be defined";
    private final List<URL> urls;
    private final String name;
    private final List<Class> exportClasses;
    private final List<String> pluginDependencies;
    private final Set<String> exportedPackages;
    private final Set<String> exportedResources;
    private final Set<String> privilegedExportedPackages;
    private final Set<String> privilegedArtifacts;

    public PluginUrlClassification(String name, List<URL> urls, List<Class> exportClasses, List<String> pluginDependencies, Set<String> exportedPackages, Set<String> exportedResources, Set<String> privilegedExportedPackages, Set<String> privilegedArtifacts) {
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(urls, "urls cannot be null");
        Objects.requireNonNull(pluginDependencies, "pluginDependencies cannot be null");
        Objects.requireNonNull(exportedPackages, "exportedPackages cannot be null");
        Objects.requireNonNull(exportedResources, "exportedResources cannot be null");
        Preconditions.checkArgument((privilegedExportedPackages != null ? 1 : 0) != 0, (String)"privilegedExportedPackages cannot be null");
        Preconditions.checkArgument((privilegedArtifacts != null ? 1 : 0) != 0, (String)"privilegedArtifacts cannot be null");
        Preconditions.checkArgument((privilegedArtifacts.isEmpty() && privilegedExportedPackages.isEmpty() || !privilegedArtifacts.isEmpty() && !privilegedExportedPackages.isEmpty() ? 1 : 0) != 0, (String)INVALID_PRIVILEGED_API_DEFINITION_ERROR);
        this.name = name;
        this.urls = urls;
        this.exportClasses = exportClasses;
        this.pluginDependencies = pluginDependencies;
        this.exportedPackages = exportedPackages;
        this.exportedResources = exportedResources;
        this.privilegedExportedPackages = privilegedExportedPackages;
        this.privilegedArtifacts = privilegedArtifacts;
    }

    public PluginUrlClassification(String name, List<URL> urls, List<Class> exportClasses, List<String> pluginDependencies) {
        this(name, urls, exportClasses, pluginDependencies, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    public List<URL> getUrls() {
        return this.urls;
    }

    public String getName() {
        return this.name;
    }

    public List<Class> getExportClasses() {
        return this.exportClasses;
    }

    public List<String> getPluginDependencies() {
        return this.pluginDependencies;
    }

    public Set<String> getExportedPackages() {
        return this.exportedPackages;
    }

    public Set<String> getExportedResources() {
        return this.exportedResources;
    }

    public String getArtifactId() {
        return this.getName();
    }

    public Set<String> getPrivilegedExportedPackages() {
        return this.privilegedExportedPackages;
    }

    public Set<String> getPrivilegedArtifacts() {
        return this.privilegedArtifacts;
    }
}

