/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.VersionScheme;
import org.mule.runtime.api.util.MuleSystemProperties;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.test.runner.api.ArtifactClassificationNode;
import org.mule.test.runner.api.ArtifactClassificationType;
import org.mule.test.runner.api.ArtifactClassificationTypeResolver;
import org.mule.test.runner.api.ArtifactUrlClassification;
import org.mule.test.runner.api.ArtifactsUrlClassification;
import org.mule.test.runner.api.ClassPathClassifier;
import org.mule.test.runner.api.ClassPathClassifierContext;
import org.mule.test.runner.api.DependencyResolver;
import org.mule.test.runner.api.ExtensionPluginMetadataGenerator;
import org.mule.test.runner.api.PluginResourcesResolver;
import org.mule.test.runner.api.PluginUrlClassification;
import org.mule.test.runner.api.ServiceResourcesResolver;
import org.mule.test.runner.api.ServiceUrlClassification;
import org.mule.test.runner.classification.PatternExclusionsDependencyFilter;
import org.mule.test.runner.classification.PatternInclusionsDependencyFilter;
import org.mule.test.runner.utils.RunnerModuleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherClassPathClassifier
implements ClassPathClassifier,
AutoCloseable {
    private static final String POM = "pom";
    private static final String POM_XML = "pom.xml";
    private static final String POM_EXTENSION = ".pom";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String MAVEN_COORDINATES_SEPARATOR = ":";
    private static final String SNAPSHOT_WILCARD_FILE_FILTER = "*-SNAPSHOT*.*";
    private static final String TESTS_CLASSIFIER = "tests";
    private static final String TESTS_JAR = "-tests.jar";
    private static final String MULE_SERVICE_CLASSIFIER = "mule-service";
    private static final String RUNTIME_GROUP_ID = "org.mule.runtime";
    private static final String LOGGING_ARTIFACT_ID = "mule-module-logging";
    private static final String MULE_ARTIFACT_JSON_PATH = "META-INF/mule-artifact/mule-artifact.json";
    private static final Set<String> JPMS_CONTAINER_ARTIFACT_COORDINATES_DENYLIST = new HashSet<String>(Arrays.asList("xml-apis:xml-apis"));
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final VersionScheme versionScheme = new GenericVersionScheme();
    private final String muleVersion;
    private final DependencyResolver dependencyResolver;
    private final ArtifactClassificationTypeResolver artifactClassificationTypeResolver;
    private final PluginResourcesResolver pluginResourcesResolver = new PluginResourcesResolver();

    public AetherClassPathClassifier(DependencyResolver dependencyResolver, ArtifactClassificationTypeResolver artifactClassificationTypeResolver) {
        Objects.requireNonNull(dependencyResolver, "dependencyResolver cannot be null");
        Objects.requireNonNull(artifactClassificationTypeResolver, "artifactClassificationTypeResolver cannot be null");
        this.dependencyResolver = dependencyResolver;
        this.artifactClassificationTypeResolver = artifactClassificationTypeResolver;
        this.muleVersion = RunnerModuleUtils.RUNNER_PROPERTIES_MULE_VERSION;
    }

    @Override
    public ArtifactsUrlClassification classify(ClassPathClassifierContext context) {
        List remoteRepositories;
        List<Dependency> directDependencies;
        Objects.requireNonNull(context, "context cannot be null");
        this.logger.info("Running dependencies classification on: '{}' in order to build Mule class loaders", (Object)context.getRootArtifact());
        try {
            directDependencies = this.dependencyResolver.getDirectDependencies(context.getRootArtifact());
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't get direct dependencies for rootArtifact: '" + context.getRootArtifact() + "'", e);
        }
        ArtifactClassificationType rootArtifactType = this.artifactClassificationTypeResolver.resolveArtifactClassificationType(context.getRootArtifact());
        if (rootArtifactType == null) {
            throw new IllegalStateException("Couldn't be identified type for rootArtifact: " + context.getRootArtifact());
        }
        this.logger.debug("rootArtifact {} identified as {} type", (Object)context.getRootArtifact(), (Object)rootArtifactType);
        try {
            remoteRepositories = this.dependencyResolver.readArtifactDescriptor(context.getRootArtifact()).getRepositories();
        }
        catch (ArtifactDescriptorException e) {
            throw new IllegalStateException("Couldn't read rootArtifact descriptor", e);
        }
        List<ArtifactUrlClassification> applicationSharedLibArtifactUrlClassifications = this.buildApplicationSharedLibUrlClassification(context, directDependencies, remoteRepositories);
        List<URL> applicationSharedLibUrls = applicationSharedLibArtifactUrlClassifications.stream().flatMap(a -> a.getUrls().stream()).collect(Collectors.toList());
        List<URL> applicationLibUrls = this.buildApplicationUrlClassification(context, directDependencies, remoteRepositories);
        applicationLibUrls.removeAll(applicationSharedLibUrls);
        List<PluginUrlClassification> pluginUrlClassifications = this.buildPluginUrlClassifications(context, directDependencies, rootArtifactType, remoteRepositories);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolved plugins: {}", pluginUrlClassifications.stream().map(pluginUrlClassification -> pluginUrlClassification.getArtifactId()).collect(Collectors.toList()));
        }
        List<ServiceUrlClassification> serviceUrlClassifications = this.buildServicesUrlClassification(context, directDependencies, rootArtifactType, remoteRepositories);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolved services: {}", serviceUrlClassifications.stream().map(serviceUrlClassification -> serviceUrlClassification.getName()).collect(Collectors.toList()));
        }
        Pair<List<URL>, List<URL>> containerUrls = this.buildContainerUrlClassification(context, directDependencies, applicationSharedLibArtifactUrlClassifications, serviceUrlClassifications, pluginUrlClassifications, rootArtifactType, remoteRepositories);
        List<URL> testRunnerLibUrls = this.buildTestRunnerUrlClassification(context, directDependencies, rootArtifactType, remoteRepositories);
        List<URL> testRunnerExportedLibUrls = this.buildTestRunnerExportedLibUrlClassification(context, directDependencies, remoteRepositories);
        this.resolveSnapshotVersionsToTimestampedFromClassPath(applicationSharedLibUrls, context.getClassPathURLs());
        return new ArtifactsUrlClassification((List)containerUrls.getFirst(), (List)containerUrls.getSecond(), serviceUrlClassifications, testRunnerLibUrls, applicationLibUrls, applicationSharedLibUrls, pluginUrlClassifications, testRunnerExportedLibUrls);
    }

    private List<ServiceUrlClassification> buildServicesUrlClassification(ClassPathClassifierContext context, List<Dependency> directDependencies, ArtifactClassificationType rootArtifactType, List<RemoteRepository> rootArtifactRemoteRepositories) {
        ArrayList servicesClassified = Lists.newArrayList();
        Predicate<Dependency> muleServiceClassifiedDependencyFilter = dependency -> dependency.getArtifact().getClassifier().equals(MULE_SERVICE_CLASSIFIER);
        List<Artifact> serviceArtifactsDeclared = this.filterArtifacts(directDependencies, muleServiceClassifiedDependencyFilter);
        this.logger.debug("{} services defined to be classified", (Object)serviceArtifactsDeclared.size());
        Predicate<Dependency> nestedServicesClassifier = dependency -> muleServiceClassifiedDependencyFilter.test((Dependency)dependency) && dependency.getScope().equals("compile");
        if (ArtifactClassificationType.SERVICE.equals((Object)rootArtifactType)) {
            this.logger.debug("rootArtifact '{}' identified as Mule service", (Object)rootArtifactType);
            this.buildPluginUrlClassification(context.getRootArtifact(), context, nestedServicesClassifier, servicesClassified, rootArtifactRemoteRepositories);
        }
        serviceArtifactsDeclared.stream().forEach(serviceArtifact -> this.buildServiceUrlClassification((Artifact)serviceArtifact, context, nestedServicesClassifier, servicesClassified, rootArtifactRemoteRepositories));
        return this.toServiceUrlClassification(this.resolveArtifactsUsingSemanticVersioning(servicesClassified));
    }

    private List<ArtifactUrlClassification> buildApplicationSharedLibUrlClassification(ClassPathClassifierContext context, List<Dependency> directDependencies, List<RemoteRepository> rootArtifactRemoteRepositories) {
        ArrayList pluginSharedLibUrls = Lists.newArrayList();
        List pluginSharedLibDependencies = context.getApplicationSharedLibCoordinates().stream().map(sharedPluginLibCoords -> this.findApplicationSharedLibArtifact((String)sharedPluginLibCoords, context.getRootArtifact(), directDependencies)).collect(Collectors.toList());
        this.logger.debug("Plugin application shared lib artifacts matched with versions from direct dependencies declared: {}", pluginSharedLibDependencies);
        pluginSharedLibDependencies.stream().map(pluginSharedLibDependency -> {
            try {
                return new ArtifactUrlClassification(ArtifactIdUtils.toId((Artifact)pluginSharedLibDependency.getArtifact()), pluginSharedLibDependency.getArtifact(), Lists.newArrayList((Object[])new URL[]{this.dependencyResolver.resolveArtifact(pluginSharedLibDependency.getArtifact(), rootArtifactRemoteRepositories).getArtifact().getFile().toURI().toURL()}));
            }
            catch (Exception e) {
                throw new IllegalStateException("Error while resolving dependency '" + pluginSharedLibDependency + "' as application shared lib", e);
            }
        }).forEach(pluginSharedLibUrls::add);
        this.logger.debug("Classified URLs as application shared libraries: '{}", (Object)pluginSharedLibUrls);
        return pluginSharedLibUrls;
    }

    private List<URL> buildTestRunnerExportedLibUrlClassification(ClassPathClassifierContext context, List<Dependency> directDependencies, List<RemoteRepository> rootArtifactRemoteRepositories) {
        ArrayList pluginSharedLibUrls = Lists.newArrayList();
        List testRunnerExportedLibDependencies = context.getTestRunnerExportedLibCoordinates().stream().map(sharedPluginLibCoords -> this.findTestRunnerExportedLibArtifact((String)sharedPluginLibCoords, context.getRootArtifact(), directDependencies)).collect(Collectors.toList());
        this.logger.debug("Test runner exported lib artifacts matched with versions from direct dependencies declared: {}", testRunnerExportedLibDependencies);
        testRunnerExportedLibDependencies.stream().map(testRunnerExportedLibDependency -> {
            try {
                return this.dependencyResolver.resolveArtifact(testRunnerExportedLibDependency.getArtifact(), rootArtifactRemoteRepositories).getArtifact().getFile().toURI().toURL();
            }
            catch (Exception e) {
                throw new IllegalStateException("Error while resolving dependency '" + testRunnerExportedLibDependency + "' as test runner exported lib", e);
            }
        }).forEach(pluginSharedLibUrls::add);
        this.resolveSnapshotVersionsToTimestampedFromClassPath(pluginSharedLibUrls, context.getClassPathURLs());
        this.logger.debug("Classified URLs as test runner exported libraries: '{}", (Object)pluginSharedLibUrls);
        return pluginSharedLibUrls;
    }

    private List<URL> buildApplicationUrlClassification(ClassPathClassifierContext context, List<Dependency> directDependencies, List<RemoteRepository> rootArtifactRemoteRepositories) {
        ArrayList applicationLibUrls = Lists.newArrayList();
        List applicationLibDependencies = context.getApplicationLibCoordinates().stream().map(applicationLibCoords -> this.findApplicationLibArtifact((String)applicationLibCoords, context.getRootArtifact(), directDependencies)).collect(Collectors.toList());
        this.logger.debug("Application lib artifacts matched with versions from direct dependencies declared: {}", applicationLibDependencies);
        applicationLibDependencies.stream().map(pluginSharedLibDependency -> {
            try {
                return this.dependencyResolver.resolveArtifact(pluginSharedLibDependency.getArtifact(), rootArtifactRemoteRepositories).getArtifact().getFile().toURI().toURL();
            }
            catch (Exception e) {
                throw new IllegalStateException("Error while resolving dependency '" + pluginSharedLibDependency + "' as application lib", e);
            }
        }).forEach(applicationLibUrls::add);
        this.resolveSnapshotVersionsToTimestampedFromClassPath(applicationLibUrls, context.getClassPathURLs());
        this.logger.debug("Classified URLs as application runtime libraries: '{}", (Object)applicationLibUrls);
        return applicationLibUrls;
    }

    private Pair<List<URL>, List<URL>> buildContainerUrlClassification(ClassPathClassifierContext context, List<Dependency> directDependencies, List<ArtifactUrlClassification> applicationSharedLibUrls, List<ServiceUrlClassification> serviceUrlClassifications, List<PluginUrlClassification> pluginUrlClassifications, ArtifactClassificationType rootArtifactType, List<RemoteRepository> rootArtifactRemoteRepositories) {
        List<URL> containerOptUrls;
        List<URL> containerMuleUrls;
        directDependencies = directDependencies.stream().filter(this.getContainerDirectDependenciesFilter(rootArtifactType)).filter(dependency -> {
            Artifact artifact = dependency.getArtifact();
            String artifactId = ArtifactIdUtils.toId((Artifact)artifact);
            return !serviceUrlClassifications.stream().anyMatch(artifactUrlClassification -> artifactUrlClassification.getArtifactId().equals(ArtifactIdUtils.toVersionlessId((Artifact)artifact))) && !pluginUrlClassifications.stream().anyMatch(artifactUrlClassification -> artifactUrlClassification.getArtifactId().equals(ArtifactIdUtils.toVersionlessId((Artifact)artifact)));
        }).map(depToTransform -> depToTransform.setScope("compile")).collect(Collectors.toList());
        directDependencies.add(new Dependency((Artifact)new DefaultArtifact(RUNTIME_GROUP_ID, LOGGING_ARTIFACT_ID, "jar", this.muleVersion), "compile"));
        this.logger.debug("Selected direct dependencies to be used for resolving container dependency graph (changed to compile in order to resolve the graph): {}", directDependencies);
        List<Dependency> managedDependencies = this.selectContainerManagedDependencies(context, directDependencies, rootArtifactType, rootArtifactRemoteRepositories);
        this.logger.debug("Collected managed dependencies from direct provided dependencies to be used for resolving container dependency graph: {}", managedDependencies);
        directDependencies.add(new Dependency(RunnerModuleUtils.getDefaultSdkApiArtifact(), "compile"));
        directDependencies.add(new Dependency(RunnerModuleUtils.getDefaultSdkCompatibilityApiArtifact(), "compile"));
        ArrayList excludedFilterPattern = Lists.newArrayList(context.getProvidedExclusions());
        excludedFilterPattern.addAll(context.getExcludedArtifacts());
        if (!pluginUrlClassifications.isEmpty()) {
            excludedFilterPattern.addAll(pluginUrlClassifications.stream().map(pluginUrlClassification -> pluginUrlClassification.getArtifactId()).collect(Collectors.toList()));
        }
        if (!serviceUrlClassifications.isEmpty()) {
            excludedFilterPattern.addAll(serviceUrlClassifications.stream().map(serviceUrlClassification -> serviceUrlClassification.getArtifactId()).collect(Collectors.toList()));
        }
        this.logger.debug("Resolving dependencies for container using exclusion filter patterns: {}", (Object)excludedFilterPattern);
        PatternExclusionsDependencyFilter dependencyFilter = new PatternExclusionsDependencyFilter(excludedFilterPattern);
        try {
            Pair<List<File>, List<File>> resolvedDependencies = this.dependencyResolver.resolveContainerDependencies(null, directDependencies, managedDependencies, dependencyFilter, rootArtifactRemoteRepositories);
            containerMuleUrls = this.toUrl((Collection)resolvedDependencies.getFirst());
            containerOptUrls = this.toUrl((Collection)resolvedDependencies.getSecond());
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't resolve dependencies for Container", e);
        }
        containerMuleUrls = containerMuleUrls.stream().filter(url -> {
            String file = org.apache.commons.io.FileUtils.toFile((URL)url).getAbsolutePath();
            return !StringUtils.endsWithIgnoreCase((CharSequence)file, (CharSequence)POM_XML) && !StringUtils.endsWithIgnoreCase((CharSequence)file, (CharSequence)POM_EXTENSION) && !StringUtils.endsWithIgnoreCase((CharSequence)file, (CharSequence)ZIP_EXTENSION);
        }).collect(Collectors.toList());
        containerOptUrls = containerOptUrls.stream().filter(url -> {
            String file = org.apache.commons.io.FileUtils.toFile((URL)url).getAbsolutePath();
            return !StringUtils.endsWithIgnoreCase((CharSequence)file, (CharSequence)POM_XML) && !StringUtils.endsWithIgnoreCase((CharSequence)file, (CharSequence)POM_EXTENSION) && !StringUtils.endsWithIgnoreCase((CharSequence)file, (CharSequence)ZIP_EXTENSION);
        }).collect(Collectors.toList());
        if (ArtifactClassificationType.MODULE.equals((Object)rootArtifactType)) {
            File rootArtifactOutputFile = this.resolveRootArtifactFile(context.getRootArtifact());
            if (rootArtifactOutputFile == null) {
                throw new IllegalStateException("rootArtifact (" + context.getRootArtifact() + ") identified as MODULE but doesn't have an output");
            }
            containerMuleUrls.add(0, this.toUrl(rootArtifactOutputFile));
        }
        this.resolveSnapshotVersionsToTimestampedFromClassPath(containerMuleUrls, context.getClassPathURLs());
        return new Pair(containerMuleUrls, containerOptUrls);
    }

    private List<Dependency> selectContainerManagedDependencies(ClassPathClassifierContext context, List<Dependency> directDependencies, ArtifactClassificationType rootArtifactType, List<RemoteRepository> rootArtifactRemoteRepositories) {
        ArrayList managedDependencies;
        if (!rootArtifactType.equals((Object)ArtifactClassificationType.MODULE)) {
            managedDependencies = Lists.newArrayList((Iterable)directDependencies.stream().map(directDep -> {
                try {
                    ArtifactDescriptorResult readArtifactDescriptor = this.dependencyResolver.readArtifactDescriptor(directDep.getArtifact(), rootArtifactRemoteRepositories);
                    return readArtifactDescriptor == null ? Collections.emptyList() : readArtifactDescriptor.getManagedDependencies();
                }
                catch (ArtifactDescriptorException e) {
                    throw new IllegalStateException("Couldn't read artifact: '" + directDep.getArtifact() + "' while collecting managed dependencies for Container", e);
                }
            }).flatMap(l -> l.stream()).collect(Collectors.toCollection(() -> new TreeSet((d1, d2) -> {
                if (ArtifactIdUtils.toVersionlessId((Artifact)d1.getArtifact()).equals(ArtifactIdUtils.toVersionlessId((Artifact)d2.getArtifact()))) {
                    try {
                        return this.versionScheme.parseVersion(d1.getArtifact().getVersion()).compareTo((Object)this.versionScheme.parseVersion(d2.getArtifact().getVersion()));
                    }
                    catch (InvalidVersionSpecificationException e) {
                        this.logger.warn("Cannot parse version: " + e.getMessage());
                        return 1;
                    }
                }
                return 1;
            }))));
        } else {
            try {
                managedDependencies = Lists.newArrayList((Iterable)this.dependencyResolver.readArtifactDescriptor(context.getRootArtifact()).getManagedDependencies());
            }
            catch (ArtifactDescriptorException e) {
                throw new IllegalStateException("Couldn't collect managed dependencies for rootArtifact (" + context.getRootArtifact() + ")", e);
            }
        }
        return managedDependencies;
    }

    private Predicate<Dependency> getContainerDirectDependenciesFilter(ArtifactClassificationType rootArtifactType) {
        Predicate<Dependency> xmlApisInContainer = MuleSystemProperties.classloaderContainerJpmsModuleLayer() ? directDep -> !JPMS_CONTAINER_ARTIFACT_COORDINATES_DENYLIST.contains(directDep.getArtifact().getGroupId() + MAVEN_COORDINATES_SEPARATOR + directDep.getArtifact().getArtifactId()) : directDep -> true;
        return xmlApisInContainer.and(rootArtifactType.equals((Object)ArtifactClassificationType.MODULE) ? directDep -> directDep.getScope().equals("provided") || directDep.getScope().equals("compile") : directDep -> directDep.getScope().equals("provided") || directDep.getArtifact().getClassifier().equals("mule-plugin"));
    }

    private List<PluginUrlClassification> buildPluginUrlClassifications(ClassPathClassifierContext context, List<Dependency> directDependencies, ArtifactClassificationType rootArtifactType, List<RemoteRepository> rootArtifactRemoteRepositories) {
        ArrayList pluginsClassified = Lists.newArrayList();
        Artifact rootArtifact = context.getRootArtifact();
        List pluginsArtifacts = directDependencies.stream().filter(dependency -> dependency.getArtifact().getClassifier().equals("mule-plugin")).map(dependency -> dependency.getArtifact()).collect(Collectors.toList());
        this.logger.debug("{} plugins defined to be classified", (Object)pluginsArtifacts.size());
        Predicate<Dependency> mulePluginDependencyFilter = dependency -> dependency.getArtifact().getClassifier().equals("mule-plugin") && dependency.getScope().equals("compile");
        if (ArtifactClassificationType.PLUGIN.equals((Object)rootArtifactType)) {
            this.logger.debug("rootArtifact '{}' identified as Mule plugin", (Object)rootArtifact);
            this.buildPluginUrlClassification(rootArtifact, context, mulePluginDependencyFilter, pluginsClassified, rootArtifactRemoteRepositories);
            pluginsArtifacts = pluginsArtifacts.stream().filter(pluginArtifact -> !rootArtifact.getGroupId().equals(pluginArtifact.getGroupId()) || !rootArtifact.getArtifactId().equals(pluginArtifact.getArtifactId())).collect(Collectors.toList());
        }
        pluginsArtifacts.stream().forEach(pluginArtifact -> this.buildPluginUrlClassification((Artifact)pluginArtifact, context, mulePluginDependencyFilter, pluginsClassified, rootArtifactRemoteRepositories));
        List<ArtifactClassificationNode> resolvedPluginsClassified = this.resolveArtifactsUsingSemanticVersioning(pluginsClassified);
        if (context.isExtensionMetadataGenerationEnabled()) {
            ExtensionPluginMetadataGenerator extensionPluginMetadataGenerator = new ExtensionPluginMetadataGenerator(context.getPluginResourcesFolder());
            for (ArtifactClassificationNode pluginClassifiedNode : resolvedPluginsClassified) {
                File pluginClassifiedFile = org.apache.commons.io.FileUtils.toFile((URL)pluginClassifiedNode.getUrls().get(0));
                if (!pluginClassifiedFile.isDirectory() && this.jarContainsMuleArtifactJson(pluginClassifiedFile)) continue;
                List<URL> urls = this.generateExtensionMetadata(pluginClassifiedNode.getArtifact(), context, extensionPluginMetadataGenerator, pluginClassifiedNode.getUrls(), rootArtifactRemoteRepositories);
                pluginClassifiedNode.setUrls(urls);
            }
        }
        return this.toPluginUrlClassification(resolvedPluginsClassified);
    }

    private boolean jarContainsMuleArtifactJson(File pluginClassifiedFile) {
        JarEntry muleArtifactJsonEntry;
        try (JarFile pluginClassifiedJar = new JarFile(pluginClassifiedFile);){
            muleArtifactJsonEntry = pluginClassifiedJar.getJarEntry(MULE_ARTIFACT_JSON_PATH);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error trying to check if JarFile '" + pluginClassifiedFile.getPath() + "' has the mule-artifact.json inside the folder " + MULE_ARTIFACT_JSON_PATH);
        }
        return muleArtifactJsonEntry != null;
    }

    private List<ArtifactClassificationNode> resolveArtifactsUsingSemanticVersioning(List<ArtifactClassificationNode> artifactClassificationNodes) {
        ArrayList resolved = Lists.newArrayList();
        artifactClassificationNodes.forEach(artifactClassificationNode -> {
            if (this.findArtifactClassified(resolved, artifactClassificationNode.getArtifact()).isPresent()) {
                return;
            }
            Reference highestArtifact = new Reference(artifactClassificationNode);
            artifactClassificationNodes.stream().forEach(candidate -> {
                if (candidate.getArtifact().getGroupId().equals(((ArtifactClassificationNode)highestArtifact.get()).getArtifact().getGroupId()) && candidate.getArtifact().getArtifactId().equals(((ArtifactClassificationNode)highestArtifact.get()).getArtifact().getArtifactId())) {
                    if (!AetherClassPathClassifier.areCompatibleVersions(((ArtifactClassificationNode)highestArtifact.get()).getArtifact().getVersion(), candidate.getArtifact().getVersion())) {
                        throw new IllegalStateException(String.format("Incompatible version of artifacts found: %s and %s", ArtifactIdUtils.toId((Artifact)((ArtifactClassificationNode)highestArtifact.get()).getArtifact()), ArtifactIdUtils.toId((Artifact)candidate.getArtifact())));
                    }
                    this.logger.debug("Checking for highest version of artifact, already discovered: '{}' versus: '{}'", (Object)ArtifactIdUtils.toId((Artifact)((ArtifactClassificationNode)highestArtifact.get()).getArtifact()), (Object)ArtifactIdUtils.toId((Artifact)candidate.getArtifact()));
                    if (AetherClassPathClassifier.isHighestVersion(candidate.getArtifact().getVersion(), ((ArtifactClassificationNode)highestArtifact.get()).getArtifact().getVersion())) {
                        this.logger.warn("Replacing artifact: '{}' for highest version: '{}'", (Object)ArtifactIdUtils.toId((Artifact)((ArtifactClassificationNode)highestArtifact.get()).getArtifact()), (Object)ArtifactIdUtils.toId((Artifact)candidate.getArtifact()));
                        highestArtifact.set(candidate);
                    }
                }
            });
            resolved.add((ArtifactClassificationNode)highestArtifact.get());
        });
        return resolved;
    }

    private List<ServiceUrlClassification> toServiceUrlClassification(Collection<ArtifactClassificationNode> classificationNodes) {
        ServiceResourcesResolver serviceResourcesResolver = new ServiceResourcesResolver(classificationNodes);
        return classificationNodes.stream().map(node -> {
            String versionLessId = ArtifactIdUtils.toVersionlessId((Artifact)node.getArtifact());
            return serviceResourcesResolver.resolveServiceResourcesFor(new ArtifactUrlClassification(versionLessId, node.getArtifact(), node.getUrls()));
        }).collect(Collectors.toList());
    }

    private List<PluginUrlClassification> toPluginUrlClassification(Collection<ArtifactClassificationNode> classificationNodes) {
        LinkedHashMap classifiedPluginUrls = Maps.newLinkedHashMap();
        for (ArtifactClassificationNode node : classificationNodes) {
            List<String> pluginDependencies = node.getArtifactDependencies().stream().map(dependency -> ArtifactIdUtils.toVersionlessId((Artifact)dependency.getArtifact())).collect(Collectors.toList());
            String versionLessId = ArtifactIdUtils.toVersionlessId((Artifact)node.getArtifact());
            PluginUrlClassification pluginUrlClassification = this.pluginResourcesResolver.resolvePluginResourcesFor(new PluginUrlClassification(versionLessId, node.getUrls(), node.getExportClasses(), pluginDependencies));
            classifiedPluginUrls.put(versionLessId, pluginUrlClassification);
        }
        for (PluginUrlClassification pluginUrlClassification : classifiedPluginUrls.values()) {
            for (String dependency2 : pluginUrlClassification.getPluginDependencies()) {
                PluginUrlClassification dependencyPlugin = (PluginUrlClassification)classifiedPluginUrls.get(dependency2);
                if (dependencyPlugin == null) {
                    throw new IllegalStateException("Unable to find a plugin dependency: " + dependency2);
                }
                pluginUrlClassification.getExportedPackages().removeAll(dependencyPlugin.getExportedPackages());
            }
        }
        return Lists.newArrayList(classifiedPluginUrls.values());
    }

    private void buildPluginUrlClassification(Artifact artifactToClassify, ClassPathClassifierContext context, Predicate<Dependency> directDependenciesFilter, List<ArtifactClassificationNode> artifactsClassified, List<RemoteRepository> rootArtifactRemoteRepositories) {
        List<URL> urls = this.resolveUrls(artifactToClassify, context, rootArtifactRemoteRepositories);
        this.buildClassification(artifactToClassify, context, directDependenciesFilter, artifactsClassified, rootArtifactRemoteRepositories, urls);
    }

    private void buildServiceUrlClassification(Artifact artifactToClassify, ClassPathClassifierContext context, Predicate<Dependency> directDependenciesFilter, List<ArtifactClassificationNode> artifactsClassified, List<RemoteRepository> rootArtifactRemoteRepositories) {
        File serviceExplodedDir;
        try {
            serviceExplodedDir = Files.createTempDirectory(artifactToClassify.getArtifactId(), new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't resolve dependencies for artifact: '" + artifactToClassify + "' classification", e);
        }
        URL serviceBundleUrl = this.resolveUrls(artifactToClassify, context, rootArtifactRemoteRepositories).get(0);
        try {
            FileUtils.unzip((File)Paths.get(serviceBundleUrl.toURI()).toFile(), (File)serviceExplodedDir);
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalStateException("Couldn't resolve dependencies for artifact: '" + artifactToClassify + "' classification", e);
        }
        ArrayList<URL> serviceUrls = new ArrayList<URL>();
        try {
            serviceUrls.add(serviceExplodedDir.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Couldn't resolve dependencies for artifact: '" + artifactToClassify + "' classification", e);
        }
        ArtifactClassificationNode artifactUrlClassification = new ArtifactClassificationNode(artifactToClassify, serviceUrls, Collections.emptyList(), Collections.emptyList());
        this.logger.debug("Artifact discovered: {}", (Object)ArtifactIdUtils.toId((Artifact)artifactUrlClassification.getArtifact()));
        artifactsClassified.add(artifactUrlClassification);
    }

    private List<URL> resolveUrls(Artifact artifactToClassify, ClassPathClassifierContext context, List<RemoteRepository> rootArtifactRemoteRepositories) {
        List<URL> urls;
        try {
            DependencyFilter dependencyFilter = DependencyFilterUtils.andFilter((DependencyFilter[])new DependencyFilter[]{DependencyFilterUtils.classpathFilter((String[])new String[]{"compile"}), new PatternExclusionsDependencyFilter(context.getExcludedArtifacts()), DependencyFilterUtils.orFilter((DependencyFilter[])new DependencyFilter[]{new PatternExclusionsDependencyFilter("*:*:*:mule-plugin:*"), new PatternInclusionsDependencyFilter(ArtifactIdUtils.toId((Artifact)artifactToClassify))})});
            List<File> resolvedDependencies = this.dependencyResolver.resolveDependencies(new Dependency(artifactToClassify, "compile"), Collections.emptyList(), Collections.emptyList(), dependencyFilter, rootArtifactRemoteRepositories);
            urls = this.toUrl(resolvedDependencies);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't resolve dependencies for artifact: '" + artifactToClassify + "' classification", e);
        }
        return urls;
    }

    private void buildClassification(Artifact artifactToClassify, ClassPathClassifierContext context, Predicate<Dependency> directDependenciesFilter, List<ArtifactClassificationNode> artifactsClassified, List<RemoteRepository> rootArtifactRemoteRepositories, List<URL> urls) {
        List<Dependency> directDependencies;
        ArrayList artifactDependencies = Lists.newArrayList();
        try {
            directDependencies = this.dependencyResolver.getDirectDependencies(artifactToClassify, rootArtifactRemoteRepositories);
        }
        catch (ArtifactDescriptorException e) {
            throw new IllegalStateException("Couldn't get direct dependencies for artifact: '" + artifactToClassify + "'", e);
        }
        this.logger.debug("Searching for dependencies on direct dependencies of artifact {}", (Object)artifactToClassify);
        List<Artifact> pluginArtifactDependencies = this.filterArtifacts(directDependencies, directDependenciesFilter);
        this.logger.debug("Artifacts {} identified a plugin dependencies for plugin {}", pluginArtifactDependencies, (Object)artifactToClassify);
        pluginArtifactDependencies.stream().map(artifact -> {
            this.buildPluginUrlClassification((Artifact)artifact, context, directDependenciesFilter, artifactsClassified, rootArtifactRemoteRepositories);
            return this.findArtifactClassified((Collection<ArtifactClassificationNode>)artifactsClassified, (Artifact)artifact).orElseThrow(() -> new IllegalStateException(String.format("Should %s be already added to the list of artifacts classified", ArtifactIdUtils.toId((Artifact)artifact))));
        }).forEach(artifactDependencies::add);
        List<Class> exportClasses = this.getArtifactExportedClasses(artifactToClassify, context, rootArtifactRemoteRepositories);
        this.resolveSnapshotVersionsToTimestampedFromClassPath(urls, context.getClassPathURLs());
        ArtifactClassificationNode artifactUrlClassification = new ArtifactClassificationNode(artifactToClassify, urls, exportClasses, artifactDependencies);
        this.logger.debug("Artifact discovered: {}", (Object)ArtifactIdUtils.toId((Artifact)artifactUrlClassification.getArtifact()));
        artifactsClassified.add(artifactUrlClassification);
    }

    private Optional<ArtifactClassificationNode> findArtifactClassified(Collection<ArtifactClassificationNode> artifactsClassified, Artifact artifact) {
        return artifactsClassified.stream().filter(pluginClassified -> {
            Artifact pluginClassifiedArtifact = pluginClassified.getArtifact();
            return pluginClassifiedArtifact.getGroupId().equals(artifact.getGroupId()) && pluginClassifiedArtifact.getArtifactId().equals(artifact.getArtifactId());
        }).findFirst();
    }

    private List<Class> getArtifactExportedClasses(Artifact exporterArtifact, ClassPathClassifierContext context, List<RemoteRepository> rootArtifactRemoteRepositories) {
        AtomicReference<URL> artifactUrl = new AtomicReference<URL>();
        try {
            artifactUrl.set(this.dependencyResolver.resolveArtifact(exporterArtifact, rootArtifactRemoteRepositories).getArtifact().getFile().toURI().toURL());
        }
        catch (MalformedURLException | ArtifactResolutionException e) {
            throw new IllegalStateException("Unable to resolve artifact URL", e);
        }
        Artifact rootArtifact = context.getRootArtifact();
        return context.getExportPluginClasses().stream().filter(clazz -> {
            boolean isFromCurrentArtifact = clazz.getProtectionDomain().getCodeSource().getLocation().equals(artifactUrl.get());
            if (isFromCurrentArtifact && exporterArtifact != rootArtifact) {
                this.logger.warn("Exported class '{}' from plugin '{}' is being used from another artifact, {}", new Object[]{clazz.getSimpleName(), exporterArtifact, rootArtifact});
            }
            return isFromCurrentArtifact;
        }).collect(Collectors.toList());
    }

    private List<Artifact> filterArtifacts(List<Dependency> directDependencies, Predicate<Dependency> filter) {
        return directDependencies.stream().filter(dependency -> filter.test((Dependency)dependency)).map(dependency -> dependency.getArtifact()).collect(Collectors.toList());
    }

    private List<URL> generateExtensionMetadata(Artifact plugin, ClassPathClassifierContext context, ExtensionPluginMetadataGenerator pluginGenerator, List<URL> urls, List<RemoteRepository> rootArtifactRemoteRepositories) {
        Class extensionClass = pluginGenerator.scanForExtensionAnnotatedClasses(plugin, urls);
        if (extensionClass != null) {
            this.logger.debug("Plugin '{}' has been discovered as Extension", (Object)plugin);
            if (context.isExtensionMetadataGenerationEnabled()) {
                File generatedMetadataFolder = pluginGenerator.generateExtensionResources(plugin, extensionClass, this.dependencyResolver, rootArtifactRemoteRepositories);
                URL generatedTestResources = this.toUrl(generatedMetadataFolder);
                ArrayList appendedTestResources = Lists.newArrayList((Object[])new URL[]{generatedTestResources});
                appendedTestResources.addAll(urls);
                urls = appendedTestResources;
            }
        }
        return urls;
    }

    private Optional<Dependency> findDirectDependency(String groupId, String artifactId, Optional<String> classifier, List<Dependency> directDependencies) {
        return directDependencies.isEmpty() ? Optional.empty() : directDependencies.stream().filter(dependency -> dependency.getArtifact().getGroupId().equals(groupId) && dependency.getArtifact().getArtifactId().equals(artifactId) && (classifier.isPresent() && dependency.getArtifact().getClassifier().equals(classifier.get()) || !classifier.isPresent())).findFirst();
    }

    private Dependency findApplicationSharedLibArtifact(String pluginSharedLibCoords, Artifact rootArtifact, List<Dependency> directDependencies) {
        Optional<Dependency> pluginSharedLibDependency = this.discoverDependency(pluginSharedLibCoords, rootArtifact, directDependencies);
        if (!pluginSharedLibDependency.isPresent()) {
            throw new IllegalStateException("Application shared lib artifact '" + pluginSharedLibCoords + "' in order to be resolved has to be declared as " + "test" + " dependency of your Maven project (" + rootArtifact + ")");
        }
        return pluginSharedLibDependency.get();
    }

    private Dependency findApplicationLibArtifact(String pluginSharedLibCoords, Artifact rootArtifact, List<Dependency> directDependencies) {
        Optional<Dependency> pluginSharedLibDependency = this.discoverDependency(pluginSharedLibCoords, rootArtifact, directDependencies);
        if (!pluginSharedLibDependency.isPresent()) {
            throw new IllegalStateException("Application lib artifact '" + pluginSharedLibCoords + "' in order to be resolved has to be declared as " + "test" + " dependency of your Maven project (" + rootArtifact + ")");
        }
        return pluginSharedLibDependency.get();
    }

    private Dependency findTestRunnerExportedLibArtifact(String testRunnerExportedLbCoords, Artifact rootArtifact, List<Dependency> directDependencies) {
        Optional<Dependency> pluginSharedLibDependency = this.discoverDependency(testRunnerExportedLbCoords, rootArtifact, directDependencies);
        if (!pluginSharedLibDependency.isPresent()) {
            throw new IllegalStateException("Test runner exported lib artifact '" + testRunnerExportedLbCoords + "' in order to be resolved has to be declared as " + "test" + " dependency of your Maven project (" + rootArtifact + ")");
        }
        return pluginSharedLibDependency.get();
    }

    private Optional<Dependency> discoverDependency(String artifactCoords, Artifact rootArtifact, List<Dependency> directDependencies) {
        Optional<String> classifier;
        String[] artifactCoordsSplit = artifactCoords.split(MAVEN_COORDINATES_SEPARATOR);
        if (artifactCoordsSplit.length < 2 || artifactCoordsSplit.length > 3) {
            throw new IllegalArgumentException("Artifact coordinates should be in format of groupId:artifactId or groupId:artifactId:classifier, '" + artifactCoords + "' is not a valid format");
        }
        String groupId = artifactCoordsSplit[0];
        String artifactId = artifactCoordsSplit[1];
        Optional<String> optional = classifier = artifactCoordsSplit.length > 2 ? Optional.of(artifactCoordsSplit[2]) : Optional.empty();
        if (rootArtifact.getGroupId().equals(groupId) && rootArtifact.getArtifactId().equals(artifactId)) {
            this.logger.debug("'{}' artifact coordinates matched with rootArtifact '{}', resolving version from rootArtifact", (Object)artifactCoords, (Object)rootArtifact);
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, "jar", rootArtifact.getVersion());
            this.logger.debug("'{}' artifact coordinates resolved to: '{}'", (Object)artifactCoords, (Object)artifact);
            return Optional.of(new Dependency((Artifact)artifact, "compile"));
        }
        this.logger.debug("Resolving version for '{}' from direct dependencies", (Object)artifactCoords);
        return this.findDirectDependency(groupId, artifactId, classifier, directDependencies);
    }

    private List<URL> buildTestRunnerUrlClassification(ClassPathClassifierContext context, List<Dependency> directDependencies, ArtifactClassificationType rootArtifactType, List<RemoteRepository> rootArtifactRemoteRepositories) {
        this.logger.debug("Building application classification");
        Artifact rootArtifact = context.getRootArtifact();
        PatternInclusionsDependencyFilter dependencyFilter = new PatternInclusionsDependencyFilter(context.getTestInclusions());
        this.logger.debug("Using filter for dependency graph to include: '{}'", context.getTestInclusions());
        ArrayList appFiles = Lists.newArrayList();
        ArrayList exclusionsPatterns = Lists.newArrayList();
        if (ArtifactClassificationType.APPLICATION.equals((Object)rootArtifactType)) {
            this.logger.debug("RootArtifact identified as {} so is going to be added to application classification", (Object)ArtifactClassificationType.APPLICATION);
            File rootArtifactOutputFile = this.resolveRootArtifactFile(rootArtifact);
            if (rootArtifactOutputFile != null) {
                appFiles.add(rootArtifactOutputFile);
            } else {
                this.logger.warn("rootArtifact '{}' identified as {} but doesn't have an output {} file", new Object[]{rootArtifact, rootArtifactType, "jar"});
            }
        } else {
            this.logger.debug("RootArtifact already classified as plugin or module, excluding it from application classification");
            exclusionsPatterns.add(rootArtifact.getGroupId() + MAVEN_COORDINATES_SEPARATOR + rootArtifact.getArtifactId() + MAVEN_COORDINATES_SEPARATOR + "*" + MAVEN_COORDINATES_SEPARATOR + "*" + MAVEN_COORDINATES_SEPARATOR + rootArtifact.getVersion());
        }
        directDependencies = directDependencies.stream().map(toTransform -> {
            if (toTransform.getScope().equals("test") && !"mule-plugin".equals(toTransform.getArtifact().getClassifier())) {
                if (TESTS_CLASSIFIER.equals(toTransform.getArtifact().getClassifier())) {
                    return toTransform.setScope("compile").setExclusions(Collections.singleton(new Exclusion("*", "*", "*", "*")));
                }
                return toTransform.setScope("compile");
            }
            if ((ArtifactClassificationType.PLUGIN.equals((Object)rootArtifactType) || "mule-plugin".equals(toTransform.getArtifact().getClassifier()) || MULE_SERVICE_CLASSIFIER.equals(toTransform.getArtifact().getClassifier())) && toTransform.getScope().equals("compile")) {
                return toTransform.setScope("provided");
            }
            if (rootArtifactType == ArtifactClassificationType.MODULE && toTransform.getScope().equals("compile")) {
                return toTransform.setScope("provided");
            }
            Artifact artifact = toTransform.getArtifact();
            if (context.getApplicationSharedLibCoordinates().contains(artifact.getGroupId() + MAVEN_COORDINATES_SEPARATOR + artifact.getArtifactId())) {
                return toTransform.setScope("compile");
            }
            return toTransform;
        }).collect(Collectors.toList());
        this.logger.debug("OR exclude: {}", context.getExcludedArtifacts());
        exclusionsPatterns.addAll(context.getExcludedArtifacts());
        if (!context.getTestExclusions().isEmpty()) {
            this.logger.debug("OR exclude application specific artifacts: {}", context.getTestExclusions());
            exclusionsPatterns.addAll(context.getTestExclusions());
        }
        try {
            ArrayList managedDependencies = Lists.newArrayList((Iterable)this.dependencyResolver.readArtifactDescriptor(rootArtifact).getManagedDependencies());
            managedDependencies.addAll(directDependencies.stream().filter(directDependency -> !directDependency.getScope().equals("test")).collect(Collectors.toList()));
            this.logger.debug("Resolving dependency graph for '{}' scope direct dependencies: {} and managed dependencies {}", new Object[]{"test", directDependencies, managedDependencies});
            Dependency rootTestDependency = new Dependency((Artifact)new DefaultArtifact(rootArtifact.getGroupId(), rootArtifact.getArtifactId(), TESTS_CLASSIFIER, "jar", rootArtifact.getVersion()), "test");
            List<File> urls = this.dependencyResolver.resolveDependencies(rootTestDependency, directDependencies, managedDependencies, DependencyFilterUtils.orFilter((DependencyFilter[])new DependencyFilter[]{dependencyFilter, new PatternExclusionsDependencyFilter(exclusionsPatterns)}), rootArtifactRemoteRepositories);
            appFiles.addAll(urls);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't resolve dependencies for application '" + context.getRootArtifact() + "' classification", e);
        }
        ArrayList testRunnerLibUrls = Lists.newArrayList(this.toUrl(appFiles));
        this.logger.debug("Appending URLs to test runner plugin: {}", context.getTestRunnerPluginUrls());
        testRunnerLibUrls.addAll(context.getTestRunnerPluginUrls());
        this.resolveSnapshotVersionsToTimestampedFromClassPath(testRunnerLibUrls, context.getClassPathURLs());
        return testRunnerLibUrls;
    }

    private File resolveRootArtifactFile(Artifact rootArtifact) {
        DefaultArtifact jarArtifact = new DefaultArtifact(rootArtifact.getGroupId(), rootArtifact.getArtifactId(), "jar", "jar", rootArtifact.getVersion());
        try {
            return this.dependencyResolver.resolveArtifact((Artifact)jarArtifact).getArtifact().getFile();
        }
        catch (ArtifactResolutionException e) {
            this.logger.warn("'{}' rootArtifact output {} file couldn't be resolved", (Object)rootArtifact, (Object)"jar");
            return null;
        }
    }

    private List<URL> toUrl(Collection<File> files) {
        return files.stream().map(this::toUrl).collect(Collectors.toList());
    }

    private URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Couldn't get URL", e);
        }
    }

    private void resolveSnapshotVersionsToTimestampedFromClassPath(List<URL> resolvedURLs, List<URL> classpathURLs) {
        this.logger.debug("Checking if resolved SNAPSHOT URLs had a timestamped version already included in class path URLs");
        Map<File, List<URL>> classpathFolders = this.groupArtifactUrlsByFolder(classpathURLs);
        WildcardFileFilter snapshotFileFilter = new WildcardFileFilter(SNAPSHOT_WILCARD_FILE_FILTER);
        ListIterator<URL> listIterator = resolvedURLs.listIterator();
        while (listIterator.hasNext()) {
            URL urlResolved = listIterator.next();
            File artifactResolvedFile = org.apache.commons.io.FileUtils.toFile((URL)urlResolved);
            if (!snapshotFileFilter.accept(artifactResolvedFile)) continue;
            File artifactResolvedFileParentFile = artifactResolvedFile.getParentFile();
            this.logger.debug("Checking if resolved SNAPSHOT artifact: '{}' has a timestamped version already in class path", (Object)artifactResolvedFile);
            URL urlFromClassPath = null;
            if (classpathFolders.containsKey(artifactResolvedFileParentFile)) {
                urlFromClassPath = this.findArtifactUrlFromClassPath(classpathFolders, artifactResolvedFile);
            }
            if (urlFromClassPath != null) {
                this.logger.debug("Replacing resolved URL '{}' from class path URL '{}'", (Object)urlResolved, (Object)urlFromClassPath);
                listIterator.set(urlFromClassPath);
                continue;
            }
            this.logger.warn("'{}' resolved SNAPSHOT version couldn't be matched to a class path URL. Probably the artifact would be loaded from the installed file on your local Maven repository", (Object)artifactResolvedFile);
        }
    }

    private Map<File, List<URL>> groupArtifactUrlsByFolder(List<URL> classpathURLs) {
        HashMap classpathFolders = Maps.newHashMap();
        classpathURLs.forEach(url -> {
            File folder = org.apache.commons.io.FileUtils.toFile((URL)url).getParentFile();
            if (classpathFolders.containsKey(folder)) {
                ((List)classpathFolders.get(folder)).add(url);
            } else {
                classpathFolders.put(folder, Lists.newArrayList((Object[])new URL[]{url}));
            }
        });
        return classpathFolders;
    }

    private URL findArtifactUrlFromClassPath(Map<File, List<URL>> classpathFolders, File artifactResolvedFile) {
        List<URL> urls = classpathFolders.get(artifactResolvedFile.getParentFile());
        this.logger.debug("URLs found for '{}' in class path are: {}", (Object)artifactResolvedFile, urls);
        if (urls.size() == 1) {
            return urls.get(0);
        }
        Optional<URL> urlOpt = StringUtils.endsWithIgnoreCase((CharSequence)artifactResolvedFile.getName(), (CharSequence)TESTS_JAR) ? urls.stream().filter(url -> org.apache.commons.io.FileUtils.toFile((URL)url).getAbsolutePath().endsWith(TESTS_JAR)).findFirst() : urls.stream().filter(url -> {
            String filePath = org.apache.commons.io.FileUtils.toFile((URL)url).getAbsolutePath();
            return !filePath.endsWith(TESTS_JAR) && filePath.endsWith("jar");
        }).findFirst();
        return urlOpt.orElse(null);
    }

    public static boolean areCompatibleVersions(String version1, String version2) {
        return AetherClassPathClassifier.getSemver(version1).getMajor().equals(AetherClassPathClassifier.getSemver(version2).getMajor());
    }

    public static String getHighestVersion(String version1, String version2) {
        Semver semver1 = new Semver(version1, Semver.SemverType.LOOSE);
        Semver semver2 = new Semver(version2, Semver.SemverType.LOOSE);
        return semver1.isGreaterThan(semver2) ? semver1.getOriginalValue() : semver2.getOriginalValue();
    }

    public static boolean isHighestVersion(String version1, String version2) {
        Semver semver1 = new Semver(version1, Semver.SemverType.LOOSE);
        Semver semver2 = new Semver(version2, Semver.SemverType.LOOSE);
        return semver1.isGreaterThan(semver2);
    }

    private static Semver getSemver(String version) {
        try {
            return new Semver(version, Semver.SemverType.LOOSE);
        }
        catch (SemverException e) {
            throw new IllegalArgumentException(String.format("Unable to parse version %s, version is not following semantic versioning", version), e);
        }
    }

    @Override
    public void close() throws Exception {
        this.dependencyResolver.close();
        this.artifactClassificationTypeResolver.close();
    }
}

