/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classloader;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestArtifactClassLoaderFilter
implements ArtifactClassLoaderFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ArtifactClassLoaderFilter classLoaderFilter;
    private final Map<String, Object> exportedClasses;
    private final Set<String> exportedPackages;

    public TestArtifactClassLoaderFilter(ArtifactClassLoaderFilter classLoaderFilter, List<Class> exportedClasses) {
        Objects.requireNonNull(classLoaderFilter, "classLoaderFilter cannot be null");
        Objects.requireNonNull(exportedClasses, "exportedClasses cannot be null");
        this.classLoaderFilter = classLoaderFilter;
        this.exportedClasses = exportedClasses.stream().collect(Collectors.toMap(Class::getName, Function.identity()));
        this.exportedPackages = new HashSet<String>(classLoaderFilter.getExportedClassPackages());
        this.exportedPackages.addAll(exportedClasses.stream().map(clazz -> ClassUtils.getPackageName((String)clazz.getName())).collect(Collectors.toList()));
    }

    public boolean exportsClass(String name) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (String)"Class name cannot be empty");
        boolean exported = this.classLoaderFilter.exportsClass(name);
        if (!exported) {
            boolean bl = exported = this.exportedClasses.get(name) != null;
            if (exported) {
                this.logger.warn(StringMessageUtils.getBoilerPlate((List)Lists.newArrayList((Object[])new String[]{"WARNING:", " ", "Class: '" + name + "' is NOT exposed by the plugin but it will be visible due to it was manually forced to be exported for testing purposes.", " ", "Check if this is really necessary, this class won't be visible in standalone mode."}), (char)'*', (int)80));
            }
        }
        return exported;
    }

    public boolean exportsPackage(String name) {
        return this.getExportedClassPackages().contains(name);
    }

    public boolean exportsResource(String name) {
        return this.classLoaderFilter.exportsResource(name);
    }

    public Set<String> getExportedClassPackages() {
        return this.exportedPackages;
    }

    public Set<String> getExportedResources() {
        return this.classLoaderFilter.getExportedResources();
    }
}

