/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classloader.container;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.IteratorUtils;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleContainerClassLoaderWrapper;
import org.mule.runtime.container.internal.ContainerClassLoaderFactory;
import org.mule.runtime.container.internal.JreModuleDiscoverer;
import org.mule.runtime.container.internal.PreFilteredContainerClassLoaderCreator;
import org.mule.runtime.jpms.api.JpmsUtils;
import org.mule.runtime.jpms.api.MuleContainerModule;
import org.mule.runtime.jpms.api.MultiLevelClassLoaderFactory;
import org.mule.test.runner.classloader.container.TestContainerClassLoaderAssembler;
import org.mule.test.runner.classloader.container.TestPreFilteredContainerClassLoaderCreator;

public class DefaultTestContainerClassLoaderAssembler
implements TestContainerClassLoaderAssembler {
    private ModuleRepository moduleRepository;
    private final List<String> extraBootPackages;
    private final Set<String> extraPrivilegedArtifacts;
    private final URL[] muleUrls;
    private final URL[] optUrls;

    public DefaultTestContainerClassLoaderAssembler(List<String> extraBootPackages, Set<String> extraPrivilegedArtifacts, List<URL> muleUrls, List<URL> optUrls) {
        this.extraBootPackages = extraBootPackages;
        this.extraPrivilegedArtifacts = extraPrivilegedArtifacts;
        this.muleUrls = muleUrls.toArray(new URL[muleUrls.size()]);
        this.optUrls = optUrls.toArray(new URL[optUrls.size()]);
    }

    @Override
    public MuleContainerClassLoaderWrapper createContainerClassLoader() {
        ImmutableSet bootPackages = ImmutableSet.builder().addAll(this.extraBootPackages).addAll((Iterable)((MuleContainerModule)new JreModuleDiscoverer().discover().get(0)).getExportedPackages()).build();
        ClassLoader launcherArtifact = this.createLauncherClassLoader((Set<String>)bootPackages);
        ClassLoader containerSystemClassloader = JpmsUtils.createModuleLayerClassLoader((URL[])this.optUrls, (URL[])this.muleUrls, (MultiLevelClassLoaderFactory)MultiLevelClassLoaderFactory.MULTI_LEVEL_URL_CLASSLOADER_FACTORY, (ClassLoader)launcherArtifact);
        TestPreFilteredContainerClassLoaderCreator testContainerClassLoaderCreator = new TestPreFilteredContainerClassLoaderCreator(containerSystemClassloader, (Set<String>)bootPackages, this.extraPrivilegedArtifacts);
        this.moduleRepository = testContainerClassLoaderCreator.getModuleRepository();
        return new ContainerClassLoaderFactory((PreFilteredContainerClassLoaderCreator)testContainerClassLoaderCreator, cl -> launcherArtifact).createContainerClassLoader(containerSystemClassloader);
    }

    protected ClassLoader createLauncherClassLoader(Set<String> extraBootPackages) {
        return new TestLauncherClassLoader(this.getClass().getClassLoader(), extraBootPackages);
    }

    @Override
    public ModuleRepository getModuleRepository() {
        return this.moduleRepository;
    }

    private static final class TestLauncherClassLoader
    extends ClassLoader {
        private final Set<String> extraBootPackages;

        private TestLauncherClassLoader(ClassLoader parent, Set<String> extraBootPackages) {
            super(parent);
            this.extraBootPackages = extraBootPackages;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.extraBootPackages.stream().anyMatch(bp -> name.startsWith((String)bp))) {
                return super.loadClass(name, resolve);
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        public URL getResource(String name) {
            if (this.extraBootPackages.stream().anyMatch(bp -> name.startsWith("META-INF/services/" + bp))) {
                return super.getResource(name);
            }
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (this.extraBootPackages.stream().anyMatch(bp -> name.startsWith("META-INF/services/" + bp))) {
                return super.getResources(name);
            }
            return Collections.emptyEnumeration();
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            Enumeration<URL> resourceUrls = super.findResources(name);
            return IteratorUtils.asEnumeration(Collections.list(resourceUrls).stream().filter(url -> this.jreResource(name, (URL)url)).iterator());
        }

        @Override
        public URL findResource(String name) {
            URL url = super.findResource(name);
            if (this.jreResource(name, url)) {
                return url;
            }
            return null;
        }

        private boolean jreResource(String name, URL url) {
            if (url == null && this.getParent() != null) {
                url = this.getParent().getResource(name);
                return url != null && url.getFile().matches(".*?\\/jre\\/lib\\/\\w+\\.jar\\!.*");
            }
            return true;
        }

        static {
            TestLauncherClassLoader.registerAsParallelCapable();
        }
    }
}

