/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.utils;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.management.MBeanServer;
import javax.xml.bind.DatatypeConverter;
import org.mule.runtime.api.util.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TroubleshootingUtils {
    private static final Optional<String> JENKINS_WORKSPACE_PATH = Optional.ofNullable(System.getProperty("jenkins.workspace.path"));
    private static final String HEISENBERG_ARTIFACT_LOCATION = "org/mule/tests/mule-heisenberg-extension/4.3.0-SNAPSHOT";
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final String OS_NAME_FAMILY = TroubleshootingUtils.getOsNameFamily();
    private static final Map<String, String> GET_OS_PROCESSES_COMMANDS = TroubleshootingUtils.initializeGetOSProcessesCommands();
    public static final String PLUGINS_COPIED_FOR_TROUBLESHOOTING_FOLDER = "pluginsCopiedForTroubleshooting";
    public static final String HEAP_DUMP_FILE_NAME = "heapDump.hprof";
    public static final String HEAP_DUMP_ONLY_LIVE_FILE_NAME = "heapDumpOnlyLive.hprof";
    public static final String OS_PROCESSES_LOG_NAME = "osProcessesFile.log";
    private static final Logger LOGGER = LoggerFactory.getLogger(TroubleshootingUtils.class);

    private TroubleshootingUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Path getJenkinsWorkspacePath(Path pluginJsonUrl) {
        return TroubleshootingUtils.getPathOfFileContaining(pluginJsonUrl, ".m2").getParent();
    }

    public static Optional<Path> getJenkinsWorkspacePath() {
        return JENKINS_WORKSPACE_PATH.map(p -> Paths.get(p, new String[0]));
    }

    public static Path getJenkinsWorkspacePath(URL pluginJsonUrl) {
        return TroubleshootingUtils.getJenkinsWorkspacePath(Paths.get(TroubleshootingUtils.getPathStringFromJarURL(pluginJsonUrl), new String[0])).getParent();
    }

    public static Path getJarPathFromPluginJson(Path pluginJsonUrl) {
        return TroubleshootingUtils.getPathOfFileContaining(pluginJsonUrl, "mule-plugin.jar");
    }

    public static Path getJarPathFromPluginJson(URL pluginJsonUrl) {
        return TroubleshootingUtils.getJarPathFromPluginJson(Paths.get(TroubleshootingUtils.getPathStringFromJarURL(pluginJsonUrl), new String[0]));
    }

    public static Path getPathOfFileContaining(URL pluginJsonUrl, String substring) {
        Path pluginJsonPath = Paths.get(TroubleshootingUtils.getPathStringFromJarURL(pluginJsonUrl), new String[0]);
        return TroubleshootingUtils.getPathOfFileContaining(pluginJsonPath, substring);
    }

    public static String getPathStringFromJarURL(URL pluginJsonUrl) {
        String pluginJsonString = "";
        if (pluginJsonUrl.toString().contains("jar:")) {
            JarURLConnection connection = null;
            try {
                connection = (JarURLConnection)pluginJsonUrl.openConnection();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            pluginJsonString = connection.getJarFileURL().getFile();
        } else {
            pluginJsonString = pluginJsonUrl.getPath();
        }
        return pluginJsonString;
    }

    public static Path getPathOfFileContaining(Path pluginJsonUrl, String substring) {
        Path auxPath;
        for (auxPath = pluginJsonUrl; auxPath != null && !auxPath.getFileName().toString().contains(substring); auxPath = auxPath.getParent()) {
        }
        if (pluginJsonUrl != null && auxPath == null) {
            throw new RuntimeException(String.format("Could not find the substring '%s' in path '%s'", substring, pluginJsonUrl.toAbsolutePath()));
        }
        return auxPath;
    }

    public static String getMD5FromFile(Path filePath) {
        String md5Checksum = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(Files.readAllBytes(filePath));
            byte[] digest = md.digest();
            md5Checksum = DatatypeConverter.printHexBinary((byte[])digest).toLowerCase();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("There was a problem getting MD5 Algorithm from the class MessageDigest", e);
        }
        return md5Checksum;
    }

    public static String getMD5FromFile(URL filePath) {
        return TroubleshootingUtils.getMD5FromFile(TroubleshootingUtils.getJarPathFromPluginJson(filePath));
    }

    public static void copyRepoContentsToAuxJenkinsFolder() throws IOException {
        Reference exceptionReference = new Reference();
        TroubleshootingUtils.getJenkinsWorkspacePath().ifPresent(jenkinsWorkspacePath -> {
            Path heisenbergSnapshotRoot = jenkinsWorkspacePath.resolve(".m2").resolve("repository").resolve(HEISENBERG_ARTIFACT_LOCATION);
            if (!heisenbergSnapshotRoot.toFile().exists()) {
                return;
            }
            try {
                Path jenkinsTroubleshootingFolderPath = TroubleshootingUtils.getJenkinsTroubleshootingFolderPath(heisenbergSnapshotRoot);
                Path repoContents = jenkinsTroubleshootingFolderPath.resolve("repoContents");
                if (repoContents.toFile().exists()) {
                    return;
                }
                repoContents.toFile().mkdirs();
                for (File f : heisenbergSnapshotRoot.toFile().listFiles()) {
                    Files.copy(f.toPath(), repoContents.resolve(f.getName()), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                exceptionReference.set((Object)e);
            }
        });
        if (exceptionReference.get() != null) {
            throw (IOException)exceptionReference.get();
        }
    }

    public static void copyFileToAuxJenkinsFolder(Path fileToCopy) throws IOException {
        Path jenkinsTroubleshootingFolderPath = TroubleshootingUtils.getJenkinsTroubleshootingFolderPath(fileToCopy);
        Path extensionJarTargetPath = Paths.get(jenkinsTroubleshootingFolderPath.toString(), fileToCopy.getFileName().toString());
        Files.copy(fileToCopy, extensionJarTargetPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
    }

    public static void copyPluginToAuxJenkinsFolderForTroubleshooting(Path pluginJsonUrl) throws IOException {
        TroubleshootingUtils.copyFileToAuxJenkinsFolder(TroubleshootingUtils.getJarPathFromPluginJson(pluginJsonUrl));
    }

    public static void copyPluginToAuxJenkinsFolderForTroubleshooting(URL pluginJsonUrl) throws IOException {
        TroubleshootingUtils.copyPluginToAuxJenkinsFolderForTroubleshooting(Paths.get(TroubleshootingUtils.getPathStringFromJarURL(pluginJsonUrl), new String[0]));
    }

    public static void copyOsRunningProcessesToAuxJenkinsFolder(URL pluginJsonUrl) throws IOException {
        Path jenkinsTroubleshootingFolderPath = TroubleshootingUtils.getJenkinsTroubleshootingFolderPath(Paths.get(TroubleshootingUtils.getPathStringFromJarURL(pluginJsonUrl), new String[0]));
        Path osProcessesTargetPath = Paths.get(jenkinsTroubleshootingFolderPath.toString(), OS_PROCESSES_LOG_NAME);
        if (osProcessesTargetPath.toFile().exists()) {
            return;
        }
        List<String> runningProcesses = TroubleshootingUtils.getRunningProcesses();
        Files.write(osProcessesTargetPath, runningProcesses, new OpenOption[0]);
    }

    public static Path getJenkinsTroubleshootingFolderPath(Path pluginJsonUrl) throws IOException {
        Path jenkinsTroubleshootingFolderPath = Paths.get(TroubleshootingUtils.getJenkinsWorkspacePath(pluginJsonUrl).toString(), PLUGINS_COPIED_FOR_TROUBLESHOOTING_FOLDER);
        if (!jenkinsTroubleshootingFolderPath.toFile().exists()) {
            Files.createDirectories(jenkinsTroubleshootingFolderPath, new FileAttribute[0]);
        }
        return jenkinsTroubleshootingFolderPath;
    }

    public static void generateHeapDumpInAuxJenkinsFolder(Path pluginJsonUrl) throws IOException {
        Path jenkinsTroubleshootingFolderPath = TroubleshootingUtils.getJenkinsTroubleshootingFolderPath(pluginJsonUrl);
        TroubleshootingUtils.dumpHeap(Paths.get(jenkinsTroubleshootingFolderPath.toString(), HEAP_DUMP_FILE_NAME).toString(), false);
        TroubleshootingUtils.dumpHeap(Paths.get(jenkinsTroubleshootingFolderPath.toString(), HEAP_DUMP_ONLY_LIVE_FILE_NAME).toString(), true);
    }

    public static void generateHeapDumpInAuxJenkinsFolder(URL pluginJsonUrl) throws IOException {
        TroubleshootingUtils.generateHeapDumpInAuxJenkinsFolder(Paths.get(TroubleshootingUtils.getPathStringFromJarURL(pluginJsonUrl), new String[0]));
    }

    public static void dumpHeap(String filePath, boolean live) throws IOException {
        if (Paths.get(filePath, new String[0]).toFile().exists()) {
            return;
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        HotSpotDiagnosticMXBean mxBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
        mxBean.dumpHeap(filePath, live);
    }

    public static String getLastModifiedDateFromUrl(URL filePathURL) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long lastModifiedDate = 0L;
        try {
            lastModifiedDate = new File(filePathURL.toURI()).lastModified();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return sdf.format(lastModifiedDate);
    }

    public static List<String> listEntriesInJar(File jarPath) throws IOException {
        ArrayList<String> entriesInJarList = new ArrayList<String>();
        entriesInJarList.add("name: '" + jarPath.getName() + "' - last modified time: '" + TroubleshootingUtils.getLastModifiedDateFromUrl(jarPath.toURI().toURL()) + "'");
        try (JarFile jarFile = new JarFile(jarPath);){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                String entryName = entry.getName();
                FileTime entryLastModifiedTime = entry.getLastModifiedTime();
                entriesInJarList.add("name: '" + entryName + "' - last modified time: '" + entryLastModifiedTime + "'");
            }
        }
        return entriesInJarList;
    }

    public static List<String> getRunningProcesses() {
        ArrayList<String> processesList = new ArrayList<String>();
        if (!GET_OS_PROCESSES_COMMANDS.containsKey(OS_NAME_FAMILY)) {
            return processesList;
        }
        String getOsProcessesCommand = GET_OS_PROCESSES_COMMANDS.get(OS_NAME_FAMILY);
        processesList.add(String.format("OS: '%s' - Command: '%s'", OS_NAME, getOsProcessesCommand));
        try {
            Process runningProcessesResult = Runtime.getRuntime().exec(GET_OS_PROCESSES_COMMANDS.get(OS_NAME_FAMILY));
            try (BufferedReader runningProcessesResultReader = new BufferedReader(new InputStreamReader(runningProcessesResult.getInputStream()));){
                String runningProcessLine;
                while ((runningProcessLine = runningProcessesResultReader.readLine()) != null) {
                    processesList.add(runningProcessLine);
                }
            }
        }
        catch (IOException e) {
            LOGGER.trace(e.getMessage());
        }
        return processesList;
    }

    public static String getOsNameFamily() {
        String osFamily = TroubleshootingUtils.isUnix() ? "unix" : (TroubleshootingUtils.isMac() ? "mac" : (TroubleshootingUtils.isWindows() ? "windows" : "other"));
        return osFamily;
    }

    private static boolean isUnix() {
        return OS_NAME.contains("nix") || OS_NAME.contains("nux") || OS_NAME.contains("aix");
    }

    private static boolean isMac() {
        return OS_NAME.contains("mac");
    }

    private static boolean isWindows() {
        return OS_NAME.startsWith("win");
    }

    private static Map<String, String> initializeGetOSProcessesCommands() {
        HashMap<String, String> getProcessesCommand = new HashMap<String, String>();
        getProcessesCommand.put("unix", "ps -aux");
        getProcessesCommand.put("mac", "ps -e");
        return getProcessesCommand;
    }
}

