/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import com.google.common.base.Joiner;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.filter.PatternInclusionsDependencyFilter;
import org.eclipse.aether.util.graph.visitor.PathRecordingDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.AetherRepositoryState;
import org.mule.maven.client.internal.AetherResolutionContext;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private AetherResolutionContext resolutionContext;
    private AetherRepositoryState repositoryState;

    public DependencyResolver(MavenConfiguration mavenConfiguration, Optional<WorkspaceReader> workspaceReader) {
        Preconditions.checkNotNull((Object)mavenConfiguration, (String)"mavenConfiguration cannot be null");
        this.resolutionContext = new AetherResolutionContext(mavenConfiguration);
        this.repositoryState = new AetherRepositoryState(this.resolutionContext.getLocalRepositoryLocation(), workspaceReader, this.resolutionContext.getAuthenticatorSelector(), this.resolutionContext.getProxySelector(), this.resolutionContext.getMirrorSelector(), mavenConfiguration.getForcePolicyUpdateNever(), mavenConfiguration.getForcePolicyUpdateAlways(), mavenConfiguration.getOfflineMode(), mavenConfiguration.getIgnoreArtifactDescriptorRepositories(), Optional.empty(), session -> {}, mavenConfiguration.getGlobalChecksumPolicy());
        if (this.logger.isDebugEnabled()) {
            this.resolutionContext.getAuthenticatorSelector().ifPresent(selector -> this.logger.debug("Using authenticator selector: " + ReflectionToStringBuilder.toString((Object)selector)));
        }
    }

    public ArtifactDescriptorResult readArtifactDescriptor(Artifact artifact) throws ArtifactDescriptorException {
        Preconditions.checkNotNull((Object)artifact, (String)"artifact cannot be null");
        ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(artifact, this.resolveRepositories(), null);
        return this.repositoryState.getSystem().readArtifactDescriptor((RepositorySystemSession)this.repositoryState.getSession(), request);
    }

    public ArtifactDescriptorResult readArtifactDescriptor(Artifact artifact, List<RemoteRepository> remoteRepositories) throws ArtifactDescriptorException {
        Preconditions.checkNotNull((Object)artifact, (String)"artifact cannot be null");
        ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(artifact, this.resolveRepositories(remoteRepositories), null);
        return this.repositoryState.getSystem().readArtifactDescriptor((RepositorySystemSession)this.repositoryState.getSession(), request);
    }

    public ArtifactResult resolveArtifact(Artifact artifact) throws ArtifactResolutionException {
        Preconditions.checkNotNull((Object)artifact, (String)"artifact cannot be null");
        ArtifactRequest request = new ArtifactRequest(artifact, this.resolveRepositories(), null);
        return this.repositoryState.getSystem().resolveArtifact((RepositorySystemSession)this.repositoryState.getSession(), request);
    }

    public ArtifactResult resolveArtifact(Artifact artifact, List<RemoteRepository> remoteRepositories) throws ArtifactResolutionException {
        Preconditions.checkNotNull((Object)artifact, (String)"artifact cannot be null");
        ArtifactRequest request = new ArtifactRequest(artifact, this.resolveRepositories(remoteRepositories), null);
        return this.repositoryState.getSystem().resolveArtifact((RepositorySystemSession)this.repositoryState.getSession(), request);
    }

    public List<Dependency> getDirectDependencies(Artifact artifact) throws ArtifactDescriptorException {
        Preconditions.checkNotNull((Object)artifact, (String)"artifact cannot be null");
        return this.readArtifactDescriptor(artifact).getDependencies();
    }

    public List<Dependency> getDirectDependencies(Artifact artifact, List<RemoteRepository> remoteRepositories) throws ArtifactDescriptorException {
        Preconditions.checkNotNull((Object)artifact, (String)"artifact cannot be null");
        return this.readArtifactDescriptor(artifact, remoteRepositories).getDependencies();
    }

    public List<File> resolveDependencies(Dependency root, List<Dependency> directDependencies, List<Dependency> managedDependencies, DependencyFilter dependencyFilter, List<RemoteRepository> remoteRepositories) throws DependencyCollectionException, DependencyResolutionException {
        DependencyNode node;
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(root);
        collectRequest.setDependencies(directDependencies);
        collectRequest.setManagedDependencies(managedDependencies);
        collectRequest.setRepositories(this.resolveRepositories(remoteRepositories));
        try {
            this.logger.debug("Collecting dependencies for '{}'", (Object)this.printCollectRequest(collectRequest));
            node = this.repositoryState.getSystem().collectDependencies((RepositorySystemSession)this.repositoryState.getSession(), collectRequest).getRoot();
            this.logDependencyGraph(node, collectRequest);
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setRoot(node);
            dependencyRequest.setCollectRequest(collectRequest);
            dependencyRequest.setFilter((node1, parents) -> !node1.getData().containsKey("aether.conflictResolver.verbose") && (dependencyFilter == null || dependencyFilter.accept(node1, parents)));
            node = this.repositoryState.getSystem().resolveDependencies((RepositorySystemSession)this.repositoryState.getSession(), dependencyRequest).getRoot();
        }
        catch (DependencyResolutionException e) {
            this.logger.warn("Dependencies couldn't be resolved for request '{}', {}", (Object)collectRequest, (Object)e.getMessage());
            DependencyNode node2 = e.getResult().getRoot();
            this.logUnresolvedArtifacts(node2, e);
            throw e;
        }
        List<File> files = this.getFiles(node);
        return files;
    }

    private String printCollectRequest(CollectRequest collectRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator iterator = collectRequest.getRepositories().iterator();
        while (iterator.hasNext()) {
            RemoteRepository remoteRepository = (RemoteRepository)iterator.next();
            stringBuilder.append(remoteRepository);
            stringBuilder.append("->authentication[");
            if (remoteRepository.getAuthentication() != null) {
                stringBuilder.append(remoteRepository.getAuthentication());
            }
            stringBuilder.append("]");
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return collectRequest.getRoot() + " -> " + collectRequest.getDependencies() + " < " + stringBuilder.toString();
    }

    private List<RemoteRepository> resolveRepositories() {
        return this.resolveRepositories(Collections.emptyList());
    }

    private List<RemoteRepository> resolveRepositories(List<RemoteRepository> remoteRepositories) {
        return this.repositoryState.getSystem().newResolutionRepositories((RepositorySystemSession)this.repositoryState.getSession(), Stream.of(remoteRepositories, this.resolutionContext.getRemoteRepositories()).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private void logDependencyGraph(DependencyNode node, Object request) {
        if (this.logger.isTraceEnabled()) {
            PathRecordingDependencyVisitor visitor = new PathRecordingDependencyVisitor(null, false);
            node.accept((DependencyVisitor)visitor);
            this.logger.trace("******* Dependency Graph calculated for {} with request: '{}' *******", (Object)request.getClass().getSimpleName(), request);
            visitor.getPaths().stream().forEach(pathList -> this.logger.trace(Joiner.on((String)" -> ").join((Iterable)pathList.stream().filter(path -> path != null).collect(Collectors.toList()))));
            this.logger.trace("******* End of dependency Graph *******");
        }
    }

    private List<File> getFiles(DependencyNode node) {
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        node.accept((DependencyVisitor)nlg);
        return nlg.getFiles().stream().map(File::getAbsoluteFile).collect(Collectors.toList());
    }

    private void logUnresolvedArtifacts(DependencyNode node, DependencyResolutionException e) {
        List artifactResults = e.getResult().getArtifactResults().stream().filter(artifactResult -> !artifactResult.getExceptions().isEmpty()).collect(Collectors.toList());
        List patternInclusion = artifactResults.stream().map(artifactResult -> ArtifactIdUtils.toId((Artifact)artifactResult.getRequest().getArtifact())).collect(Collectors.toList());
        PathRecordingDependencyVisitor visitor = new PathRecordingDependencyVisitor((DependencyFilter)new PatternInclusionsDependencyFilter(patternInclusion), node.getArtifact() != null);
        node.accept((DependencyVisitor)visitor);
        visitor.getPaths().stream().forEach(path -> {
            List unresolvedArtifactPath = path.stream().filter(dependencyNode -> dependencyNode.getArtifact() != null).collect(Collectors.toList());
            if (!unresolvedArtifactPath.isEmpty()) {
                this.logger.warn("Dependency path to not resolved artifacts -> {}", (Object)unresolvedArtifactPath.toString());
            }
        });
    }
}

