/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classloader.container;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.collections4.IteratorUtils;
import org.mule.runtime.api.util.MuleSystemProperties;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleContainerClassLoaderWrapper;
import org.mule.runtime.container.internal.ContainerClassLoaderFactory;
import org.mule.runtime.container.internal.JreModuleDiscoverer;
import org.mule.runtime.container.internal.PreFilteredContainerClassLoaderCreator;
import org.mule.runtime.jpms.api.JpmsUtils;
import org.mule.runtime.jpms.api.MuleContainerModule;
import org.mule.runtime.jpms.api.MultiLevelClassLoaderFactory;
import org.mule.test.runner.classloader.container.TestContainerClassLoaderAssembler;
import org.mule.test.runner.classloader.container.TestPreFilteredContainerClassLoaderCreator;

public class DefaultTestContainerClassLoaderAssembler
implements TestContainerClassLoaderAssembler {
    public static final String TEST_RUNNER_LEGACY_LAYER_HIERARCHY_MODE = "test.runner.legacy.layer.hierarchy";
    private ModuleRepository moduleRepository;
    private final List<String> extraBootPackages;
    private final List<String> extraBootResources;
    private final Set<String> extraPrivilegedArtifacts;
    private final URL[] muleApisOptUrls;
    private final URL[] muleApisUrls;
    private final URL[] optUrls;
    private final URL[] muleUrls;

    public DefaultTestContainerClassLoaderAssembler(List<String> extraBootPackages, List<String> extraBootResources, Set<String> extraPrivilegedArtifacts, List<URL> muleApisOptUrls, List<URL> muleApisUrls, List<URL> optUrls, List<URL> muleUrls) {
        this.extraBootPackages = extraBootPackages;
        this.extraBootResources = extraBootResources;
        this.extraPrivilegedArtifacts = extraPrivilegedArtifacts;
        this.muleApisOptUrls = muleApisOptUrls.toArray(new URL[muleApisOptUrls.size()]);
        this.muleApisUrls = muleApisUrls.toArray(new URL[muleApisUrls.size()]);
        this.optUrls = optUrls.toArray(new URL[optUrls.size()]);
        this.muleUrls = muleUrls.toArray(new URL[muleUrls.size()]);
    }

    @Override
    public MuleContainerClassLoaderWrapper createContainerClassLoader() {
        ClassLoader containerSystemClassloader;
        HashSet<String> bootPackages = new HashSet<String>();
        bootPackages.addAll(this.extraBootPackages);
        bootPackages.addAll(PreFilteredContainerClassLoaderCreator.BOOT_PACKAGES);
        bootPackages.addAll(((MuleContainerModule)new JreModuleDiscoverer().discover().get(0)).getExportedPackages());
        ClassLoader launcherArtifact = this.createLauncherClassLoader(bootPackages, new HashSet<String>(this.extraBootResources));
        if (Boolean.getBoolean(TEST_RUNNER_LEGACY_LAYER_HIERARCHY_MODE)) {
            URL[] fullOptUrls = (URL[])Stream.of(this.muleApisOptUrls, this.optUrls).flatMap(Stream::of).toArray(URL[]::new);
            URL[] fullMuleUrls = (URL[])Stream.of(this.muleApisUrls, this.muleUrls).flatMap(Stream::of).toArray(URL[]::new);
            containerSystemClassloader = JpmsUtils.createModuleLayerClassLoader((URL[])fullOptUrls, (URL[])fullMuleUrls, (MultiLevelClassLoaderFactory)MultiLevelClassLoaderFactory.MULTI_LEVEL_URL_CLASSLOADER_FACTORY, (ClassLoader)launcherArtifact);
        } else {
            ClassLoader muleApisOptClassloader = JpmsUtils.createModuleLayerClassLoader((URL[])this.muleApisOptUrls, (ClassLoader)launcherArtifact);
            Class<?> muleApisOptClass = this.loadClass("org.apache.commons.lang3.StringUtils", muleApisOptClassloader);
            ClassLoader muleApisClassloader = JpmsUtils.createModuleLayerClassLoader((URL[])this.muleApisUrls, (ClassLoader)muleApisOptClassloader, Collections.singletonList(muleApisOptClass));
            ClassLoader optClassloaderParent = MuleSystemProperties.classloaderContainerJpmsModuleLayer() ? muleApisOptClassloader : muleApisClassloader;
            ClassLoader optClassloader = JpmsUtils.createModuleLayerClassLoader((URL[])this.optUrls, (ClassLoader)optClassloaderParent, Collections.singletonList(muleApisOptClass));
            Class<?> muleImplementationsLoaderUtilsClass = this.loadClass("org.mule.runtime.api.util.classloader.MuleImplementationLoaderUtils", muleApisClassloader);
            Class<?> optClass = this.loadClass("org.mule.maven.client.api.MavenClient", optClassloader);
            ClassLoader containerSystemClassloaderParent = MuleSystemProperties.classloaderContainerJpmsModuleLayer() ? muleApisClassloader : optClassloader;
            containerSystemClassloader = JpmsUtils.createModuleLayerClassLoader((URL[])this.muleUrls, (ClassLoader)containerSystemClassloaderParent, Arrays.asList(muleImplementationsLoaderUtilsClass, optClass));
            try {
                muleImplementationsLoaderUtilsClass.getMethod("setMuleImplementationsLoader", ClassLoader.class).invoke(null, containerSystemClassloader);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        TestPreFilteredContainerClassLoaderCreator testContainerClassLoaderCreator = new TestPreFilteredContainerClassLoaderCreator(containerSystemClassloader, bootPackages, this.extraPrivilegedArtifacts);
        this.moduleRepository = testContainerClassLoaderCreator.getModuleRepository();
        return new ContainerClassLoaderFactory((PreFilteredContainerClassLoaderCreator)testContainerClassLoaderCreator, cl -> launcherArtifact).createContainerClassLoader(containerSystemClassloader);
    }

    private Class<?> loadClass(String name, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected ClassLoader createLauncherClassLoader(Set<String> extraBootPackages, Set<String> extraBootResources) {
        return new TestLauncherClassLoader(this.getClass().getClassLoader(), extraBootPackages, extraBootResources);
    }

    @Override
    public ModuleRepository getModuleRepository() {
        return this.moduleRepository;
    }

    private static final class TestLauncherClassLoader
    extends ClassLoader {
        private final Set<String> extraBootPackages;
        private final Set<String> extraBootResources;

        private TestLauncherClassLoader(ClassLoader parent, Set<String> extraBootPackages, Set<String> extraBootResources) {
            super(parent);
            this.extraBootPackages = extraBootPackages;
            this.extraBootResources = extraBootResources;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.extraBootPackages.stream().anyMatch(bp -> name.startsWith((String)bp))) {
                return super.loadClass(name, resolve);
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        public URL getResource(String name) {
            if (this.extraBootResources.contains(name)) {
                try {
                    return new File(name).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            if (this.extraBootPackages.stream().anyMatch(bp -> name.startsWith("META-INF/services/" + bp))) {
                return super.getResource(name);
            }
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (this.extraBootPackages.stream().anyMatch(bp -> name.startsWith("META-INF/services/" + bp))) {
                return super.getResources(name);
            }
            return Collections.emptyEnumeration();
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            Enumeration<URL> resourceUrls = super.findResources(name);
            return IteratorUtils.asEnumeration(Collections.list(resourceUrls).stream().filter(url -> this.jreResource(name, (URL)url)).iterator());
        }

        @Override
        public URL findResource(String name) {
            URL url = super.findResource(name);
            if (this.jreResource(name, url)) {
                return url;
            }
            return null;
        }

        private boolean jreResource(String name, URL url) {
            if (url == null && this.getParent() != null) {
                url = this.getParent().getResource(name);
                return url != null && url.getFile().matches(".*?\\/jre\\/lib\\/\\w+\\.jar\\!.*");
            }
            return true;
        }

        static {
            TestLauncherClassLoader.registerAsParallelCapable();
        }
    }
}

