/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classloader;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.container.api.ContainerDependantArtifactClassLoaderFactory;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleContainerClassLoaderWrapper;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.jpms.api.MuleContainerModule;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginDescriptorResolver;
import org.mule.runtime.module.artifact.activation.internal.classloader.DefaultArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.internal.classloader.MuleApplicationClassLoader;
import org.mule.runtime.module.artifact.activation.internal.nativelib.DefaultNativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFilterFactory;
import org.mule.runtime.module.artifact.api.classloader.ChildFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderFilterFactory;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DefaultArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.FilteringArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.classloader.exception.ArtifactClassloaderCreationException;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.internal.util.FileJarExplorer;
import org.mule.runtime.module.artifact.internal.util.JarInfo;
import org.mule.runtime.module.service.api.artifact.ServiceClassLoaderFactory;
import org.mule.runtime.module.service.api.artifact.ServiceClassLoaderFactoryProvider;
import org.mule.runtime.module.service.api.artifact.ServiceDescriptor;
import org.mule.test.runner.api.ArtifactClassLoaderHolder;
import org.mule.test.runner.api.ArtifactsUrlClassification;
import org.mule.test.runner.api.PluginUrlClassification;
import org.mule.test.runner.api.ServiceUrlClassification;
import org.mule.test.runner.classloader.PluginLookPolicyFactory;
import org.mule.test.runner.classloader.TestArtifactClassLoaderFilter;
import org.mule.test.runner.classloader.TestRegionClassLoader;
import org.mule.test.runner.classloader.container.TestContainerClassLoaderAssembler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatedClassLoaderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsolatedClassLoaderFactory.class);
    private static final String APP_NAME = "app";
    private final ClassLoaderFilterFactory classLoaderFilterFactory = new ArtifactClassLoaderFilterFactory();
    private final PluginLookPolicyFactory pluginLookupPolicyGenerator = new PluginLookPolicyFactory();

    public ArtifactClassLoaderHolder createArtifactClassLoader(List<String> extraBootPackages, List<String> extraBootResources, Set<String> extraPrivilegedArtifacts, ArtifactsUrlClassification artifactsUrlClassification) {
        HashMap<String, LookupStrategy> appExportedLookupStrategies = new HashMap<String, LookupStrategy>();
        JarInfo testJarInfo = this.getAppSharedPackages(artifactsUrlClassification.getApplicationSharedLibUrls());
        testJarInfo.getPackages().stream().forEach(p -> appExportedLookupStrategies.put((String)p, ParentFirstLookupStrategy.PARENT_FIRST));
        ArrayList<ArtifactClassLoader> filteredPluginsArtifactClassLoaders = new ArrayList<ArtifactClassLoader>();
        ArrayList<ArtifactClassLoader> pluginsArtifactClassLoaders = new ArrayList<ArtifactClassLoader>();
        ArrayList<ArtifactClassLoaderFilter> pluginArtifactClassLoaderFilters = new ArrayList<ArtifactClassLoaderFilter>();
        try {
            TestContainerClassLoaderAssembler testContainerClassLoaderAssembler = TestContainerClassLoaderAssembler.create(extraBootPackages, extraBootResources, extraPrivilegedArtifacts, artifactsUrlClassification.getContainerMuleApisOptUrls(), artifactsUrlClassification.getContainerMuleApisUrls(), artifactsUrlClassification.getContainerOptUrls(), artifactsUrlClassification.getContainerMuleUrls());
            HashMap pluginsLookupStrategies = new HashMap();
            List<PluginUrlClassification> pluginUrlClassifications = artifactsUrlClassification.getPluginUrlClassifications();
            for (PluginUrlClassification pluginUrlClassification : pluginUrlClassifications) {
                pluginUrlClassification.getExportedPackages().forEach(p -> pluginsLookupStrategies.put(p, ParentFirstLookupStrategy.PARENT_FIRST));
            }
            MuleContainerClassLoaderWrapper containerClassLoaderWrapper = testContainerClassLoaderAssembler.createContainerClassLoader();
            ModuleRepository moduleRepository = testContainerClassLoaderAssembler.getModuleRepository();
            ServiceClassLoaderFactoryProvider.setWithinModularizedContainer((boolean)true);
            ServiceClassLoaderFactory serviceClassLoaderFactory = ServiceClassLoaderFactoryProvider.serviceClassLoaderFactory();
            serviceClassLoaderFactory.setParentLayerFrom(containerClassLoaderWrapper.getContainerClassLoader().getClassLoader().loadClass(ServiceClassLoaderFactory.class.getName()));
            List<ArtifactClassLoader> serviceArtifactClassLoaders = this.createServiceClassLoaders((ContainerDependantArtifactClassLoaderFactory<ServiceDescriptor>)serviceClassLoaderFactory, containerClassLoaderWrapper, artifactsUrlClassification);
            ClassLoaderLookupPolicy childClassLoaderLookupPolicy = containerClassLoaderWrapper.getContainerClassLoaderLookupPolicy();
            TestRegionClassLoader regionClassLoader = new TestRegionClassLoader(containerClassLoaderWrapper.getContainerClassLoader().getClassLoader(), childClassLoaderLookupPolicy);
            ClassLoaderLookupPolicy appLookupPolicy = childClassLoaderLookupPolicy.extend(pluginsLookupStrategies);
            MuleApplicationClassLoader appClassLoader = this.createApplicationArtifactClassLoader((ClassLoader)((Object)regionClassLoader), appLookupPolicy, artifactsUrlClassification);
            regionClassLoader.addClassLoader((ArtifactClassLoader)appClassLoader, (ArtifactClassLoaderFilter)new DefaultArtifactClassLoaderFilter(testJarInfo.getPackages(), testJarInfo.getResources()));
            DefaultArtifactClassLoaderResolver artifactClassLoaderResolver = new DefaultArtifactClassLoaderResolver(containerClassLoaderWrapper.getContainerClassLoader(), moduleRepository, null);
            HashMap<String, BundleDescriptor> descriptors = new HashMap<String, BundleDescriptor>();
            if (!pluginUrlClassifications.isEmpty()) {
                for (PluginUrlClassification pluginUrlClassification : pluginUrlClassifications) {
                    this.logClassLoaderUrls("PLUGIN (" + pluginUrlClassification.getName() + ")", pluginUrlClassification.getUrls());
                    descriptors.put(pluginUrlClassification.getName(), pluginUrlClassification.getPluginBundleDescriptor());
                    ArtifactClassLoader pluginCL = this.createPluginClassLoader((ArtifactClassLoaderResolver)artifactClassLoaderResolver, descriptors, pluginUrlClassification, appClassLoader);
                    pluginsArtifactClassLoaders.add(pluginCL);
                    ArtifactClassLoaderFilter filter = this.createArtifactClassLoaderFilter(pluginUrlClassification, testJarInfo.getPackages(), childClassLoaderLookupPolicy);
                    pluginArtifactClassLoaderFilters.add(filter);
                    filteredPluginsArtifactClassLoaders.add((ArtifactClassLoader)new FilteringArtifactClassLoader(pluginCL, (ClassLoaderFilter)filter, Collections.emptyList()));
                }
                this.createTestRunnerPlugin(artifactsUrlClassification, appExportedLookupStrategies, childClassLoaderLookupPolicy, regionClassLoader, filteredPluginsArtifactClassLoaders, pluginsArtifactClassLoaders, pluginArtifactClassLoaderFilters, moduleRepository, containerClassLoaderWrapper, testJarInfo.getPackages());
            }
            for (int i = 0; i < filteredPluginsArtifactClassLoaders.size(); ++i) {
                ArtifactClassLoaderFilter classLoaderFilter = (ArtifactClassLoaderFilter)pluginArtifactClassLoaderFilters.get(i);
                regionClassLoader.addClassLoader((ArtifactClassLoader)filteredPluginsArtifactClassLoaders.get(i), classLoaderFilter);
            }
            return new ArtifactClassLoaderHolder(containerClassLoaderWrapper.getContainerClassLoader(), serviceArtifactClassLoaders, pluginsArtifactClassLoaders, (ArtifactClassLoader)appClassLoader);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private ArtifactClassLoader createPluginClassLoader(ArtifactClassLoaderResolver artifactClassLoaderResolver, Map<String, BundleDescriptor> descriptors, PluginUrlClassification pluginUrlClassification, MuleApplicationClassLoader appClassLoader) {
        JarInfo pluginLibrariesPackages = this.getLibraryPackages(pluginUrlClassification.getUrls());
        ArtifactPluginDescriptor pluginDescriptor = new ArtifactPluginDescriptor(pluginUrlClassification.getName());
        pluginDescriptor.setClassLoaderConfiguration(new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder().containing(pluginUrlClassification.getUrls()).exportingPackages(pluginUrlClassification.getExportedPackages()).exportingResources(pluginUrlClassification.getExportedResources()).exportingPrivilegedPackages(pluginUrlClassification.getPrivilegedExportedPackages(), pluginUrlClassification.getPrivilegedArtifacts()).withLocalPackages(pluginLibrariesPackages.getPackages()).withLocalResources(pluginLibrariesPackages.getResources()).dependingOn(pluginUrlClassification.getPluginDependencies().stream().map(descriptors::get).map(d -> new BundleDependency.Builder().setDescriptor(d).build()).collect(Collectors.toSet())).build());
        pluginDescriptor.setBundleDescriptor(pluginUrlClassification.getPluginBundleDescriptor());
        return artifactClassLoaderResolver.createMulePluginClassLoader((MuleDeployableArtifactClassLoader)appClassLoader, pluginDescriptor, PluginDescriptorResolver.pluginDescriptorResolver());
    }

    private JarInfo getAppSharedPackages(List<URL> pluginSharedLibUrls) {
        ArrayList libraries = Lists.newArrayList();
        libraries.addAll(pluginSharedLibUrls);
        return this.getLibraryPackages(libraries);
    }

    private JarInfo getLibraryPackages(List<URL> libraries) {
        TreeSet packages = new TreeSet();
        TreeSet resources = new TreeSet();
        FileJarExplorer jarExplorer = new FileJarExplorer(false);
        for (URL library : libraries) {
            try {
                JarInfo jarInfo = jarExplorer.explore(library.toURI());
                packages.addAll(jarInfo.getPackages());
                resources.addAll(jarInfo.getResources());
            }
            catch (URISyntaxException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return new JarInfo(packages, resources, Collections.emptyList());
    }

    private void createTestRunnerPlugin(ArtifactsUrlClassification artifactsUrlClassification, Map<String, LookupStrategy> appExportedLookupStrategies, ClassLoaderLookupPolicy childClassLoaderLookupPolicy, RegionClassLoader regionClassLoader, List<ArtifactClassLoader> filteredPluginsArtifactClassLoaders, List<ArtifactClassLoader> pluginsArtifactClassLoaders, List<ArtifactClassLoaderFilter> pluginArtifactClassLoaderFilters, ModuleRepository moduleRepository, MuleContainerClassLoaderWrapper containerClassLoaderWrapper, Set<String> parentExportedPackages) {
        JarInfo testRunnerJarInfo = this.getTestRunnerJarInfo(artifactsUrlClassification);
        String testRunnerArtifactId = DefaultRegionPluginClassLoadersFactory.getArtifactPluginId((String)regionClassLoader.getArtifactId(), (String)"test-runner");
        List<String> pluginDependencies = artifactsUrlClassification.getPluginUrlClassifications().stream().map(PluginUrlClassification::getName).collect(Collectors.toList());
        PluginUrlClassification testRunnerPluginClassification = new PluginUrlClassification("org.mule.tests.plugin:mule-tests-runner-plugin:", artifactsUrlClassification.getTestRunnerLibUrls(), Collections.emptyList(), new BundleDescriptor.Builder().setGroupId("org.mule.test").setArtifactId(testRunnerArtifactId).setVersion("0.0.1").build(), pluginDependencies, testRunnerJarInfo.getPackages(), testRunnerJarInfo.getResources(), Collections.emptySet(), Collections.emptySet());
        ClassLoaderLookupPolicy pluginLookupPolicy = this.extendLookupPolicyForPrivilegedAccess(childClassLoaderLookupPolicy, moduleRepository, containerClassLoaderWrapper, testRunnerPluginClassification);
        pluginLookupPolicy = pluginLookupPolicy.extend(appExportedLookupStrategies);
        MuleArtifactClassLoader pluginCL = new MuleArtifactClassLoader(testRunnerArtifactId, new ArtifactDescriptor(testRunnerPluginClassification.getName()), testRunnerPluginClassification.getUrls().toArray(new URL[0]), (ClassLoader)regionClassLoader, this.pluginLookupPolicyGenerator.createLookupPolicy(testRunnerPluginClassification, artifactsUrlClassification.getPluginUrlClassifications(), pluginLookupPolicy, pluginsArtifactClassLoaders));
        pluginsArtifactClassLoaders.add((ArtifactClassLoader)pluginCL);
        ArtifactClassLoaderFilter filter = this.createArtifactClassLoaderFilter(testRunnerPluginClassification, parentExportedPackages, childClassLoaderLookupPolicy);
        pluginArtifactClassLoaderFilters.add(filter);
        filteredPluginsArtifactClassLoaders.add((ArtifactClassLoader)new FilteringArtifactClassLoader((ArtifactClassLoader)pluginCL, (ClassLoaderFilter)filter, Collections.emptyList()));
        this.logClassLoaderUrls("PLUGIN (" + testRunnerPluginClassification.getName() + ")", testRunnerPluginClassification.getUrls());
    }

    private JarInfo getTestRunnerJarInfo(ArtifactsUrlClassification artifactsUrlClassification) {
        JarInfo testJarInfo = this.getTestJarInfo(artifactsUrlClassification);
        Set exportedPackages = testJarInfo.getPackages();
        Set exportedResources = testJarInfo.getResources();
        artifactsUrlClassification.getTestRunnerExportedLibUrls().forEach(url -> {
            JarInfo jarInfo = this.getTestCodePackages((URL)url);
            exportedPackages.addAll(jarInfo.getPackages());
            exportedResources.addAll(jarInfo.getResources());
        });
        return new JarInfo(exportedPackages, exportedResources, Collections.emptyList());
    }

    private ClassLoaderLookupPolicy extendLookupPolicyForPrivilegedAccess(ClassLoaderLookupPolicy childClassLoaderLookupPolicy, ModuleRepository moduleRepository, MuleContainerClassLoaderWrapper containerClassLoaderWrapper, PluginUrlClassification pluginUrlClassification) {
        LookupStrategy containerOnlyLookupStrategy = containerClassLoaderWrapper.getContainerClassLoaderLookupPolicy().getClassLookupStrategy(ModuleRepository.class.getName());
        HashMap<String, LookupStrategy> privilegedLookupStrategies = new HashMap<String, LookupStrategy>();
        for (MuleContainerModule module : moduleRepository.getModules()) {
            if (!this.hasPrivilegedApiAccess(pluginUrlClassification, module)) continue;
            for (String packageName : module.getPrivilegedExportedPackages()) {
                privilegedLookupStrategies.put(packageName, containerOnlyLookupStrategy);
            }
        }
        if (privilegedLookupStrategies.isEmpty()) {
            return childClassLoaderLookupPolicy;
        }
        return childClassLoaderLookupPolicy.extend(privilegedLookupStrategies);
    }

    private boolean hasPrivilegedApiAccess(PluginUrlClassification pluginUrlClassification, MuleContainerModule module) {
        return module.getPrivilegedArtifacts().stream().filter(artifact -> pluginUrlClassification.getName().startsWith(artifact + ":")).findFirst().isPresent();
    }

    protected List<ArtifactClassLoader> createServiceClassLoaders(ContainerDependantArtifactClassLoaderFactory<ServiceDescriptor> serviceClassLoaderFactory, MuleContainerClassLoaderWrapper containerClassLoaderWrapper, ArtifactsUrlClassification artifactsUrlClassification) throws ArtifactClassloaderCreationException {
        ArrayList servicesArtifactClassLoaders = Lists.newArrayList();
        for (ServiceUrlClassification serviceUrlClassification : artifactsUrlClassification.getServiceUrlClassifications()) {
            this.logClassLoaderUrls("SERVICE (" + serviceUrlClassification.getArtifactId() + ")", serviceUrlClassification.getUrls());
            ServiceDescriptor descriptor = serviceUrlClassification.getDercriptor();
            ArtifactClassLoader artifactClassLoader = serviceClassLoaderFactory.create(this.getServiceArtifactId(descriptor), (ArtifactDescriptor)descriptor, containerClassLoaderWrapper);
            servicesArtifactClassLoaders.add(artifactClassLoader);
        }
        return servicesArtifactClassLoaders;
    }

    private String getServiceArtifactId(ServiceDescriptor serviceDescriptor) {
        return "service/" + serviceDescriptor.getName();
    }

    private JarInfo getTestJarInfo(ArtifactsUrlClassification artifactsUrlClassification) {
        URL testCodeUrl = artifactsUrlClassification.getTestRunnerLibUrls().get(0);
        if (!FileUtils.toFile((URL)testCodeUrl).getPath().contains("test-classes") && artifactsUrlClassification.getTestRunnerLibUrls().size() > 1) {
            testCodeUrl = artifactsUrlClassification.getTestRunnerLibUrls().get(1);
        }
        Set<String> productionPackages = this.getProductionCodePackages(testCodeUrl);
        JarInfo testJarInfo = this.getTestCodePackages(testCodeUrl);
        Set<String> testPackages = this.sanitizeTestExportedPackages(productionPackages, testJarInfo.getPackages());
        return new JarInfo(testPackages, testJarInfo.getResources(), Collections.emptyList());
    }

    private Set<String> sanitizeTestExportedPackages(Set<String> productionPackages, Set<String> testPackages) {
        TreeSet<String> sanitizedTestPackages = new TreeSet<String>(testPackages);
        this.removePackagesFromTestClassLoader(sanitizedTestPackages, TestContainerClassLoaderAssembler.getSystemPackages());
        this.removePackagesFromTestClassLoader(sanitizedTestPackages, productionPackages);
        return sanitizedTestPackages;
    }

    private JarInfo getTestCodePackages(URL testCodeUrl) {
        ArrayList libraries = Lists.newArrayList((Object[])new URL[]{testCodeUrl});
        return this.getLibraryPackages(libraries);
    }

    private Set<String> getProductionCodePackages(URL testCodeUrl) {
        int index = testCodeUrl.toString().lastIndexOf("test-classes");
        try {
            URI productionCodeUri = new URL(testCodeUrl.toString().substring(0, index) + "classes").toURI();
            if (new File(productionCodeUri).exists()) {
                FileJarExplorer jarExplorer = new FileJarExplorer();
                return jarExplorer.explore(productionCodeUri).getPackages();
            }
            return Collections.emptySet();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void removePackagesFromTestClassLoader(Set<String> packages, Collection<String> systemPackages) {
        HashSet packagesToRemove = new HashSet();
        systemPackages.stream().forEach(systemPackage -> packages.stream().filter(p -> p.startsWith((String)systemPackage)).forEach(p -> packagesToRemove.add(p)));
        packages.removeAll(packagesToRemove);
    }

    private ArtifactClassLoaderFilter createArtifactClassLoaderFilter(PluginUrlClassification pluginUrlClassification, Set<String> parentExportedPackages, ClassLoaderLookupPolicy childClassLoaderLookupPolicy) {
        Set<String> sanitizedExportedPackages = this.sanitizePluginExportedPackages(pluginUrlClassification, parentExportedPackages, childClassLoaderLookupPolicy);
        String exportedPackages = sanitizedExportedPackages.stream().collect(Collectors.joining(", "));
        String exportedResources = pluginUrlClassification.getExportedResources().stream().collect(Collectors.joining(", "));
        ArtifactClassLoaderFilter artifactClassLoaderFilter = this.classLoaderFilterFactory.create(exportedPackages, exportedResources);
        if (!pluginUrlClassification.getExportClasses().isEmpty()) {
            artifactClassLoaderFilter = new TestArtifactClassLoaderFilter(artifactClassLoaderFilter, pluginUrlClassification.getExportClasses());
        }
        return artifactClassLoaderFilter;
    }

    private Set<String> sanitizePluginExportedPackages(PluginUrlClassification pluginUrlClassification, Set<String> parentExportedPackages, ClassLoaderLookupPolicy childClassLoaderLookupPolicy) {
        Set appProvidedPackages;
        HashSet<String> exportedPackages = new HashSet<String>(pluginUrlClassification.getExportedPackages());
        Set containerProvidedPackages = exportedPackages.stream().filter(p -> {
            LookupStrategy lookupStrategy = childClassLoaderLookupPolicy.getPackageLookupStrategy(p);
            return !(lookupStrategy instanceof ChildFirstLookupStrategy);
        }).collect(Collectors.toSet());
        if (!containerProvidedPackages.isEmpty()) {
            exportedPackages.removeAll(containerProvidedPackages);
            LOGGER.warn("Exported packages from plugin '" + pluginUrlClassification.getName() + "' are provided by parent class loader: " + String.valueOf(containerProvidedPackages));
        }
        if (!(appProvidedPackages = parentExportedPackages.stream().filter(p -> exportedPackages.contains(p)).collect(Collectors.toSet())).isEmpty()) {
            exportedPackages.removeAll(appProvidedPackages);
            LOGGER.warn("Exported packages from plugin '" + pluginUrlClassification.getName() + "' are provided by the artifact owner: " + String.valueOf(appProvidedPackages));
        }
        return exportedPackages;
    }

    protected MuleApplicationClassLoader createApplicationArtifactClassLoader(ClassLoader parent, ClassLoaderLookupPolicy childClassLoaderLookupPolicy, ArtifactsUrlClassification artifactsUrlClassification) {
        ArrayList<URL> applicationUrls = new ArrayList<URL>();
        applicationUrls.addAll(artifactsUrlClassification.getApplicationLibUrls());
        applicationUrls.addAll(artifactsUrlClassification.getApplicationSharedLibUrls());
        this.logClassLoaderUrls("APP", applicationUrls);
        ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(APP_NAME);
        return new MuleApplicationClassLoader(APP_NAME, (ArtifactDescriptor)applicationDescriptor, parent, new DefaultNativeLibraryFinderFactory().create(APP_NAME, applicationDescriptor.getLoadedNativeLibrariesFolderName(), applicationUrls.toArray(new URL[applicationUrls.size()])), applicationUrls, childClassLoaderLookupPolicy);
    }

    protected void logClassLoaderUrls(String classLoaderName, List<URL> urls) {
        StringBuilder builder = new StringBuilder(classLoaderName).append(" classloader urls: [");
        urls.stream().forEach(e -> builder.append("\n").append(" ").append(e));
        builder.append("\n]");
        this.logClassLoadingTrace(builder.toString());
    }

    private void logClassLoadingTrace(String message) {
        if (this.isVerboseClassLoading().booleanValue()) {
            LOGGER.info(message);
        } else {
            LOGGER.debug(message);
        }
    }

    private Boolean isVerboseClassLoading() {
        return Boolean.valueOf(System.getProperty("mule.classloading.verbose"));
    }
}

