/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mule.test.runner.ArtifactClassLoaderRunnerConfig;
import org.mule.test.runner.utils.AnnotationUtils;

public class RunnerConfiguration {
    private static final String PROVIDED_EXCLUSIONS = "providedExclusions";
    private static final String TEST_EXCLUSIONS = "testExclusions";
    private static final String TEST_INCLUSIONS = "testInclusions";
    private static final String EXPORT_PLUGIN_CLASSES = "exportPluginClasses";
    private static final String SHARED_RUNTIME_LIBS = "sharedRuntimeLibs";
    private static final String EXTRA_PRIVILEGED_ARTIFACTS = "extraPrivilegedArtifacts";
    private Set<String> providedExclusions;
    private Set<String> testExclusions;
    private Set<String> testInclusions;
    private Set<Class> exportPluginClasses;
    private Set<String> sharedRuntimeLibs;
    private Set<String> extraPrivilegedArtifacts;
    private String loadedFromTestClass;

    private RunnerConfiguration(Class loadedFromTestClass) {
        this.loadedFromTestClass = loadedFromTestClass.getName();
    }

    public Set<Class> getExportPluginClasses() {
        return this.exportPluginClasses;
    }

    public Set<String> getProvidedExclusions() {
        return this.providedExclusions;
    }

    public Set<String> getSharedRuntimeLibs() {
        return this.sharedRuntimeLibs;
    }

    public Set<String> getTestExclusions() {
        return this.testExclusions;
    }

    public Set<String> getTestInclusions() {
        return this.testInclusions;
    }

    public Set<String> getExtraPrivilegedArtifacts() {
        return this.extraPrivilegedArtifacts;
    }

    public static RunnerConfiguration readConfiguration(Class klass) {
        RunnerConfiguration runnerConfiguration = new RunnerConfiguration(klass);
        Class testClass = klass;
        runnerConfiguration.providedExclusions = new HashSet<String>(RunnerConfiguration.readAttribute(PROVIDED_EXCLUSIONS, testClass));
        runnerConfiguration.testExclusions = new HashSet<String>(RunnerConfiguration.readAttribute(TEST_EXCLUSIONS, testClass));
        runnerConfiguration.testInclusions = new HashSet<String>(RunnerConfiguration.readAttribute(TEST_INCLUSIONS, testClass));
        runnerConfiguration.exportPluginClasses = new HashSet<Class>(RunnerConfiguration.readAttribute(EXPORT_PLUGIN_CLASSES, testClass));
        runnerConfiguration.sharedRuntimeLibs = new HashSet<String>(RunnerConfiguration.readAttribute(SHARED_RUNTIME_LIBS, testClass));
        runnerConfiguration.extraPrivilegedArtifacts = new HashSet<String>(RunnerConfiguration.readAttribute(EXTRA_PRIVILEGED_ARTIFACTS, testClass));
        return runnerConfiguration;
    }

    private static <E> List<E> readAttribute(String name, Class<?> klass) {
        List valuesList = AnnotationUtils.getAnnotationAttributeFromHierarchy(klass, ArtifactClassLoaderRunnerConfig.class, name);
        return valuesList.stream().flatMap(Arrays::stream).distinct().collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunnerConfiguration that = (RunnerConfiguration)o;
        if (!this.providedExclusions.equals(that.providedExclusions)) {
            return false;
        }
        if (!this.testExclusions.equals(that.testExclusions)) {
            return false;
        }
        if (!this.testInclusions.equals(that.testInclusions)) {
            return false;
        }
        if (!this.exportPluginClasses.equals(that.exportPluginClasses)) {
            return false;
        }
        return this.sharedRuntimeLibs.equals(that.sharedRuntimeLibs);
    }

    public int hashCode() {
        int result = this.providedExclusions.hashCode();
        result = 31 * result + this.testExclusions.hashCode();
        result = 31 * result + this.testInclusions.hashCode();
        result = 31 * result + this.exportPluginClasses.hashCode();
        result = 31 * result + this.sharedRuntimeLibs.hashCode();
        return result;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

