/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.mule.test.runner.ArtifactClassLoaderRunnerConfig;
import org.mule.test.runner.utils.AnnotationUtils;

public class RunnerConfiguration {
    private static final String PROVIDED_EXCLUSIONS = "providedExclusions";
    private static final String PROVIDED_INCLUSIONS = "providedInclusions";
    private static final String TEST_EXCLUSIONS = "testExclusions";
    private static final String TEST_INCLUSIONS = "testInclusions";
    private static final String EXPORT_PLUGIN_CLASSES = "exportPluginClasses";
    private static final String SHARED_RUNTIME_LIBS = "sharedRuntimeLibs";
    private List<String> providedExclusions;
    private List<String> testExclusions;
    private List<String> testInclusions;
    private List<Class> exportPluginClasses;
    private List<String> sharedRuntimeLibs;
    private String loadedFromTestClass;

    private RunnerConfiguration(Class loadedFromTestClass) {
        this.loadedFromTestClass = loadedFromTestClass.getName();
    }

    public List<Class> getExportPluginClasses() {
        return this.exportPluginClasses;
    }

    public List<String> getProvidedExclusions() {
        return this.providedExclusions;
    }

    public List<String> getSharedRuntimeLibs() {
        return this.sharedRuntimeLibs;
    }

    public List<String> getTestExclusions() {
        return this.testExclusions;
    }

    public List<String> getTestInclusions() {
        return this.testInclusions;
    }

    public static RunnerConfiguration readConfiguration(Class klass) {
        RunnerConfiguration runnerConfiguration = new RunnerConfiguration(klass);
        Class testClass = klass;
        runnerConfiguration.providedExclusions = RunnerConfiguration.readAttribute(PROVIDED_EXCLUSIONS, testClass);
        runnerConfiguration.testExclusions = RunnerConfiguration.readAttribute(TEST_EXCLUSIONS, testClass);
        runnerConfiguration.testInclusions = RunnerConfiguration.readAttribute(TEST_INCLUSIONS, testClass);
        runnerConfiguration.exportPluginClasses = RunnerConfiguration.readAttribute(EXPORT_PLUGIN_CLASSES, testClass);
        runnerConfiguration.sharedRuntimeLibs = RunnerConfiguration.readAttribute(SHARED_RUNTIME_LIBS, testClass);
        return runnerConfiguration;
    }

    private static <E> List<E> readAttribute(String name, Class<?> klass) {
        List valuesList = AnnotationUtils.getAnnotationAttributeFromHierarchy(klass, ArtifactClassLoaderRunnerConfig.class, name);
        return valuesList.stream().flatMap(Arrays::stream).distinct().collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunnerConfiguration that = (RunnerConfiguration)o;
        if (!this.providedExclusions.equals(that.providedExclusions)) {
            return false;
        }
        if (!this.testExclusions.equals(that.testExclusions)) {
            return false;
        }
        if (!this.testInclusions.equals(that.testInclusions)) {
            return false;
        }
        if (!this.exportPluginClasses.equals(that.exportPluginClasses)) {
            return false;
        }
        return this.sharedRuntimeLibs.equals(that.sharedRuntimeLibs);
    }

    public int hashCode() {
        int result = this.providedExclusions.hashCode();
        result = 31 * result + this.testExclusions.hashCode();
        result = 31 * result + this.testInclusions.hashCode();
        result = 31 * result + this.exportPluginClasses.hashCode();
        result = 31 * result + this.sharedRuntimeLibs.hashCode();
        return result;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

