/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.Collection;
import java.util.HashSet;
import org.mule.AbstractBenchmark;
import org.mule.runtime.core.api.management.stats.ResetOnQueryCounter;
import org.mule.runtime.core.internal.management.stats.DefaultFlowConstructStatistics;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

public class StatisticsBenchmark
extends AbstractBenchmark {
    @Benchmark
    public Object incrementValueNoCounters(MyState state) {
        state.noCounters.incReceivedEvents();
        return state.noCounters.getTotalEventsReceived();
    }

    @Benchmark
    public Object incrementValueOneCounter(MyState state) {
        state.oneCounter.incReceivedEvents();
        return state.oneCounter.getTotalEventsReceived();
    }

    @Benchmark
    public Object incrementValueFiveCounters(MyState state) {
        state.fiveCounters.incReceivedEvents();
        return state.fiveCounters.getTotalEventsReceived();
    }

    @State(value=Scope.Benchmark)
    public static class MyState {
        public DefaultFlowConstructStatistics noCounters = new DefaultFlowConstructStatistics("Flow", "flow0");
        public DefaultFlowConstructStatistics oneCounter = new DefaultFlowConstructStatistics("Flow", "flow1");
        public DefaultFlowConstructStatistics fiveCounters = new DefaultFlowConstructStatistics("Flow", "flow5");
        private ResetOnQueryCounter oneEventsReceivedCounters;
        private Collection<ResetOnQueryCounter> fiveEventsReceivedCounters;

        @Setup(value=Level.Trial)
        public void doSetup() {
            this.oneEventsReceivedCounters = this.oneCounter.getEventsReceivedCounter();
            this.fiveEventsReceivedCounters = new HashSet<ResetOnQueryCounter>();
            for (int i = 0; i < 5; ++i) {
                this.fiveEventsReceivedCounters.add(this.fiveCounters.getEventsReceivedCounter());
            }
        }
    }
}

