/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyChain;
import org.mule.runtime.core.internal.execution.SourcePolicyTestUtils;
import org.mule.runtime.core.internal.policy.CompositeOperationPolicy;
import org.mule.runtime.core.internal.policy.OperationPolicy;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.reactivestreams.Publisher;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class CompositeOperationPolicyBenchmark
extends AbstractBenchmark {
    private OperationPolicy handler;
    private Scheduler fluxCompleteScheduler;

    @Setup(value=Level.Trial)
    public void setUp() throws MuleException {
        MuleContext muleContext = this.createMuleContextWithServices();
        this.fluxCompleteScheduler = muleContext.getSchedulerService().ioScheduler();
        this.handler = new CompositeOperationPolicy((Component)new AbstractComponent(){}, Arrays.asList(new Policy(new PolicyChain(){

            public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
                return publisher;
            }
        }, "")), Optional.empty(), (policy, nextProcessor) -> nextProcessor, muleContext.getConfiguration().getShutdownTimeout(), this.fluxCompleteScheduler);
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        this.fluxCompleteScheduler.stop();
    }

    @Benchmark
    @Threads(value=-1)
    public CoreEvent source() throws Throwable {
        Message.Builder messageBuilder = Message.builder().value((Object)PAYLOAD);
        CoreEvent.Builder eventBuilder = CoreEvent.builder((EventContext)EventContextFactory.create((String)"", (String)"", (ComponentLocation)CONNECTOR_LOCATION, null, Optional.empty())).message(messageBuilder.build());
        CoreEvent event = eventBuilder.build();
        Object value = SourcePolicyTestUtils.block(outerCallback -> {
            CompletableComponentExecutor.ExecutorCallback executorCallback = new CompletableComponentExecutor.ExecutorCallback((CompletableCallback)outerCallback){
                final /* synthetic */ CompletableCallback val$outerCallback;
                {
                    this.val$outerCallback = completableCallback;
                }

                public void complete(Object value) {
                    this.val$outerCallback.complete(value);
                }

                public void error(Throwable e) {
                    this.val$outerCallback.error(e);
                }
            };
            this.handler.process(event, (params, e, callback) -> callback.complete((Object)e), () -> Collections.emptyMap(), CONNECTOR_LOCATION, executorCallback);
        });
        return (CoreEvent)value;
    }
}

