/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Setup;

public class MultiMapBenchmark
extends AbstractBenchmark {
    private MultiMap<String, String> multiMap;

    @Setup
    public void setup() throws Exception {
        this.multiMap = new MultiMap();
        this.multiMap.put((Object)"key1", (Object)"value");
        this.multiMap.put((Object)"key10", Arrays.asList("value1", "value2", "value3", "value4", "value5", "value6", "value7", "value8", "value9", "value10"));
    }

    @Benchmark
    public MultiMap<String, String> iteration() {
        MultiMap targetMap = new MultiMap();
        targetMap.putAll(this.multiMap);
        return targetMap;
    }

    @Benchmark
    public List<Map.Entry<String, String>> entryList() {
        return this.multiMap.entryList();
    }

    @Benchmark
    public MultiMap<String, String> copyWithKeySet() {
        MultiMap targetMap = new MultiMap();
        for (String key : this.multiMap.keySet()) {
            targetMap.put((Object)key, (Collection)this.multiMap.getAll((Object)key));
        }
        return targetMap;
    }

    @Benchmark
    public MultiMap<String, String> copyWithEntryList() {
        MultiMap targetMap = new MultiMap();
        for (Map.Entry entry : this.multiMap.entryList()) {
            targetMap.put((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
        }
        return targetMap;
    }

    @Benchmark
    public CaseInsensitiveMultiMap copy() {
        return new CaseInsensitiveMultiMap(this.multiMap);
    }

    @Benchmark
    public CaseInsensitiveMultiMap putAll() {
        CaseInsensitiveMultiMap mm = new CaseInsensitiveMultiMap();
        mm.putAll(this.multiMap);
        return mm;
    }
}

