/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.Warmup;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.FluxSink;

@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class ProcessorChainBenchmark
extends AbstractBenchmark {
    private static final int NUM_PROCESSORS = 20;
    private static final int STREAM_SIZE = 1000;
    private MessageProcessorChain chain;
    private CoreEvent event;

    @Setup
    public void setup() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        for (int i = 0; i < 20; ++i) {
            builder.chain(new Processor[]{event -> event});
        }
        this.chain = builder.build();
        this.chain.setMuleContext(this.createMuleContextWithServices());
        this.event = CoreEvent.builder((EventContext)EventContextFactory.create((String)"", (String)"", (ComponentLocation)CONNECTOR_LOCATION, (FlowExceptionHandler)NullExceptionHandler.getInstance())).message(Message.of((Object)PAYLOAD)).build();
    }

    @Benchmark
    public CoreEvent blocking() throws MuleException {
        return this.chain.process(this.event);
    }

    @Benchmark
    public CountDownLatch stream() throws MuleException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1000);
        Reference sinkReference = new Reference();
        FluxProcessor.create(arg_0 -> ((Reference)sinkReference).set(arg_0)).transform((Function)this.chain).doOnNext(event -> latch.countDown()).subscribe();
        for (int i = 0; i < 1000; ++i) {
            ((FluxSink)sinkReference.get()).next((Object)this.event);
        }
        ((FluxSink)sinkReference.get()).complete();
        latch.await();
        return latch;
    }
}

