/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el;

import java.util.concurrent.TimeUnit;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.InternalEventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;

@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class ExpressionBenchmark
extends AbstractBenchmark {
    private MuleContext muleContext;
    private InternalEvent event;
    private InternalEventContext context;

    @Setup
    public void setup() throws MuleException {
        this.muleContext = this.createMuleContextWithServices();
        this.context = DefaultEventContext.create((FlowConstruct)this.createFlow(this.muleContext), (ComponentLocation)CONNECTOR_LOCATION);
        this.event = InternalEvent.builder((InternalEventContext)this.context).message(Message.of((Object)PAYLOAD)).addVariable("foo", (Object)"bar").build();
    }

    @TearDown
    public void teardown() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.muleContext.getRegistry().lookupObject(SchedulerService.class));
        this.muleContext.dispose();
    }

    @Benchmark
    public Object melPayload() {
        return this.muleContext.getExpressionManager().evaluate("mel:payload", this.event).getValue();
    }

    @Benchmark
    public Object dwPayload() {
        return this.muleContext.getExpressionManager().evaluate("payload", this.event).getValue();
    }

    @Benchmark
    public Object melFlowVars() {
        return this.muleContext.getExpressionManager().evaluate("mel:flowVars['foo']=='bar'", this.event).getValue();
    }

    @Benchmark
    public Object dwFlowVars() {
        return this.muleContext.getExpressionManager().evaluate("vars.foo == 'bar'", this.event).getValue();
    }

    @Benchmark
    public Object melGetLocale() {
        return this.muleContext.getExpressionManager().evaluate("mel:java.util.Locale.getDefault().getLanguage()", this.event).getValue();
    }

    @Benchmark
    public Object dwGetLocale() {
        return this.muleContext.getExpressionManager().evaluate("java!java::util::Locale::getDefault().language", this.event).getValue();
    }
}

