/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.service;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.mule.components.simple.EchoService;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.test.integration.service.DateService;
import org.mule.test.integration.service.PeopleService;
import org.mule.test.integration.service.Person;
import org.mule.umo.lifecycle.Disposable;
import org.mule.util.StringUtils;

public class TestServiceComponent
extends FunctionalTestComponent
implements EchoService,
DateService,
PeopleService,
Disposable {
    private static final Person[] originalPeople = new Person[]{new Person("Barney", "Rubble"), new Person("Fred", "Flintstone"), new Person("Wilma", "Flintstone")};
    private final Map people = Collections.synchronizedMap(new HashMap());

    public TestServiceComponent() {
        this.people.put("Barney", originalPeople[0]);
        this.people.put("Fred", originalPeople[1]);
        this.people.put("Wilma", originalPeople[2]);
    }

    public String echo(String echo) {
        return echo;
    }

    public String getDate() {
        return new Date().toString();
    }

    public Person getPerson(String firstName) {
        if (StringUtils.isEmpty((String)firstName)) {
            throw new IllegalArgumentException("Name parameter cannot be null");
        }
        return (Person)this.people.get(firstName);
    }

    public Person[] getPeople() {
        return originalPeople;
    }

    public void addPerson(Person person) throws Exception {
        if (person == null || person.getFirstName() == null || person.getLastName() == null) {
            throw new IllegalArgumentException("null person, first name or last name");
        }
        if (person.getFirstName().equals("Ross")) {
            throw new Exception("Ross is banned");
        }
        this.people.put(person.getFirstName(), person);
        this.logger.debug((Object)("Added Person: " + person));
    }

    public Person addPerson(String firstname, String surname) throws Exception {
        Person p = new Person(firstname, surname);
        this.addPerson(p);
        this.logger.debug((Object)("Added Person: " + p));
        return p;
    }

    public void dispose() {
        this.people.clear();
    }
}

