/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.core.api.util.UUID;
import org.mule.tck.junit4.rule.FreePortFinder;
import org.mule.test.infrastructure.process.ConfigurableProcessBuilder;
import org.mule.test.infrastructure.process.ProcessBuilderConfigurer;
import org.mule.test.infrastructure.process.TestProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleContextProcessBuilder
implements Cloneable,
ConfigurableProcessBuilder {
    protected static final transient Logger logger = LoggerFactory.getLogger(MuleContextProcessBuilder.class);
    public static final String MULE_CONTEXT_CONFIGURATION_ID_KEY = "mule.serverId";
    public static final String CONFIG_FILE_KEY = "configFile";
    public static final String TIMEOUT_IN_SECONDS = "processTimeout";
    public static final String LOG_PORT_PROPERTY = "test.log.port";
    public static final String COMMAND_PORT_PROPERTY = "test.command.port";
    public static final String MULE_CORE_EXTENSIONS_PROPERTY = "test.mule.coreextension";
    public static final int DEFAULT_DEBUG_PORT = 5005;
    private final File testDirectory;
    private String muleAppClass;
    private String instanceId = "unknown";
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private FreePortFinder freePortFinder = new FreePortFinder(8000, 60000);
    private List<ProcessBuilderConfigurer> processBuilderConfigurers = new ArrayList<ProcessBuilderConfigurer>();

    public MuleContextProcessBuilder(File testDirectory) {
        this.testDirectory = testDirectory;
        this.systemProperties.put(MULE_CONTEXT_CONFIGURATION_ID_KEY, UUID.getUUID());
        this.systemProperties.put(TIMEOUT_IN_SECONDS, "120");
        this.systemProperties.put("fake.server.disablelogrepositoryselector", "true");
    }

    public MuleContextProcessBuilder(MuleContextProcessBuilder clusteredMuleContextProcessBuilder) {
        this.testDirectory = clusteredMuleContextProcessBuilder.testDirectory;
        this.muleAppClass = clusteredMuleContextProcessBuilder.muleAppClass;
        this.systemProperties = new HashMap<String, String>(clusteredMuleContextProcessBuilder.systemProperties);
    }

    public MuleContextProcessBuilder setApplicationConfigFile(String appConfigFile) {
        this.systemProperties.put(CONFIG_FILE_KEY, appConfigFile);
        return this;
    }

    protected Object clone() throws CloneNotSupportedException {
        return new MuleContextProcessBuilder(this);
    }

    public TestProcess buildInstance(int instanceId) {
        MuleContextProcessBuilder clusteredMuleContextProcessBuilder = new MuleContextProcessBuilder(this);
        clusteredMuleContextProcessBuilder.instanceId = String.valueOf(instanceId);
        clusteredMuleContextProcessBuilder.addConfigurationAttribute(MULE_CONTEXT_CONFIGURATION_ID_KEY, this.getMuleContextConfigurationId());
        clusteredMuleContextProcessBuilder.addConfigurationAttribute("mule.home", this.getMuleHomeDirectoryFor(instanceId));
        clusteredMuleContextProcessBuilder.addConfigurationAttribute(LOG_PORT_PROPERTY, this.freePortFinder.find().toString());
        clusteredMuleContextProcessBuilder.addConfigurationAttribute(COMMAND_PORT_PROPERTY, this.freePortFinder.find().toString());
        for (ProcessBuilderConfigurer processBuilderConfigurer : this.processBuilderConfigurers) {
            processBuilderConfigurer.configure(clusteredMuleContextProcessBuilder.instanceId, clusteredMuleContextProcessBuilder);
        }
        return clusteredMuleContextProcessBuilder.build();
    }

    public String getMuleHomeDirectoryFor(int instanceId) {
        return this.testDirectory.getAbsolutePath() + File.separator + "mule-home-" + instanceId;
    }

    private TestProcess build() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("java");
        command.add("-cp");
        command.add(System.getProperty("java.class.path"));
        if (Boolean.getBoolean("debug")) {
            command.add("-Xdebug");
            int debugPort = this.getDebugPort();
            command.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + debugPort);
            logger.info(String.format("To connect to process %s for debugging use port %d", this.instanceId, debugPort));
        }
        for (String systemPropertyKey : this.systemProperties.keySet()) {
            command.add(String.format("-D%s=%s", systemPropertyKey, this.systemProperties.get(systemPropertyKey)));
        }
        if (this.muleAppClass == null) {
            command.add("org.mule.test.infrastructure.process.MuleContextProcessApplication");
        } else {
            command.add(this.muleAppClass);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            TestProcess testProcess = new TestProcess(this.instanceId, Integer.valueOf(this.systemProperties.get(LOG_PORT_PROPERTY)), Integer.valueOf(this.systemProperties.get(COMMAND_PORT_PROPERTY)));
            Process process = processBuilder.start();
            testProcess.setProcess(process);
            return testProcess;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int getDebugPort() {
        return 5005 + Integer.valueOf(this.instanceId);
    }

    public String getMuleContextConfigurationId() {
        return this.systemProperties.get(MULE_CONTEXT_CONFIGURATION_ID_KEY);
    }

    @Override
    public ConfigurableProcessBuilder addConfigurationAttribute(String propertyName, String propertyValue) {
        this.systemProperties.put(propertyName, propertyValue);
        return this;
    }

    public MuleContextProcessBuilder addProcessBuilderConfigurer(ProcessBuilderConfigurer processBuilderConfigurer) {
        this.processBuilderConfigurers.add(processBuilderConfigurer);
        return this;
    }
}

